/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.outline;

import java.util.ArrayList;

public class ProjectOutlineElement {
    private ProjectOutlineElement parent = null;
    private ArrayList<ProjectOutlineElement> children = new ArrayList();
    private ArrayList<Integer> countList = new ArrayList();
    private int serverUpdatedCount = 0;
    private Object object;

    public void setCount(int count) {
        if (this.countList.size() == 0) {
            this.countList.add(new Integer(count));
        } else {
            Integer oldcnt = this.countList.get(this.countList.size() - 1);
            if (oldcnt != count) {
                this.countList.add(new Integer(count));
            }
        }
    }

    public int getOldCount() {
        if (this.countList.size() > 1) {
            Integer oldCount = this.countList.get(this.countList.size() - 2);
            return oldCount;
        }
        return 0;
    }

    public void resetLocalUpdated() {
        this.countList.clear();
    }

    public boolean isLocalUpdated() {
        return this.countList.size() > 1;
    }

    public void setServerUpdatedCount(int count) {
        if (count > 0) {
            this.serverUpdatedCount = count;
        }
    }

    public void clearServerUpdatedCount() {
        this.serverUpdatedCount = 0;
    }

    public boolean isServerUpdated() {
        return this.serverUpdatedCount > 0;
    }

    public int getServerUpdatedCount() {
        return this.serverUpdatedCount;
    }

    public ProjectOutlineElement() {
    }

    public ProjectOutlineElement(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void addChild(ProjectOutlineElement child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(ProjectOutlineElement child) {
        this.children.remove(child);
        if (child != null) {
            child.setParent(null);
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ProjectOutlineElement getChild(int index) {
        return this.children.get(index);
    }

    public ProjectOutlineElement[] getChildren() {
        return this.children.toArray(new ProjectOutlineElement[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void setParent(ProjectOutlineElement parent) {
        this.parent = parent;
    }

    public ProjectOutlineElement getParent() {
        return this.parent;
    }

    public void removeChildren() {
        this.children.clear();
    }
}

