/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PatternizeAccessPermissionsDialog
extends TitleAreaDialog {
    private IProject project;
    private Domain domain;
    private AccessPermission[] accessPermissions;
    private TableViewer viewer = null;
    private static final String[] COLUMN_PROPERTIES = new String[]{"before", "after"};
    private Button[] radioButtons = new Button[3];
    private Button deleteOptionButton;

    public PatternizeAccessPermissionsDialog(Shell parentShell, IProject project, Domain domain, AccessPermission[] accessPermissions) {
        super(parentShell);
        this.project = project;
        this.domain = domain;
        this.accessPermissions = accessPermissions;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PatternizeAccessPermissionsDialog_ShellTitle);
    }

    protected int getShellStyle() {
        return 1040;
    }

    protected Point getInitialSize() {
        return new Point(800, 700);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            Button okButton = super.createButton(parent, id, label, defaultButton);
            if (this.domain == null) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(this.accessPermissions != null && this.accessPermissions.length > 0);
            }
            return okButton;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.PatternizeAccessPermissionsDialog_DialogAreaTitle);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createViewer(container);
        this.createOptionButtons(container);
        this.createDeleteOptionButton(container);
        this.initializeUI();
        return composite;
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 2048);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.PatternizeAccessPermissionsDialog_ColumnBefore);
        column.setWidth(300);
        column = new TableColumn(table, 16384);
        column.setText(Messages.PatternizeAccessPermissionsDialog_ColumnAfter);
        column.setWidth(300);
        this.viewer.setColumnProperties(COLUMN_PROPERTIES);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        this.viewer.setCellEditors(editors);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PatternizeAccessPermissionsDialog.this.handleTableSelectionChanged();
            }
        });
        this.viewer.setInput((Object)this.accessPermissions);
    }

    private void handleTableSelectionChanged() {
    }

    private void createOptionButtons(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.PatternizeAccessPermissionsDialog_FilePatternizingMethodGroupTitle);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData());
        this.radioButtons[0] = this.createRadioButton((Composite)group, Messages.PatternizeAccessPermissionsDialog_OptionIncludeExtension);
        this.radioButtons[1] = this.createRadioButton((Composite)group, Messages.PatternizeAccessPermissionsDialog_OptionWithoutExtension);
        this.radioButtons[2] = this.createRadioButton((Composite)group, Messages.PatternizeAccessPermissionsDialog_OptionWithoutFilename);
    }

    private void createDeleteOptionButton(Composite composite) {
        this.deleteOptionButton = new Button(composite, 32);
        this.deleteOptionButton.setText(Messages.PatternizeAccessPermissionsDialog_DeleteOptionButton);
        this.deleteOptionButton.setSelection(true);
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternizeAccessPermissionsDialog.this.handleButtonSelected((Button)e.getSource());
            }
        });
        return button;
    }

    private void handleButtonSelected(Button source) {
        ArrayLabelProvider labelProvider = (ArrayLabelProvider)this.viewer.getLabelProvider();
        if (source == this.radioButtons[0]) {
            labelProvider.setPatternizeMethod(0);
        }
        if (source == this.radioButtons[1]) {
            labelProvider.setPatternizeMethod(1);
        }
        if (source == this.radioButtons[2]) {
            labelProvider.setPatternizeMethod(2);
        }
        labelProvider.clearCache();
        this.viewer.refresh();
    }

    private void initializeUI() {
        this.viewer.getControl().setFocus();
        this.radioButtons[1].setSelection(true);
        this.handleButtonSelected(this.radioButtons[1]);
    }

    protected void okPressed() {
        ArrayLabelProvider labelProvider = (ArrayLabelProvider)this.viewer.getLabelProvider();
        String[] saveLines = labelProvider.getUniquePatternArray();
        AccessPermission[] deleteAPs = labelProvider.getPatternizedAccessPermissionArray();
        if (this.save(this.createSaveline(saveLines))) {
            TomoyoCorePlugin.getDefault().setStatusMessage(Messages.PatternizeAccessPermissionsDialog_StatusMessagePattenizedOK, true);
            if (this.deleteOptionButton.getSelection()) {
                if (this.delete(deleteAPs)) {
                    TomoyoCorePlugin.getDefault().setStatusMessage(Messages.PatternizeAccessPermissionsDialog_StatusMessageDeletePattenizedOK, true);
                    this.synchronize();
                    super.okPressed();
                } else {
                    this.synchronize();
                    this.setErrorMessage(Messages.PatternizeAccessPermissionsDialog_DeleteNGMessage);
                    this.getButton(0).setEnabled(false);
                }
            }
        } else {
            this.setErrorMessage(Messages.PatternizeAccessPermissionsDialog_SaveNGMessage);
            this.getButton(0).setEnabled(false);
        }
    }

    private void synchronize() {
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        ProcResourceManager.getInstance().synchronize(this.project, (LocalResource)domainPolicy);
    }

    public String createSaveline(String[] saveLines) {
        StringBuffer input = new StringBuffer();
        input.append(this.domain.getText());
        input.append("\n");
        int cnt = 0;
        while (cnt < saveLines.length) {
            input.append(saveLines[cnt]);
            input.append("\n");
            ++cnt;
        }
        return input.toString();
    }

    private boolean save(String saveLine) {
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        WriteCommand command = CommandManager.getInstance().write(this.project, (LocalResource)domainPolicy, saveLine);
        return command.isSuccessful();
    }

    private boolean delete(AccessPermission[] deleteAPs) {
        DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
        WriteCommand command = CommandManager.getInstance().write(this.project, (LocalResource)domainPolicy, this.createDeleteline(deleteAPs));
        if (command.isSuccessful()) {
            return true;
        }
        String message = Messages.PatternizeAccessPermissionsDialog_DeleteNGMessage;
        TomoyoCorePlugin.getDefault().setStatusMessage(message);
        return false;
    }

    public String createDeleteline(AccessPermission[] deleteAPs) {
        StringBuffer input = new StringBuffer();
        input.append(this.domain.getText());
        input.append("\n");
        int cnt = 0;
        while (cnt < deleteAPs.length) {
            AccessPermission access = deleteAPs[cnt];
            input.append("delete");
            input.append(" ");
            input.append(access.getText());
            input.append("\n");
            ++cnt;
        }
        return input.toString();
    }

    private class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private Hashtable<String, String> foretxTable = new Hashtable();
        private Hashtable<String, String> uniquePatterns = new Hashtable();
        private Hashtable<String, Boolean> statusTable = new Hashtable();
        private ArrayList<AccessPermission> deleteAPs = new ArrayList();
        public static final int PATTERNIZE_METHOD_FILENAME_WHOLE = 0;
        public static final int PATTERNIZE_METHOD_FILENAME_ONLY = 1;
        public static final int PATTERNIZE_METHOD_FILENAME_EXTENSION = 2;
        private int patternizeMethod = 0;

        private ArrayLabelProvider() {
        }

        public void clearCache() {
            this.foretxTable.clear();
            this.uniquePatterns.clear();
            this.statusTable.clear();
            this.deleteAPs.clear();
        }

        private void cacheElement(AccessPermission ap) {
            if (this.foretxTable.get(ap.getText()) != null) {
                return;
            }
            if (this.isSupported(ap)) {
                String converted = this.convert(ap);
                if (converted.equals(ap.getText())) {
                    this.foretxTable.put(ap.getText(), "(" + Messages.PatternizeAccessPermissionsDialog_ConvertInvalidMessage + ")");
                    this.statusTable.put(ap.getText(), Boolean.FALSE);
                } else {
                    if (this.uniquePatterns.get(converted) == null) {
                        this.uniquePatterns.put(converted, converted);
                        this.foretxTable.put(ap.getText(), converted);
                        this.statusTable.put(ap.getText(), Boolean.TRUE);
                    } else {
                        this.foretxTable.put(ap.getText(), "(" + Messages.PatternizeAccessPermissionsDialog_ConvertDuplicateMessage + ")");
                        this.statusTable.put(ap.getText(), Boolean.FALSE);
                    }
                    this.deleteAPs.add(ap);
                }
            } else {
                this.foretxTable.put(ap.getText(), "(" + Messages.PatternizeAccessPermissionsDialog_ConvertNotSupportedMessage + ")");
                this.statusTable.put(ap.getText(), Boolean.FALSE);
            }
        }

        public String[] getUniquePatternArray() {
            return this.uniquePatterns.values().toArray(new String[this.uniquePatterns.size()]);
        }

        public AccessPermission[] getPatternizedAccessPermissionArray() {
            return this.deleteAPs.toArray(new AccessPermission[this.deleteAPs.size()]);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            AccessPermission ap = (AccessPermission)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = ap.getText();
                    break;
                }
                case 1: {
                    this.cacheElement(ap);
                    result = this.foretxTable.get(ap.getText());
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void setPatternizeMethod(int id) {
            this.patternizeMethod = id;
        }

        private String convert(AccessPermission ap) {
            if (this.isSupported(ap)) {
                String result = null;
                String directive = ap.getDirective();
                String content = ap.getContents();
                String[] paths = this.toPaths(content);
                switch (this.patternizeMethod) {
                    case 0: {
                        paths[paths.length - 1] = "\\*";
                        result = String.valueOf(directive) + " " + this.toPath(paths);
                        break;
                    }
                    case 1: {
                        paths[paths.length - 1] = this.patternizeFilename(paths[paths.length - 1]);
                        result = String.valueOf(directive) + " " + this.toPath(paths);
                        break;
                    }
                    case 2: {
                        paths[paths.length - 1] = this.patternizeExtension(paths[paths.length - 1]);
                        result = String.valueOf(directive) + " " + this.toPath(paths);
                    }
                }
                return result;
            }
            return ap.getText();
        }

        private String[] toPaths(String content) {
            if (content == null) {
                return new String[0];
            }
            String[] paths = content.split("/");
            return paths;
        }

        private String patternizeFilename(String filename) {
            int index = filename.lastIndexOf(".");
            if (index > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append("\\*");
                sb.append(".");
                sb.append(filename.substring(index + 1));
                return sb.toString();
            }
            if (filename.length() > 0) {
                return "\\*";
            }
            return filename;
        }

        private String patternizeExtension(String filename) {
            int index = filename.lastIndexOf(".");
            if (index > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(filename.substring(0, index));
                sb.append(".");
                sb.append("\\*");
                return sb.toString();
            }
            return filename;
        }

        private String toPath(String[] paths) {
            StringBuffer sb = new StringBuffer();
            int cnt = 0;
            while (cnt < paths.length) {
                sb.append(paths[cnt]);
                if (cnt < paths.length - 1) {
                    sb.append("/");
                }
                ++cnt;
            }
            return sb.toString();
        }

        private boolean isSupported(AccessPermission ap) {
            String directive = ap.getDirective();
            return directive.equals("1") || directive.equals("2") || directive.equals("3") || directive.equals("4") || directive.equals("5") || directive.equals("6") || directive.equals("7") || directive.equals("allow_create") || directive.equals("allow_rewrite") || directive.equals("allow_truncate") || directive.equals("allow_rewrite") || directive.equals("allow_unlink");
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            AccessPermission ap = (AccessPermission)element;
            if (columnIndex == 1) {
                this.cacheElement(ap);
                if (!this.statusTable.get(ap.getText()).booleanValue()) {
                    return Activator.getStandardDisplay().getSystemColor(15);
                }
            }
            return null;
        }
    }
}

