/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.ui.propertysheet.system;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;
import jp.sourceforge.tomoyo.core.ui.propertysheet.system.Messages;

public class AllowMountPropertySource
extends ElementPropertySource {
    private static final String PROPERTY_ID_DIRECTIVE = "id.directive";
    private static final String PROPERTY_ID_DEVICE = "id.device";
    private static final String PROPERTY_ID_MOUNT_POINT = "id.mount_point";
    private static final String PROPERTY_ID_OPTIONS = "id.options";

    public AllowMountPropertySource(PolicyElement element) {
        super(element);
    }

    protected String[] getPropertyIDs() {
        return new String[]{PROPERTY_ID_DIRECTIVE, PROPERTY_ID_DEVICE, PROPERTY_ID_MOUNT_POINT, PROPERTY_ID_OPTIONS};
    }

    protected String getPropertyName(String propertyID) {
        if (propertyID.equals(PROPERTY_ID_DIRECTIVE)) {
            return Messages.Directive;
        }
        if (propertyID.equals(PROPERTY_ID_DEVICE)) {
            return Messages.AllowMountPropertySource_Device;
        }
        if (propertyID.equals(PROPERTY_ID_MOUNT_POINT)) {
            return Messages.AllowMountPropertySource_MountPoint;
        }
        if (propertyID.equals(PROPERTY_ID_OPTIONS)) {
            return Messages.AllowMountPropertySource_Options;
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        if (id.equals(PROPERTY_ID_DIRECTIVE)) {
            return this.element.getText(0);
        }
        if (id.equals(PROPERTY_ID_DEVICE)) {
            return this.element.getText(1);
        }
        if (id.equals(PROPERTY_ID_MOUNT_POINT)) {
            return this.element.getText(2);
        }
        if (id.equals(PROPERTY_ID_OPTIONS) && this.element.getTextFieldCount() > 3) {
            return this.element.getText(3);
        }
        return null;
    }
}

