/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model.status;

import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import org.eclipse.core.resources.IProject;

public class ProfileManager
extends Observable
implements Observer {
    private static ProfileManager instance;
    private static Hashtable<String, ProjectProfile> projectCache;

    static {
        projectCache = new Hashtable();
    }

    private ProfileManager() {
    }

    public static ProfileManager getInstance() {
        if (instance == null) {
            instance = new ProfileManager();
        }
        return instance;
    }

    public ProjectProfile getProjectProfile(IProject project) {
        return this.getProjectProfile(project, true);
    }

    public ProjectProfile getProjectProfile(IProject project, boolean useCache) {
        if (!useCache || projectCache.get(project.getName()) == null) {
            ProjectProfile pp = new ProjectProfile(project);
            pp.addObserver((Observer)this);
            pp.load();
            projectCache.put(project.getName(), pp);
        }
        return (ProjectProfile)projectCache.get(project.getName());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof ProjectProfile) {
            this.setChanged();
            this.notifyObservers(arg);
        }
    }
}

