/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model.status;

import java.util.ArrayList;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.status.Messages;
import jp.sourceforge.tomoyo.core.local.model.status.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileKind;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileType;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeChoise;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeRange;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeText;
import jp.sourceforge.tomoyo.core.local.model.status.SimpleLogsizeTranslator;
import jp.sourceforge.tomoyo.core.local.model.status.SimpleTranslator;

public class ProfileDefinition {
    public static String[] CHOISES_0to3 = new String[]{"0", "1", "2", "3"};
    public static String[] CHOISES_0to3_TEXT = new String[]{Messages.ProfileDefinition_ChoiseMacDisabled, Messages.ProfileDefinition_ChoiseMacLearning, Messages.ProfileDefinition_ChoiseMacPermissive, Messages.ProfileDefinition_ChoiseMacEnforcing};
    private static String[] CHOISES_ALLOW_ENFORCE = new String[]{"0", "1"};
    private static String[] CHOISES_ALLOW_ENFORCE_TEXT = new String[]{Messages.ProfileDefinition_ChoiseAllowEnforceOff, Messages.ProfileDefinition_ChoiseAllowEnforceOn};
    private static String[] CHOISES_ENABLE = new String[]{"0", "1"};
    private static String[] CHOISES_ENABLE_TEXT = new String[]{Messages.ProfileDefinition_ChoiseEnableOff, Messages.ProfileDefinition_ChoiseEnableOn};
    public static String[] SIMPLE_CHOISES_01 = new String[]{"0", "1"};
    public static String[] SIMPLE_CHOISES_01_TEXT = new String[]{Messages.ProfileDefinition_ChoiseEnableOff, Messages.ProfileDefinition_ChoiseEnableOn};
    public static final String CAPABILITY_PREFIX = "MAC_FOR_CAPABILITY::";
    public static final int PROFILE_COUNT = 48;
    public static final int PROFILE_KIND_COUNT = ProfileKind.getKindCount();
    private static ProfileMetaData[] meta;

    static {
        ArrayList<ProfileMetaData> metaList = new ArrayList<ProfileMetaData>();
        ProfileMetaData metaData = new ProfileMetaData("MAC_FOR_FILE");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAC_FOR_FILE);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setEditable(false);
        metaData.setVersions(Utilities.T_VER_ALL);
        metaList.add(metaData);
        metaData = new ProfileMetaData("COMMENT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_COMMENT);
        metaData.setKind(5);
        metaData.setType((ProfileType)new ProfileTypeText(48));
        metaData.setEditable(false);
        metaData.setVersions(Utilities.T_VER_ALL);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_ARGV0");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAC_FOR_ARGV0);
        metaData.setKind(5);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_NETWORK");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_NETWORK);
        metaData.setKind(1);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_BINDPORT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_BINDPORT);
        metaData.setKind(1);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CONNECTPORT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_CONNECTPORT);
        metaData.setKind(1);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_SIGNAL");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAC_FOR_SIGNAL);
        metaData.setKind(5);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("DENY_CONCEAL_MOUNT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_DENY_CONCEAL_MOUNT);
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("RESTRICT_CHROOT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_CHROOT);
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("RESTRICT_MOUNT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_MOUNT);
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("RESTRICT_UNMOUNT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_UNMOUNT);
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("DENY_PIVOT_ROOT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_DENY_PIVOT_ROOT);
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("RESTRICT_PIVOT_ROOT");
        metaData.setDescription("Description is not available.");
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("TRACE_READONLY");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_TRACE_READONLY);
        metaData.setKind(2);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_ENABLE, CHOISES_ENABLE_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("RESTRICT_AUTOBIND");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_AUTOBIND);
        metaData.setKind(1);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_ENABLE, CHOISES_ENABLE_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAX_ACCEPT_FILES");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_ACCEPT_FILES);
        metaData.setKind(3);
        metaData.setType((ProfileType)new ProfileTypeRange(0, 2048, 2048));
        metaData.setTranslator((SimpleTranslator)new SimpleLogsizeTranslator(metaData));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAX_ACCEPT_ENTRY");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_ACCEPT_ENTRY);
        metaData.setKind(3);
        metaData.setType((ProfileType)new ProfileTypeRange(0, 2048, 2048));
        metaData.setTranslator((SimpleTranslator)new SimpleLogsizeTranslator(metaData));
        metaData.setVersions(Utilities.T_VER_ALL);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAX_GRANT_LOG");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_GRANT_LOG);
        metaData.setKind(3);
        metaData.setType((ProfileType)new ProfileTypeRange(0, 1024, 1024));
        metaData.setTranslator((SimpleTranslator)new SimpleLogsizeTranslator(metaData));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAX_REJECT_LOG");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_REJECT_LOG);
        metaData.setKind(3);
        metaData.setType((ProfileType)new ProfileTypeRange(0, 1024, 1024));
        metaData.setTranslator((SimpleTranslator)new SimpleLogsizeTranslator(metaData));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("TOMOYO_VERBOSE");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_TOMOYO_VERBOSE);
        metaData.setKind(3);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_ENABLE, CHOISES_ENABLE_TEXT));
        metaData.setVersions(Utilities.T_VER_ALL);
        metaList.add(metaData);
        metaData = new ProfileMetaData("ALLOW_ENFORCE_GRACE");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_ENFORCE_GRACE);
        metaData.setKind(5);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_ALLOW_ENFORCE, CHOISES_ALLOW_ENFORCE_TEXT));
        metaData.setVersions(Utilities.T_VER_ALL);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::inet_tcp_create");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_inet_tcp_create);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::inet_tcp_listen");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_inet_tcp_listen);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::inet_tcp_connect");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_inet_tcp_connect);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::use_inet_udp");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_inet_udp);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::use_inet_ip");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_inet_ip);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::use_route");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_route);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::use_packet");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_packet);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_MOUNT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_MOUNT);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_UMOUNT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_UMOUNT);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_REBOOT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_REBOOT);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_CHROOT");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_CHROOT);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_KILL");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_KILL);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_VHANGUP");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_VHANGUP);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_TIME");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_TIME);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_NICE");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_NICE);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_SETHOSTNAME");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_SETHOSTNAME);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::use_kernel_module");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_kernel_module);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::create_fifo");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_fifo);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::create_block_dev");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_block_dev);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::create_char_dev");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_char_dev);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::create_unix_socket");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_unix_socket);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_LINK");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_LINK);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_SYMLINK");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_SYMLINK);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_RENAME");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_RENAME);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_UNLINK");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_UNLINK);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_CHMOD");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_CHMOD);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_CHOWN");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_CHOWN);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_IOCTL");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_IOCTL);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_KEXEC_LOAD");
        metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_KEXEC_LOAD);
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::SYS_PIVOT_ROOT");
        metaData.setDescription("Description is not available.");
        metaData.setKind(4);
        metaData.setType((ProfileType)new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
        metaData.setVersions(Utilities.T_VER_1x);
        metaList.add(metaData);
        meta = metaList.toArray(new ProfileMetaData[metaList.size()]);
    }

    public static String getProfileName(int idx) {
        return meta[idx].getName();
    }

    public static int getProfileCount() {
        return meta.length;
    }

    public static int getIndexByName(String strProfileName) {
        int cnt = 0;
        while (cnt < meta.length) {
            if (meta[cnt].getName().equals(strProfileName)) {
                return cnt;
            }
            ++cnt;
        }
        throw new IllegalArgumentException("Profile name '" + strProfileName + "' is not defineed.");
    }

    public static boolean isChoseable(int idx) {
        return meta[idx].getType() instanceof ProfileTypeChoise;
    }

    public static boolean isFileAccess(int idx) {
        return meta[idx].getKind() == 0;
    }

    public static boolean isNetwork(int idx) {
        return meta[idx].getKind() == 1;
    }

    public static boolean isFilesystem(int idx) {
        return meta[idx].getKind() == 2;
    }

    public static boolean isLogFacility(int idx) {
        return meta[idx].getKind() == 3;
    }

    public static boolean isCapability(int idx) {
        return meta[idx].getKind() == 4;
    }

    public static ProfileType getType(int idx) {
        return meta[idx].getType();
    }

    public static String getDescription(int idx) {
        return meta[idx].getDescription();
    }

    public static ProfileMetaData[] getMetaData() {
        return meta;
    }

    public static ProfileMetaData getMetaData(int idx) {
        return meta[idx];
    }

    public static ProfileMetaData[] getProfileMetaData(int kindID) {
        ArrayList<ProfileMetaData> list = new ArrayList<ProfileMetaData>();
        int cnt = 0;
        while (cnt < meta.length) {
            if (meta[cnt].getKind() == kindID) {
                list.add(meta[cnt]);
            }
            ++cnt;
        }
        return list.toArray(new ProfileMetaData[list.size()]);
    }

    public static String tranlateValue(ProfileMetaData data, Profile profile) {
        if (data.getType() instanceof ProfileTypeChoise) {
            ProfileTypeChoise type = (ProfileTypeChoise)data.getType();
            return type.translate(profile.getValue());
        }
        return profile.getValue();
    }
}

