/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.system;

import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class SystemPolicyKeywordScanner extends RuleBasedScanner {
	
	private static Color defaultColor = Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
	private static Color keywordColor = Display.getCurrent().getSystemColor(SWT.COLOR_DARK_MAGENTA);
	
	private static Color reserveColor = Display.getCurrent().getSystemColor(SWT.COLOR_DARK_BLUE);

	private static final String[] reserveds = {
		// mount points
		"none", "any", "sunrpc",
		// file systems
		"selinuxfs", "usbfs", "sysfs", "ext2", "ext3", "devpts", "tmpfs", "binfmt_misc", "rpc_pipefs"
	};
	
	public SystemPolicyKeywordScanner(IProject project) {
		
		IToken defaultToken = new Token(new TextAttribute(defaultColor));
		IToken keywordToken = new Token(new TextAttribute(keywordColor, null, SWT.ITALIC));
		IToken reserveToken = new Token(new TextAttribute(reserveColor, null, SWT.ITALIC));
		
		WordRule keywordRule = new WordRule(new PolicyKeywordDetector(), defaultToken);
		for (int i = 0; i < reserveds.length; i++)
			keywordRule.addWord(reserveds[i], reserveToken);
		
		String[] systemDirectives = ProcResourceManager.getInstance().getProcResourceSet(project).getSystemPolicy().getModel().listSupportedDirectives();
		
		for (int i = 0; i < systemDirectives.length; i++)
			keywordRule.addWord(systemDirectives[i], keywordToken);
		
		IRule[] rules = new IRule[] {
				new WhitespaceRule(new PolicyWhitespaceDetector()),
				keywordRule,
		};

		setRules(rules);
	}	
	
	static class PolicyKeywordDetector implements IWordDetector {
		public boolean isWordPart(char character) {
			return Character.isDigit(character) | Character.isLetter(character) | character == '_';
		}
		public boolean isWordStart(char character) {
			return Character.isDigit(character) | Character.isLetter(character);
		}
	}

	static class PolicyWhitespaceDetector implements IWhitespaceDetector {
		public boolean isWhitespace(char character) {
			return Character.isWhitespace(character);
		}
	}
	
}
