/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineLabelProvider;

public class ExceptPolicyOutlineLabelProvider extends CoreEditorOutlineLabelProvider implements IColorProvider {
	
	protected IProject project;
	
	public ExceptPolicyOutlineLabelProvider(IProject project) {
		super();
		this.project = project;
	}

	public String getText(Object element) {
		if (element instanceof PolicyElementDefinition) {
			PolicyElementDefinition definition = (PolicyElementDefinition)element;
			return definition.getCaption() + " (" + PolicyCacheManager.getInstance().count(project, definition.getElementClass(), false) + ")"; //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (element instanceof PolicyElement) {
			PolicyElement policyElement = (PolicyElement)element;
			if (directiveVerbose)
				return policyElement.getText();
			else
				return policyElement.getContents();
		}
		return element.toString();
	}
	public Image getImage(Object element) {
		if (element instanceof PolicyElement) {
			/*
			PolicyElement policyElement = (PolicyElement)element;
			return PolicyElementManager.getElementImage(policyElement.getClass());
			*/
			return Activator.getImage("define_element.gif");
		}
		if (element instanceof PolicyElementDefinition) {
			PolicyElementDefinition definition = (PolicyElementDefinition)element;
			return definition.getImage();
		}
		return null;
	}

	public Color getBackground(Object element) {
		if (element instanceof PolicyElement) {
			PolicyElement policyElement = (PolicyElement)element;
			if (policyElement.isDeleted()) {
				if (deletedColoring) {
					return Utilities.getDeletedColor();
				}
			}
			if (policyElement.isCreated())
				return Utilities.getCreatedColor();
			return null;
		}
		return null;
	}
	public Color getForeground(Object element) {
		return null;
	}
	
	private boolean deletedColoring = false;
	
	public void setDeletetedColoring(boolean b) {
		deletedColoring = b;
	}

	private boolean directiveVerbose = false;
	
	public void setDirectiveVerbose(boolean b) {
		directiveVerbose = b;
	}

}
