/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineLabelProvider;

public class DomainPolicyOutlineLabelProvider extends CoreEditorOutlineLabelProvider implements IColorProvider {
	
	protected IProject project;
	
	public DomainPolicyOutlineLabelProvider(IProject project) {
		super();
		this.project = project;
	}
	
	private LocalResource getRemoteResource() {
		return ProcResourceManager.getInstance().getProcResourceSet(project).getDomainPolicy();
	}

	protected void cacheImages() {
		super.cacheImages();
	}

	public String getText(Object object) {
		if (object instanceof PolicyElement) {
			PolicyElement element = (PolicyElement)object;
			
			if (object instanceof Domain) {
                Domain domain = (Domain)element;
                String text = null;
                if (isDomainVerbose)
                	text = domain.getText();
                else
                	text = domain.getProcessName();
                
                if (showResourceCount) {
    				int count = PolicyCacheManager.getInstance().count(project, domain, AccessPermission.class, false);
                	text = text + " (" + count + ")"; //$NON-NLS-1$ //$NON-NLS-2$
                }
                return text;
			}
			if (object instanceof AccessPermission)
				if (accessControlVerbose)
					return element.getText();
				else
					return element.getTextFrom(1);
			if (object instanceof Profile) {
				Profile profile = (Profile)element;
				return profile.getLongName();
			}

			return element.getContents();
		}
		if (object instanceof PolicyElementDefinition) {
			PolicyElementDefinition definition = (PolicyElementDefinition)object;
			return definition.getCaption();
		}

		return super.getText(object);
	}

	public Image getImage(Object object) {
		if (object instanceof Domain) {
			Domain domain = (Domain)object;
			if (domain.isKeepDomain() && domain.isInitializerTarget())
				return Activator.getImage("initializerTarget+keep_domain.gif");
			if (domain.isKeepDomain())
				return Activator.getImage("keep_domain.gif");
			if (domain.isInitializerTarget())
				return Activator.getImage("initializerTarget.gif");
			if (domain.isInitializerSource())
				return Activator.getImage("initializerSource.gif");
			return getRemoteResource().getModel().getElementImage(domain.getClass());
		}
		if (object instanceof AccessPermission) {
			AccessPermission permission = (AccessPermission)object;
			if (permission.isInitializedSource())
				return Activator.getImage("initializerSource.gif");
			else {
//				return PolicyElementManager.getElementImage(permission.getClass());
				return Activator.getImage("policy_element.gif");
			}
		}
		if (object instanceof PolicyElementDefinition) {
			PolicyElementDefinition definition = (PolicyElementDefinition)object;
			return definition.getImage();
		}
		return null;
	}

	private boolean isDomainVerbose = false;
	
	public void setDomainVerbose(boolean b) {
		isDomainVerbose = b;
	}

	//----------------------------------------------------------------------------------------------
	//
	//----------------------------------------------------------------------------------------------
	
    private boolean showResourceCount = false;

    public void showResourceCount(boolean b) {
    	showResourceCount = b;
    }
    
//    private boolean gray = false;
    
	public void setGray(boolean selection) {
//		this.gray = selection;
	}

	private boolean accessControlVerbose;
	
	public void setAccessControlVerbose(boolean b) {
		accessControlVerbose = b;
	}

	//----------------------------------------------------------------------------------------------
	// Implementing IColorProvider
	//----------------------------------------------------------------------------------------------
	
	private boolean enableForeColor = false;
	
	private boolean enableBackColor = false;
	
	public Color getBackground(Object object) {
		if (object instanceof PolicyElement) {
			PolicyElement policyElement = (PolicyElement)object;
			if (policyElement.isDeleted()) {
				if (deletedColoring) {
					return Utilities.getDeletedColor();
				}
			}
			if (policyElement.isCreated())
				return Utilities.getCreatedColor();
		}
		
		if (enableBackColor)
			return getColor(object, false);
		else {
			;
		}
		return null;
	}

	private Color getColor(Object object, boolean foreGround) {
		if (object instanceof Domain) {
			Domain domain = (Domain)object;
			Profile profile = domain.getProfile();
			if (profile == null)
				return null;
			int groupNo = Integer.parseInt(profile.getNo());
			ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(project);
			RGB rgb;
			ProfileGroup group = pp.getGroup(groupNo);
			if (group == null)
				return null;
			if (foreGround)
				rgb = group.getForecolor();
			else
				rgb = group.getBackcolor();
			if (rgb == null)
				return null;
			return Activator.getDefault().getColor(rgb);
		}
		return null;
	}

	public Color getForeground(Object object) {
		if (object instanceof PolicyElement) {
			PolicyElement policyElement = (PolicyElement)object;
			if (policyElement.isDeleted()) {
				if (deletedColoring) {
					return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLACK);
				}
			}
			if (policyElement.isCreated())
				return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLACK);
		}

		if (enableForeColor)
			return getColor(object, true);
		else
			return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLACK);
	}

	public boolean isEnableBackColor() {
		return enableBackColor;
	}

	public void setBackColorEnabled(boolean enableBackColor) {
		this.enableBackColor = enableBackColor;
	}

	public boolean isEnableForeColor() {
		return enableForeColor;
	}

	public void setForeColorEnabled(boolean enableForeColor) {
		this.enableForeColor = enableForeColor;
	}

	public void setColoringEnabled(boolean b) {
		setForeColorEnabled(b);
		setBackColorEnabled(b);
	}

	private boolean deletedColoring = false;
	
	public void setDeletetedColoring(boolean b) {
		deletedColoring = b;
	}

}
