/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text;

import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParserManager;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlinePageProvider;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorPage;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class PolicyEditor extends TextEditor implements ICoreEditorPage, IFormPage, ICoreEditorOutlinePageProvider {

	private PolicyOutlinePage outlinePage = null;

	private CoreEditor fEditor;
	
	public PolicyEditor(CoreEditor editor) {
    	super();
    	fEditor = editor;

    	PolicyParserManager.getInstance().addObserver(new PolicyUpdateObserver());
    }

	public boolean isSaveAsAllowed() {
		return false;
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		super.init(site, input);
	}
	
	private class PolicyUpdateObserver implements Observer {
		public void update(Observable o, Object arg) {
			if (o instanceof PolicyParserManager) {
				final LocalResource localResource = (LocalResource)arg;
				if (!getFile().equals(localResource.getFile()))
					return;
				Activator.getStandardDisplay().syncExec(new Runnable() {
					public void run() {
						if (isActive()) {
							handleEditorInputChanged();
							if (isDocumentReloaded()) {
								getContentOutline().notifyPolicyUpdated();
								isPolicyUpdated = false;
							}
						} else {
							isPolicyUpdated = true;
						}
					}
				});
			}
		}
    }
	
	private boolean isDocumentReloaded() {
		final IDocumentProvider provider = getDocumentProvider();
		if (provider != null) {
			return (provider.getSynchronizationStamp(getFile()) ==
				provider.getModificationStamp(getFile()));
		}
		return false;
	}

	public boolean isEditable() {
		return false;
	}
	
	//------------------------------------------------------------------------------------------------
	// Adapters
	//------------------------------------------------------------------------------------------------
	
	@SuppressWarnings("unchecked")
	public Object getAdapter(Class adapter) {
		if (adapter.equals(IContentOutlinePage.class)) {
			outlinePage = getContentOutline();	
//			outlinePage.addSelectionChangedListener(new ProjectOutlineSelectionChangedListener());
			return outlinePage;
		}
		if (adapter.equals(IPropertySheetPage.class)) {
			return getPropertySheet();
		}
		return super.getAdapter(adapter);
	}

	protected PolicyOutlinePage outline;
	
    /**
     * Returns the content outline.
     */
    protected abstract PolicyOutlinePage getContentOutline();

	private PropertySheetPage propertySheet;

	/**
     * Returns the property sheet.
     */
    public PropertySheetPage getPropertySheet() {
		if (propertySheet == null) {
			propertySheet = new PropertySheetPage();	
//			propertySheet.addSelectionChangedListener(new ProjectOutlineSelectionChangedListener());
		}
		return propertySheet;
	}
    
	//------------------------------------------------------------------------------------------------
	// Document model
	//------------------------------------------------------------------------------------------------

    public abstract IAdaptable getDocumentModel();

	//------------------------------------------------------------------------------------------------
	// Event handlings
	//------------------------------------------------------------------------------------------------
    
	protected void handleCursorPositionChanged() {
		super.handleCursorPositionChanged();
		SourceViewer viewer = (SourceViewer)getSourceViewer();
		Point point = viewer.getSelectedRange();
		if (outline != null) {
			outline.updateCursor(point.x);
		}
	}

	//------------------------------------------------------------------------------------------------
	// Utilities
	//------------------------------------------------------------------------------------------------
    
	protected IFile getFile() {
		return ((FileEditorInput)getEditorInput()).getFile();
	}

	public IProject getProject() {
		return getFile().getProject();
	}

	//------------------------------------------------------------------------------------------------
	// Text folding
	//------------------------------------------------------------------------------------------------
	
	public abstract void updateFoldingStructure(Hashtable<Domain, Position> positions);
	
	private Control fControl;

	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		Control[] children = parent.getChildren();
		fControl = children[children.length - 1];
	}

	//------------------------------------------------------------------------------------------------
	// Implements ICoreEditorPage
	//------------------------------------------------------------------------------------------------
	
	private boolean isPolicyUpdated = false;

	public void notifyPageActivated() {
		if (isPolicyUpdated) {
			handleEditorInputChanged();
			if (isDocumentReloaded()) {
				getContentOutline().notifyPolicyUpdated();
				isPolicyUpdated = false;
			}
		}
	}
	
	//------------------------------------------------------------------------------------------------
	// Implements IFormPage
	//------------------------------------------------------------------------------------------------
	

	public boolean canLeaveThePage() {
		// TODO Auto-generated method stub
		return true;
	}

	public FormEditor getEditor() {
		return fEditor;
	}

	public String getId() {
		return getClass().getName();
	}

	public int getIndex() {
		// TODO Auto-generated method stub
		return 6;
	}

	public IManagedForm getManagedForm() {
		// TODO Auto-generated method stub
		return null;
	}

	public Control getPartControl() {
		return fControl;
	}

	public void initialize(FormEditor editor) {
		fEditor = (CoreEditor)editor;
	}

	public boolean isActive() {
		return this.equals(fEditor.getActivePageInstance());
	}

	public boolean isEditor() {
		// TODO Auto-generated method stub
		return true;
	}

	public boolean selectReveal(Object object) {
		// TODO Auto-generated method stub
		return false;
	}

	public void setActive(boolean active) {
		// TODO Auto-generated method stub
		
	}

	public void setIndex(int index) {
		// TODO Auto-generated method stub
		
	}

	//-----------------------------------------------------------------------------------------
	// Implements ICoreEditorOutlilePage
	//-----------------------------------------------------------------------------------------

	public ContentOutlinePage getContentOutlinePage() {
		return getContentOutline();
	}

}
