/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.perspective;

import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;

public class SwitchPerspectiveThread implements Runnable {

	public SwitchPerspectiveThread() {
	}
	
	public void run() {
		// ask and open project with TOMOYO's default perspective.
		if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null)
			return;
		if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null)
			return;
		
		String openingPerspevtiveID = DefaultPerspectiveFactory.PERSPECTIVE_ID;
		
		if (isCurrentPerspective(openingPerspevtiveID))
			return;
		
		boolean answer = MessageDialog.openQuestion(Activator.getStandardDisplay().getActiveShell(),
				Messages.SwitchPerspectiveThread_ConfirmSwitchDialogTitle,
				Messages.SwitchPerspectiveThread_ConfirmSwitchDialogMessage);
		if (!answer)
			return;

		IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
		IPerspectiveDescriptor openingPerspevtive = registry.findPerspectiveWithId(openingPerspevtiveID);
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(openingPerspevtive);				
	}

	public static boolean isCurrentPerspective(String perspectiveID) {
		if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null)
			return false;
		if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null)
			return false;
		IPerspectiveDescriptor currentPerspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
		IPerspectiveRegistry resistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
		IPerspectiveDescriptor perspective1 = resistry.findPerspectiveWithId(perspectiveID);
		return (currentPerspective.equals(perspective1));
	}
	
}
