/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.profile.wizard;

import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeChoise;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class BasicInformationPage extends WizardPage {
	
	protected BasicInformationPage() {
		super(""); //$NON-NLS-1$
		setTitle(Messages.BasicInformationPage_PageTitle);
		setMessage(Messages.BasicInformationPage_PageMessage);
		
		setPageComplete(true);
	}

    private int defaultGroupNo;

	private Text noText;
	private Text commentText;
	
	private Combo macForFileCombo;
	private Combo macForNetworkCombo;
	private Combo verboCombo;
	
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 2;
		
		Label noLabel = new Label(container, SWT.NULL);
		noLabel.setText(Messages.BasicInformationPage_ProfileNo);
		       
		noText = new Text(container, SWT.BORDER | SWT.SINGLE);
		noText.setText(String.valueOf(defaultGroupNo));
		GridData gd1 = new GridData(GridData.BEGINNING);
		gd1.widthHint = 100;
		noText.setLayoutData(gd1);
		noText.setTextLimit(3);
		noText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				handleNoModifyed();
			}
		});
		
		Label commentLabel = new Label(container, SWT.NULL);
		commentLabel.setText(Messages.BasicInformationPage_Comment);
		       
		commentText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData commentGD = new GridData(GridData.BEGINNING);
		commentGD.widthHint = 400;
		commentText.setLayoutData(commentGD);
		commentText.setTextLimit(128);
		commentText.setText(createCommentText(0, true, true));
		commentText.setSelection(0, commentText.getText().length());
		commentText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				Text text = (Text)e.getSource();
				String strText = text.getText();
				for (int cnt = 0; cnt < strText.length(); cnt++) {
					char c = strText.charAt(cnt);
					if (Character.isWhitespace(c)) {
						setPageComplete(false);
						setErrorMessage(Messages.BasicInformationPage_InputableCharacterMessage);
						return;
					}
//					if (!Character.isDigit(c) && !Character.isLetter(c)) {
//						setPageComplete(false);
//						return;
//					}
				}
				setPageComplete(true);
				setErrorMessage(null);
			}
		});
		
		ProfileMetaData mffMetadata = ProfileDefinition.getMetaData(ProfileDefinition.getIndexByName("MAC_FOR_FILE")); //$NON-NLS-1$
		
		Label mffLabel = new Label(container, SWT.NULL);
		mffLabel.setText(Messages.BasicInformationPage_MacForFileTitle);

		macForFileCombo = new Combo(container, SWT.NULL | SWT.READ_ONLY);
		if (mffMetadata.getType() instanceof ProfileTypeChoise) {
			ProfileTypeChoise choiseType = (ProfileTypeChoise)mffMetadata.getType();
			macForFileCombo.setItems(choiseType.choiseTexts);
			macForFileCombo.select(0);
		}
		macForFileCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleComboSelectionChanged();
			}
		});

		ProfileMetaData mfnMetadata = ProfileDefinition.getMetaData(ProfileDefinition.getIndexByName("MAC_FOR_NETWORK")); //$NON-NLS-1$
		
		Label mfnLabel = new Label(container, SWT.NULL);
		mfnLabel.setText(Messages.BasicInformationPage_MacForNetworkTitle);

		macForNetworkCombo = new Combo(container, SWT.NULL | SWT.READ_ONLY);
		if (mfnMetadata.getType() instanceof ProfileTypeChoise) {
			ProfileTypeChoise choiseType = (ProfileTypeChoise)mfnMetadata.getType();
			macForNetworkCombo.setItems(choiseType.choiseTexts);
			macForNetworkCombo.select(0);
		}
		macForNetworkCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleComboSelectionChanged();
			}
		});

		ProfileMetaData verboMetadata = ProfileDefinition.getMetaData(ProfileDefinition.getIndexByName("TOMOYO_VERBOSE")); //$NON-NLS-1$
		
		Label berboLabel = new Label(container, SWT.NULL);
		berboLabel.setText(Messages.BasicInformationPage_TomoyoVerboseTitle);

		verboCombo = new Combo(container, SWT.NULL | SWT.READ_ONLY);
		if (mffMetadata.getType() instanceof ProfileTypeChoise) {
			ProfileTypeChoise choiseType = (ProfileTypeChoise)verboMetadata.getType();
			verboCombo.setItems(choiseType.choiseTexts);
			verboCombo.select(0);
		}

		setControl(container);
		
		updateCommentText();
	}

	/*
	private boolean checkDigitAlphabet(char c) {
		if ( (c < '0' || c > '9') &&
             (c < 'a' || c > 'z') &&
             (c < 'A' || c > 'Z') ) {
             return false;
        }
	    return true;
	}
	*/

	private void handleNoModifyed() {
	    if (noText.getText().length() == 0) {
	        updateStatus(Messages.BasicInformationPage_ProfileNoBlankMessage);
	        return;
	    }
	    try {
	    	int no = Integer.parseInt(noText.getText());
	    	if (no < 0 || no > 255) {
		        updateStatus(Messages.BasicInformationPage_ProfileNoOutOfRangeMessage);
		    	return;
	    	}
	    	NewProfileWizard wizard = (NewProfileWizard)getWizard();
			final ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(wizard.getProject());
			boolean exists = (pp.getGroup(no) != null);
			if (exists) {
		        updateStatus(Messages.BasicInformationPage_ProfileNoDuplicateMessage + "(" + no + ")");  //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
    			return;
	    	}
	    } catch (NumberFormatException e) {
	        updateStatus(Messages.BasicInformationPage_ProfileNoMustBeNumberMessage);
	    	return;
	    }
	    updateStatus(null);
	}
	
	private void handleComboSelectionChanged() {
		if (macForFileCombo.getSelectionIndex() == macForNetworkCombo.getSelectionIndex()) {
			commentText.setText(createCommentText(macForFileCombo.getSelectionIndex(), true, true));
		} else {
			if (macForFileCombo.getSelectionIndex() > 0 && macForNetworkCombo.getSelectionIndex() > 0) {
				commentText.setText(""); //$NON-NLS-1$
			} else {
				if (macForNetworkCombo.getSelectionIndex() == 0) {
					commentText.setText(createCommentText(macForFileCombo.getSelectionIndex(), true, false));
				}
				if (macForFileCombo.getSelectionIndex() == 0) {
					commentText.setText(createCommentText(macForNetworkCombo.getSelectionIndex(), false, true));
				}
			}
		}
		updateVerboCombo();
	}
	
	private static final String[] MODE_NAME_IN_ALPHA = {
		"Disabled", "Learning", "Permissive", "Enforcing" //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	};
	
	private String updateCommentText() {
		return createCommentText(0, true, true);
	}
	
	private String createCommentText(int index, boolean file, boolean network) {
		StringBuffer sb = new StringBuffer();
		sb.append(MODE_NAME_IN_ALPHA[index]);
		sb.append("("); //$NON-NLS-1$
		if (file)
			sb.append("File"); //$NON-NLS-1$
		if (file && network)
			sb.append("&"); //$NON-NLS-1$
		if (network)
			sb.append("Network"); //$NON-NLS-1$
		sb.append(")"); //$NON-NLS-1$
		return sb.toString();
	}

	private void updateVerboCombo() {
		if (macForFileCombo.getSelectionIndex() > 1 || macForNetworkCombo.getSelectionIndex() > 1) {
			verboCombo.select(1);
		} else {
			verboCombo.select(0);
		}
	}

	private void updateStatus(String message) {
	    setErrorMessage(message);
	    setPageComplete(message == null);
	}

	public void setDefaultGroupNo(int defaultGroupNo) {
		this.defaultGroupNo = defaultGroupNo;
	}

	public int getGroupNo() {
		return Integer.parseInt(noText.getText());
	}

	public String getComment() {
		return commentText.getText();
	}

	public int getMacForFile() {
		return macForFileCombo.getSelectionIndex();
	}

	public int getMacForNetwork() {
		return macForNetworkCombo.getSelectionIndex();
	}

	public int getVerbose() {
		return verboCombo.getSelectionIndex();
	}
	
}
