/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.decorator;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;

import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DomainFullLabelDecorator implements ILabelDecorator {

	public DomainFullLabelDecorator() {
		super();
	}
	
	private static Image grayDomainImage;
	
	public Image decorateImage(Image image, Object object) {
		if (object instanceof Domain) {
			Domain domain = (Domain)object;
			if (domain.isSkelton()) {
				if (grayDomainImage == null)
					grayDomainImage = new Image(Display.getCurrent(), image, SWT.IMAGE_GRAY);
				return grayDomainImage;
			}
		}
		return image;
	}

	public String decorateText(String text, Object element) {
		return text;
	}

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

}
