/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyActions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public abstract class MimicCUIEditorKeyListener extends PolicyActions implements KeyListener {

	protected IProject project;
	
	public MimicCUIEditorKeyListener(IProject project) {
		super(project);
		this.project = project;
	}
	
	public void keyPressed(KeyEvent e) {
		if (e.keyCode == 'a') {
			handleAdd();
		}
		if (e.keyCode == 'c') {
			handleCopy();
		}
		if (e.keyCode == 'd' || e.keyCode == SWT.DEL) {
			handleDelete();
		}
		if (e.keyCode == 'i') {
			handleInsert();
		}
		if (e.keyCode == 'n') {
			handleFindNext();
		}
		if (e.keyCode == 'p') {
			handleFindPrevious();
		}
		if (e.keyCode == 'r') {
			handleRefresh();
			e.doit = false;
		}
		if (e.keyCode == 's') {
			handleSetProfile();
		}
	}
	
	protected IStructuredSelection getSelection(StructuredViewer viewer) {
		IStructuredSelection selection = null;
		if (viewer.getSelection() instanceof StructuredSelection) {
			selection = (StructuredSelection)viewer.getSelection();
		} else {
			selection = new StructuredSelection();
		}
		return selection;
	}

	protected void handleAdd() {
	}

	protected void handleDelete() {
	}

	protected void handleCopy() {
	}

	protected void handleInsert() {
	}

	protected void handleFindNext() {
	}

	protected void handleFindPrevious() {
	}
	
	protected void handleRefresh() {
		boolean syncOK = ProcResourceManager.getInstance().synchronize(project, _getRefreshingLocalResource());
		if (syncOK)
			;
		else
			;
	}
	
	protected void handleSetProfile() {
	}
	
	public void keyReleased(KeyEvent e) {
	}

	protected abstract LocalResource _getRefreshingLocalResource();

}
