/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import java.util.Hashtable;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class CoreEditorOutlineLabelProvider extends LabelProvider {

	protected static Hashtable<Object, Image> imageTable = new Hashtable<Object, Image>();

	public CoreEditorOutlineLabelProvider() {
		cacheImages();
	}

	protected void cacheImages() {
		cacheImage(Domain.class,	Activator.getImage("domain.gif")); //$NON-NLS-1$
		cacheImage(AccessPermission.class,	Activator.getImage("resource.gif")); //$NON-NLS-1$
		cacheImage(PolicyElement.class,	Activator.getImage("import_co.gif")); //$NON-NLS-1$
	}

	protected void cacheImage(Object key, Image image) {
		imageTable.put(key, image);
	}
	
	public Image getImage(Object object) {
		Image image = (Image)imageTable.get(object.getClass());
		if (image == null)
			image = (Image)imageTable.get(PolicyElement.class); 
		return image;
	}

	public String getText(Object object) {
		if (object instanceof PolicyElement) {
			PolicyElement element = (PolicyElement)object;
			return element.getText();
		}
		return super.getText(object);
	}

}
