/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import java.util.ArrayList;
import java.util.List;




import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CoreEditorOutlineContainer extends Page implements IContentOutlinePage {

	public CoreEditorOutlineContainer(CoreEditor editor) {
	}
	
	public void setPageActive(ContentOutlinePage page) {
		if (page == null) {
//			page = getEmptyPage();
		}
		if (currentPage != null) {
//			currentPage.removeSelectionChangedListener(this);
		}
		//page.init(getSite());
//		page.sort(sortingOn);
//		page.addSelectionChangedListener(this);
		this.currentPage = page;
		if (pagebook == null) {
			// still not being made
			return;
		}
		Control control = page.getControl();
		if (control == null || control.isDisposed()) {
			// first time
			page.createControl(pagebook);
			control = page.getControl();
		}
		pagebook.showPage(control);
		
		updateToolbar(page);
		
		this.currentPage = page;
	}
	
	private void updateToolbar(ContentOutlinePage page) {
		IActionBars actionBars = getSite().getActionBars();
		IToolBarManager toolBarManager = actionBars.getToolBarManager();
		toolBarManager.removeAll();
		actionBars.updateActionBars();
		page.setActionBars(actionBars);
		if (page instanceof ICoreEditorOutlilePage) {
			ICoreEditorOutlilePage outline = (ICoreEditorOutlilePage)page;
			List<Action> actionList = outline.getToolBarActions();
			for (int cnt = 0; cnt < actionList.size(); cnt++) {
				if (actionList.get(cnt) instanceof IContributionItem) {
					IContributionItem item = (IContributionItem)actionList.get(cnt);
					toolBarManager.add(item);
				}
				if (actionList.get(cnt) instanceof IAction) {
					IAction action = (IAction)actionList.get(cnt);
					toolBarManager.add(action);
				}
			}
			page.setActionBars(actionBars);
			actionBars.updateActionBars();
		}
	}

	public void setActionBars(IActionBars actionBars) {
		if (currentPage != null)
			setPageActive(currentPage);
	}
		
	private PageBook pagebook;

	public void createControl(Composite parent) {
		pagebook = new PageBook(parent, SWT.NONE);
	}

	public Control getControl() {
		return pagebook;
	}
	
	private ContentOutlinePage currentPage;

	public void setFocus() {
		if (currentPage != null)
			currentPage.setFocus();
	}

	private ArrayList<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
	
	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		listeners.add(listener);
	}

	private ISelection selection;
	
	public ISelection getSelection() {
		return selection;
	}

	public void removeSelectionChangedListener(
			ISelectionChangedListener listener) {
		listeners.remove(listener);
	}

	public void setSelection(ISelection selection) {
		this.selection =selection;
		if (listeners == null)
			return;
		SelectionChangedEvent e = new SelectionChangedEvent(this, selection);
		for (int i=0; i<listeners.size(); i++) {
			listeners.get(i).selectionChanged(e);
		}	
	}

}
