/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package test;

import org.eclipse.core.resources.IProject;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import junit.framework.TestCase;

public class SSHConnectionAdapterPluginTest extends TestCase {

	private IProject testingProject;

	private IConnectionAdapter adapter;
	
	private boolean b = false;

	private void ___setup() {
		testingProject = TomoyoCorePluginTest.getTestingProject();
		adapter = Utilities.getConnectionAdapter(testingProject);
		
		if (adapter.isConnected(testingProject))
			adapter.disconnect(testingProject);
		
		TomoyoCorePluginTest.setupProperty(
				TomoyoCorePluginTest.MUST_CHANGE_HOSTNAME,
				TomoyoCorePluginTest.MUST_CHANGE_USERNAME,
				TomoyoCorePluginTest.MUST_CHANGE_PORTNO,
				TomoyoCorePluginTest.MUST_CHANGE_CON_ADAPTER_SSH,
				null,
				TomoyoCorePluginTest.MUST_CHANGE_PASSWORD,
				null);
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(new String[] {"", "confirm_conect"}, "false");
	}
	
	//---------------------------------------------------------------------------------------------
	// Connecting / Disconnecting
	//---------------------------------------------------------------------------------------------
	
	public void testConnect() {
		___setup();
		
		boolean b = false;
		
		b = adapter.isConnected(testingProject);
		assertTrue(!b);
		
		b = adapter.connect(testingProject);
		assertTrue(b);
		
		b = adapter.isConnected(testingProject);
		assertTrue(b);
	}
	
	public void testIsConnected() {
		testConnect();
	}
	
	public void testDisonnect() {
		___setup();

		if (!adapter.isConnected(testingProject))
			adapter.connect(testingProject);

		boolean b = false;
		
		b = adapter.isConnected(testingProject);
		assertTrue(b);

		adapter.disconnect(testingProject);
		
		b = adapter.isConnected(testingProject);
		assertTrue(!b);
	}
	
	public void testIsDisconnected() {
		testDisonnect();
	}
	
	public void testConnectAgain() {
		testConnect();
	}

	public void testIsConnectedAgain() {
		testIsConnected();
	}
	
	public void testDisonnectAgain() {
		testDisonnect();
	}
	
	//---------------------------------------------------------------------------------------------
	// Auth fail > success
	//---------------------------------------------------------------------------------------------

	public void testIllegalHostname() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME, "unknown");

		b = adapter.connect(testingProject);
		assertEquals(false, b);
		
		assertEquals("com.jcraft.jsch.JSchException: java.net.UnknownHostException: unknown",
				adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME, TomoyoCorePluginTest.MUST_CHANGE_HOSTNAME);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));
		
		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	public void testIllegalPortNot() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT, "90000");

		b = adapter.connect(testingProject);
		assertEquals(false, b);
		
		assertEquals("com.jcraft.jsch.JSchException: java.lang.IllegalArgumentException: port out of range:90000",
				adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT, TomoyoCorePluginTest.MUST_CHANGE_PORTNO);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	public void testIllegalUsername() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME, "nobody knows");

		b = adapter.connect(testingProject);
		assertEquals(false, b);
		
		assertEquals("com.jcraft.jsch.JSchException: Auth fail", adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME, TomoyoCorePluginTest.MUST_CHANGE_USERNAME);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	public void testIllegalPrivateKey() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, "C:\\somewhere");

		b = adapter.connect(testingProject);
		assertEquals(false, b);
		
		assertTrue(
				adapter.getErrorMessage(testingProject).startsWith(
				"com.jcraft.jsch.JSchException: java.io.FileNotFoundException: C:\\somewhere"));

		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, TomoyoCorePluginTest.MUST_CHANGE_PKEY);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	public void testIllegalPassword() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, "invalid password");

		b = adapter.connect(testingProject);
		assertEquals(false, b);

		assertEquals("com.jcraft.jsch.JSchException: Auth fail", adapter.getErrorMessage(testingProject));
		
		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, TomoyoCorePluginTest.MUST_CHANGE_PASSWORD);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}

	public void testConnectWithKnownHosts() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, "C:\\somewhre");

		b = adapter.connect(testingProject);
		assertEquals(false, b);

		assertEquals("com.jcraft.jsch.JSchException: reject HostKey: " + TomoyoCorePluginTest.MUST_CHANGE_HOSTNAME,
				adapter.getErrorMessage(testingProject));
		
		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, TomoyoCorePluginTest.MUST_CHANGE_KNOWNHOSTS);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);

		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	public void testConnectWithKnownHosts_invalidFileContents() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, "C:\\config.sys");

		b = adapter.connect(testingProject);
		assertEquals(false, b);

		assertEquals("com.jcraft.jsch.JSchException: reject HostKey: " + TomoyoCorePluginTest.MUST_CHANGE_HOSTNAME,
				adapter.getErrorMessage(testingProject));
		
		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, TomoyoCorePluginTest.MUST_CHANGE_KNOWNHOSTS);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);

		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	public void testNGPrivatekeyThenOKPassword() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, "C:\\somewhre");

		b = adapter.connect(testingProject);
		assertEquals(false, b);

		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, null);
		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, TomoyoCorePluginTest.MUST_CHANGE_PASSWORD);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}

	public void testNGPasswordThenOKPrivatekey() {
		___setup();
		
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(testingProject);
		properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, "invalid password");

		b = adapter.connect(testingProject);
		assertEquals(false, b);

		b = adapter.isConnected(testingProject);
		assertEquals(false, b);

		properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, TomoyoCorePluginTest.MUST_CHANGE_PKEY);
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);
		
		assertNull(adapter.getErrorMessage(testingProject));

		b = adapter.isConnected(testingProject);
		assertEquals(true, b);
	}
	
	//---------------------------------------------------------------------------------------------
	// Communication
	//---------------------------------------------------------------------------------------------

	public void testExecCommand() {
		___setup();
		
		b = adapter.connect(testingProject);
		assertEquals(true, b);

		final int up2 = 1000;
		StringBuffer sb = new StringBuffer();
		sb.append("for i in `seq 0 " + up2 + "`; do echo -n $i; done");
		
		ConcreteCommand command = new ConcreteCommand(testingProject, sb.toString());
		Boolean b = adapter.exec(command);
		assertTrue(b);
		
		StringBuffer expected = new StringBuffer();
		for (int cnt = 0; cnt <= up2; cnt++) {
			expected.append(cnt);
//			expected.append(System.getProperty("line.separator"));
		}
		
		assertEquals(expected.length(), command.getSTDOut().length());
		assertEquals(expected.toString(), command.getSTDOut());
	}

}
