/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.propertysheet.except;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;

public class PathGroupPropertySource extends ElementPropertySource {
	
	public PathGroupPropertySource(PolicyElement element) {
		super(element);
	}

	private static final String PROPERTY_ID_DIRECTIVE = "id.directive"; //$NON-NLS-1$
	private static final String PROPERTY_ID_NAME = "id.name"; //$NON-NLS-1$
	private static final String PROPERTY_ID_PATH = "id.path"; //$NON-NLS-1$

	protected String[] getPropertyIDs() {
		return new String[] {
				PROPERTY_ID_DIRECTIVE,
				PROPERTY_ID_NAME,
				PROPERTY_ID_PATH
		};
	}

	protected String getPropertyName(String propertyID) {
		if (propertyID.equals(PROPERTY_ID_DIRECTIVE))
			return Messages.Directive;
		if (propertyID.equals(PROPERTY_ID_NAME))
			return Messages.PathGroupPropertySource_Name;
		if (propertyID.equals(PROPERTY_ID_PATH))
			return Messages.PathGroupPropertySource_Path;
		return null;
	}

	public Object getPropertyValue(Object id) {
		if (id == null)
			return null;
		if (id.equals(PROPERTY_ID_DIRECTIVE))
			return element.getText(0);
		if (id.equals(PROPERTY_ID_NAME))
			return element.getText(1);
		if (id.equals(PROPERTY_ID_PATH))
			return element.getText(2);
		return null;
	}

}
