/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.resource;

import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Observable;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ReadCommand;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProcResourceManager extends Observable {
	
	private static ProcResourceManager instance;
	
	public static ProcResourceManager getInstance() {
		if (instance == null)
			instance = new ProcResourceManager();
		return instance;
	}

	private static Hashtable<IProject, ProcResourceSet> projectCache = new Hashtable<IProject, ProcResourceSet>();
	
	public ProcResourceSet getProcResourceSet(IProject project) {
		if (projectCache.get(project) == null) {
			ProcResourceSet pr = new ProcResourceSet(project);
			projectCache.put(project, pr);
		}
		return projectCache.get(project);
	}

	public boolean synchronize(final IProject project, final LocalResource localResource) {
		synchronized (this) {
//			String messageSuffix = " (" + localResource.getName() + ")"; //$NON-NLS-1$ //$NON-NLS-2$
			TomoyoCorePlugin.getDefault().setStatusMessage(Messages.ProcResourceManager_StatusMessageSyncronizing, true);
			try {
				ReadCommand rCommand = CommandManager.getInstance().read(project, localResource);
				if (rCommand.isSuccessful()) {
					IFile localFile = localResource.getFile();
					localFile.delete(true, true, null);
					localFile.create(new ByteArrayInputStream(rCommand.getSTDOut().getBytes()), true, null);

					setChanged();
					notifyObservers(localResource);
				}
			} catch (CoreException e) {
				TomoyoCorePlugin.getDefault().setStatusErrorMessage(Messages.ProcResourceManager_StatusErrorMessageSyncronizing);
				TomoyoCorePlugin.logException(e);
				return false;
			}
			TomoyoCorePlugin.getDefault().setStatusMessage(Messages.ProcResourceManager_StatusMessageSynchronized, true);
			return true;
		}
	}

}
