/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.resource;

import jp.sourceforge.tomoyo.core.local.model.ExceptPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.server.CommandManager;

import org.eclipse.core.resources.IProject;

public class ExceptPolicy extends LocalResource implements IPolicy, IProcFile {

	public static final String LOCAL_FILENAME = "exception_policy.txt";

	public ExceptPolicy(IProject project) {
		super(project, project.getFile(LOCAL_FILENAME));
	}

	public static final String NAME = Messages.ExceptPolicy_Name;

	public String getName() {
		return NAME;
	}

	protected AbstractPolicyModel createModel(IProject project) {
		return new ExceptPolicyModel(project);
	}

	@Override
	public String getSorterCommand() {
		return CommandManager.CMD_SYSTEM_SORT;
	}

	public String getProcPath() {
		return POLICY_DIR + "exception_policy";
	}

}
