/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.domain;

import org.eclipse.ui.views.properties.IPropertySource;

import jp.sourceforge.tomoyo.core.local.model.AbstractDomainPolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;

public class AccessPermission extends AbstractDomainPolicyElement implements IAccessPermission {

	public AccessPermission(String text, int line, int column) {
		super(text, line, column);
	}
	
	public String getDeclaredPermission() {
		return super.getText(0);
	}

	public String getPermission() {
		return super.getTextFrom(1);
	}

	private boolean isInitializedSource = false;
	
	public boolean isInitializedSource() {
		return isInitializedSource;
	}

	public void setInitializerSource(boolean b) {
		isInitializedSource = b;
	}

	protected void _initialize() {
		super._initialize();
		isInitializedSource = false;
	}

	@Override
	protected void validate() {
		super.validate();
		String strDecPerm = getDeclaredPermission();
		if (strDecPerm.equals("3") || strDecPerm.equals("5") || strDecPerm.equals("7")) { //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			noteID = NOTE_WARNNING;
			note = Messages.AccessPermission_Note_BothWritableAndExecutable;
			noteOffset = getOffset();
			noteOffsetLength = 1;
		}
	}

	@Override
	protected IPropertySource createPropertySource() {
		return new ElementPropertySource(this);
	}
	
}
