/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class PolicyElement implements IAdaptable {

	private PolicyElement parent = null;
	private List<PolicyElement> children = null;

	private String text = null;
	private int line = -1;
	private int offset = -1;
	
	public PolicyElement(String text, int line, int offset) {
		this.text = text;
		this.line = line;
		this.offset = offset;
		validate();
	}

	public static final int NOTE_NONE = 0;
	public static final int NOTE_INFO = 1;
	public static final int NOTE_WARNNING = 2;
	public static final int NOTE_ERROR = 3;
	
	protected int noteID = NOTE_NONE;
	protected String note = null;
	
	protected void validate() {
	}

	public int getNoteID() {
		return noteID;
	}
	
	protected int noteOffset = -1;

	public int getNoteOffset() {
		return noteOffset;
	}
	
	protected int noteOffsetLength = -1;
	
	public int getNoteOffsetLength() {
		return noteOffsetLength;
	}
	
	public boolean hasNote() {
		return noteID != NOTE_NONE;
	}
	
	public String getNote() {
		return note;
	}
	
	public int getOffset() {
		return offset;
	}

	public void setOffset(int column) {
		this.offset = column;
	}

	public int length() {
		return (getText() == null) ? 0 : getText().length();
	}
	
	public int getLine() {
		return line;
	}

	public void setLineno(int line) {
		this.line = line;
	}

	public String getText() {
		return text;
	}
	
	private String[] splited;
	
	private String[] splitText() {
		if (splited == null) {
			splited = getText().split("[\\s]+");
		}
		return splited;
	}
	
	public String getText(int idx) {
		String[] strs = splitText();
		return strs[idx];
	}

	public String getContents() {
		return getTextFrom(1);
	}
	
	public String[] getTransitionTextArray() {
		String[] strs = splitText();
		return strs;
	}
	
	public String getTextFrom(int idx) {
		String[] strs = splitText();
		StringBuffer buffer = new StringBuffer();
		for (int cnt = idx; cnt < strs.length; cnt++) {
			buffer.append(strs[cnt]);
			buffer.append(" ");
		}
		if (buffer.length() > 0)
			buffer.deleteCharAt(buffer.length() - 1);
		return buffer.toString();
	}

	public String getText(int from, int to) {
		String[] strs = splitText();
		StringBuffer buffer = new StringBuffer();
		for (int cnt = from; cnt < to - from; cnt++) {
			buffer.append(strs[cnt]);
			buffer.append(" ");
		}
		if (buffer.length() > 0)
			buffer.deleteCharAt(buffer.length() - 1);
		return buffer.toString();
	}

	public String getText2() {
		String[] strs = splitText();
		StringBuffer buffer = new StringBuffer();
		for (int cnt = 0; cnt < strs.length - 1; cnt++) {
			buffer.append(strs[cnt]);
			buffer.append(" ");
		}
		if (buffer.length() > 0)
			buffer.deleteCharAt(buffer.length() - 1);
		return buffer.toString();
	}
	
	public String getText2(int idx) {
		String[] strs = splitText();
		StringBuffer buffer = new StringBuffer();
		int len = strs.length < idx ? strs.length : idx; 
		for (int cnt = 0; cnt < len; cnt++) {
			buffer.append(strs[cnt]);
			buffer.append(" ");
		}
		if (buffer.length() > 0)
			buffer.deleteCharAt(buffer.length() - 1);
		return buffer.toString();
	}
	
	public int getTextFieldCount() {
		String[] strs = splitText();
		return strs.length;
	}
	
	public void setText(String name) {
		this.text = name;
	}

	public String[] toArray() {
		String[] strs = splitText();
		return strs;
	}

	public void setParent(PolicyElement e) { parent = e; }
	
	public PolicyElement getParent() { return parent; }
	
	public void addChild(PolicyElement e) {
		if (children == null)
			children = new ArrayList<PolicyElement>();
		children.add(e);
		e.setParent(this);
	}
	
	public void addChildren(PolicyElement[] childArray) {
		if (children == null)
			children = new ArrayList<PolicyElement>();
		for (int cnt = 0; cnt < childArray.length; cnt++) {
			addChild(childArray[cnt]);
		}
	}

	public PolicyElement getChild(int i) {
		if (children == null)
			return null;
		return (PolicyElement)children.get(i);
	}

	public void setChild(int i, PolicyElement element) {
		if (children == null)
			children = new ArrayList<PolicyElement>();
		children.set(i, element);
		element.setParent(this);
	}
	
	public int getChildrenCount() {
		if (children == null) {
			return 0;
		} else {
			return children.size();
		}
	}

	public List<PolicyElement> getChildren() {
		if (children == null)
			children = new ArrayList<PolicyElement>();
		return children;
	}
	
	public PolicyElement within(int pos) {
		if (getOffset() <= pos && pos <= getOffset() + length())
			return this;
		if (getOffset() > pos)
			return null;
		for (int cnt = 0; cnt < getChildrenCount(); cnt++) {
			PolicyElement ret = getChild(cnt).within(pos);
			if (ret != null)
				return ret;
		}
		return null;
	}
	
	public void dump(int level) {
		StringBuffer suffix = new StringBuffer();
		for (int cnt = 0; cnt < level; cnt++) {
			suffix.append(" ");
		}
		for (int cnt = 0; cnt < getChildrenCount(); cnt++) {
			getChild(cnt).dump(level + 1);
		}
	}
	
	public String toString() {
		return "class = " + getClass().getName() + ", name = " + getText() + ", child = " + getChildrenCount();
	}

	//------------------------------------------------------------------------------------------
	// adapt IPropertySource
	//------------------------------------------------------------------------------------------

	@SuppressWarnings("unchecked")
	public Object getAdapter(Class adapter) {
		if (adapter.equals(IPropertySource.class)) {
			return getPropertySource();
		}
		return null;
	}

    protected IPropertySource propertySource;

	/**
     * Returns the content outline.
     */
    public IPropertySource getPropertySource() {
		if (propertySource == null) {
			propertySource = createPropertySource();
		}
		return propertySource;
	}

	protected abstract IPropertySource createPropertySource();

	public String getDirective() {
		return getText(0);
	}

	private boolean created = false;
	
	public void setCreated(boolean b) {
		this.created = b;
		if (b)
			this.deleted = !b;
	}

	public boolean isCreated() {
		return created;
	}

	private boolean checked = false;
	
	public void setChecked(boolean b) {
		this.checked = b;
	}
	
	public boolean isChecked() {
		return checked;
	}
	
	private boolean deleted = false;
	
	public void setDeleted(boolean b) {
		this.deleted = b;
		if (b)
			this.created = !b;
	}

	public boolean isDeleted() {
		return deleted;
	}

	protected void _initialize() {
		setCreated(false);
		setChecked(false);
		setDeleted(false);
	}

	public void hookTraverse() {
		_initialize();
	}

}
