/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.extensions;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;

public class PolicyElementHistory {
	
	private PolicyElement element;
	
	private String createTime;
	
	public PolicyElementHistory(PolicyElement element) {
		this.element = element;
		createTime = Utilities.getCurrentDateTime();
		created = element.isCreated();
		deleted = element.isDeleted();
	}
	
	public String getCreateTime() {
		return createTime;
	}
	
	public PolicyElement getPolicyElement() {
		return element;
	}
	
	private boolean created = false;
	
	public boolean isCreated() {
		return created;
	}
	
	private boolean deleted = false;
	
	public boolean isDeleted() {
		return deleted;
	}

	//------------------------------------------------------------------------------------------
	// adapt IPropertySource
	//------------------------------------------------------------------------------------------
/*
	public Object getAdapter(Class adapter) {
		if (adapter.equals(IPropertySource.class)) {
			return getPropertySource();
		}
		return null;
	}

    protected IPropertySource propertySource;

 	// Returns the content outline.
    public IPropertySource getPropertySource() {
		if (propertySource == null) {
			propertySource = PolicyElementManager.createPolicyElementPropertySource(element);	
		}
		return propertySource;
	}
	*/
    
}