/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.core.Utilities;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SetupManagerDomainPage extends AbstractWizardPage {

	private static final String DEF_DESCRIPTION = Messages.SetupManagerDomainPage_PageDescription;
	
	public SetupManagerDomainPage() {
		super(Messages.SetupManagerDomainPage_PageName);
		setTitle(Messages.SetupManagerDomainPage_PageTitle);
		setDescription(DEF_DESCRIPTION);
		setPageComplete(false);
	}

	protected String getHelpResourceName() {
		return "setup_manager_domain"; //$NON-NLS-1$
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);

		createMDomainComposite(composite);
		createDownloadGroup(composite);

		setControl(composite);
	}

	protected void hookFirstVisit() {
		setPageComplete(false);
		installButton.setEnabled(false);
		
		String recommendedManager = Utilities.getNeedToBeManagerDomain(getProject());
		if (recommendedManager == null) {
			managerDomainText.setText(""); //$NON-NLS-1$
			setErrorMessage(Messages.SetupManagerDomainPage_CouldNotCalculateManagerMessage);
			return;
		} else {
			managerDomainText.setText(recommendedManager);
			if (Utilities.isRegisterdAsManager(getProject(), recommendedManager)) {
				setPageComplete(true);
				setMessage(Messages.SetupManagerDomainPage_AlreadyRegisteredMessage, INFORMATION);
			} else {
				setPageComplete(false);
				setMessage(Messages.SetupManagerDomainPage_PleaseInstallMessage, WARNING);
				installButton.setEnabled(true);
			}
		}
	}

	private Text managerDomainText;
	
	private void createMDomainComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		
		GridLayout layout = new GridLayout(2, false);
		composite.setLayout(layout);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayoutData(data);
		
		Label label = new Label(composite, SWT.NONE);
		label.setText(Messages.SetupManagerDomainPage_ManagerLabel + " : "); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$
		managerDomainText = new Text(parent, SWT.SINGLE | SWT.BORDER);
		managerDomainText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		managerDomainText.setText(""); //$NON-NLS-1$
		managerDomainText.setEditable(false);
	}

	private Button installButton;

    private void createDownloadGroup(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(2, false));
		GridData gridData = new GridData();
		gridData.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gridData);

		Label blank = new Label(container, SWT.NONE);
		GridData lineData = new GridData(GridData.FILL_HORIZONTAL);
		lineData.horizontalSpan = 1;
		blank.setLayoutData(lineData);

		installButton = new Button(container, SWT.PUSH);
		installButton.setText(Messages.SetupManagerDomainPage_InstallButton);
		installButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		installButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				handleIntallButtonPressed();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
    }

	private void handleIntallButtonPressed() {
		if (Utilities.installManagerDomain(getProject(), managerDomainText.getText())) {
			setPageComplete(true);
			setMessage(Messages.SetupManagerDomainPage_SaveOKMessage, INFORMATION);
			
			installButton.setEnabled(false);
		} else {
			setPageComplete(false);
			setErrorMessage(Messages.SetupManagerDomainPage_SaveNGMessage);
		}
	}

}
