/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CheckServerPage extends AbstractWizardPage {

	private Text versionText;
	
	public CheckServerPage() {
		super(""); //$NON-NLS-1$
		setTitle(Messages.CheckServerPage_PageTitle);
		setDescription(""); //$NON-NLS-1$
		setPageComplete(false);
	}

	protected String getHelpResourceName() {
		return "installation_check"; //$NON-NLS-1$
	}

	public IWizardPage getPreviousPage() {
		super.getPreviousPage();
		return null;
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);
		createConfigComposite(composite);
		createInstallGroup(composite);
		setControl(composite);
	}

	private Label osLabel = null;
	private Label tomoyoLabel = null;
	
	private void createConfigComposite(Composite composite) {
		GridLayout layout = new GridLayout(2, false);
		Composite container = new Composite(composite, SWT.NONE);
		
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		container.setLayoutData(data);
		container.setLayout(layout);

		Label osTitle = new Label(container, SWT.NONE);
		osTitle.setText(Messages.CheckServerPage_LinuxLabel + " : "); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$
       osLabel = new Label(container, SWT.NONE);
       osLabel.setAlignment(SWT.LEFT);
       osLabel.setText(Messages.CheckServerPage_No);
       osLabel.setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_DARK_GRAY));
       osLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label tomoyoTitle = new Label(container, SWT.NONE);
		tomoyoTitle.setText(Messages.CheckServerPage_TomoyoLinuxLabel + " : "); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$
       tomoyoLabel = new Label(container, SWT.NONE);
       tomoyoLabel.setAlignment(SWT.LEFT);
       tomoyoLabel.setText(Messages.CheckServerPage_No);
       tomoyoLabel.setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_DARK_GRAY));
       tomoyoLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
       
		Label versionLabel = new Label(container, SWT.NONE);
		versionLabel.setText(Messages.CheckServerPage_TomoyoVersionLabel + " : "); //$NON-NLS-2$ //$NON-NLS-1$
		versionText = new Text(container, SWT.SINGLE | SWT.BORDER);
		versionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		versionText.setEditable(false);
	}
	
	private void createInstallGroup(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(2, false));
		GridData gridData = new GridData();
		gridData.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gridData);

		Label blank = new Label(container, SWT.NONE);
		GridData lineData = new GridData(GridData.FILL_HORIZONTAL);
		lineData.horizontalSpan = 1;
		blank.setLayoutData(lineData);
    }

	protected void hookFirstVisit() {
		checkServer();
	}
	
	private void checkServer() {
		ConcreteCommand command = null;
		command = CommandManager.getInstance().exec(getProject(), "uname", new String[] {"-s"}, null); //$NON-NLS-1$ //$NON-NLS-2$
		if (command.isSuccessful()) {
			if (command.getSTDOut().startsWith("Linux")) { //$NON-NLS-1$
				osLabel.setText(Messages.CheckServerPage_Yes);
				osLabel.setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLUE));
				osLabel.pack();
				osLabel.redraw();
			} else {
				setMessage(Messages.CheckServerPage_NotLinuxBoxErrorMessage, ERROR);
				setPageComplete(false);
				return;
			}
		} else {
			setMessage(Messages.CheckServerPage_UnknownOSErrorMessage, ERROR);
			setPageComplete(false);
			return;
		}
		
		command = CommandManager.getInstance().exec(getProject(), "ls", null, new String[] {"/proc/ccs"}); //$NON-NLS-1$
		if (command.isSuccessful()) {
			tomoyoLabel.setText(Messages.CheckServerPage_Yes);
			tomoyoLabel.setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLUE));
			tomoyoLabel.pack();
			tomoyoLabel.redraw();
		} else {
			setMessage(Messages.CheckServerPage_TOMOYOInstallationNo, ERROR);
			setPageComplete(false);
			return;
		}
		
		String strVersion = Utilities.distinctVersion(getProject());
		versionText.setText(strVersion);
		if (Utilities.isSupportedVersion(strVersion)) {
			versionText.setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLUE));
			setMessage(Messages.CheckServerPage_SupportedTOMOYOFoundMessage, INFORMATION);
			setPageComplete(true);
		} else {
			setMessage(Messages.CheckServerPage_UnSupportedTOMOYOFoundMessage, ERROR);
			setPageComplete(false);
		}
	}

	protected void nextButtonPressed() {
		storeProperties();
	}

	private void storeProperties() {
		ProjectProperty properties = new ProjectProperty(getProject());
		properties.setProperty(PersistentPropertyManager.PROPERTY_VERSION, versionText.getText());
	}

}
