/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractWizardPage extends WizardPage {

	protected AbstractWizardPage(String pageName) {
		super(pageName);
	}

	public String getHelpResource() {
		return "jp.sourceforge.tomoyo.doc." + getHelpResourceName();
	}
	
	protected abstract String getHelpResourceName();

	protected IProject getProject() {
		CreateNewProjectWizard wizard = (CreateNewProjectWizard)getWizard();
		IProject project = wizard.getProject();
		return project;
	}

	//-------------------------------------------------------------------
	// Create page visiter handler
	//-------------------------------------------------------------------
	
	private int incomingCount = 0;
	
	public IWizardPage getPreviousPage() {
		try {
			return super.getPreviousPage();
		} finally {
			getWizard().getPreviousPage(this);
			
			if (incomingCount++ == 0)
				hookFirstVisit();
			else
				previousButtonPressed();
		}
	}

	protected void hookFirstVisit() {
	}

	protected void previousButtonPressed() {
	}

	//-------------------------------------------------------------------
	// Create next button handler
	//-------------------------------------------------------------------

	/*
	 * see 
	 * http://dev.eclipse.org/newslists/news.eclipse.tools/msg03421.html
	 */
	public IWizardPage getNextPage() {
		try {
			return super.getNextPage();
		} finally {
			nextButtonPressed();
		}
	}

	/*
	 * see 
	 * http://dev.eclipse.org/newslists/news.eclipse.tools/msg03421.html
	 */
	public boolean canFlipToNextPage() {
		return super.isPageComplete();
	}

	protected void nextButtonPressed() {
	}
	

	protected int getVisitTimes() {
		return incomingCount;
	}

}
