/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.connection;

import java.io.File;

import jp.sourceforge.tomoyo.core.extensions.IConnectionSettings;


import org.eclipse.core.resources.IProject;

public class SSHConnectionSettings implements IConnectionSettings {

	public IProject project;
	
	public String hostname;
	
	public String username;
	
	public int portno;
	
	public boolean isPublicKeyAuthentication;
	
	public File pkeyfile;
	
	public String password;
	
	public File knownHosts;

	public boolean confirmConnection;

	public boolean equals(Object obj) {
		if (obj instanceof SSHConnectionSettings) {
			SSHConnectionSettings target = (SSHConnectionSettings)obj;
			if (target != null && project != null && target.project != null)
				return project.equals(target.project);
		}
		return super.equals(obj);
	}

	public IProject getProject() {
		return project;
	}
	
}
