/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.connection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.server.AbstractCommand;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.core.server.ICommand;
import jp.sourceforge.tomoyo.core.server.ReadCommand;
import jp.sourceforge.tomoyo.core.server.WriteCommand;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;

public class CommandThread implements Runnable {

	private static final int STATUS_UNKNOWN = 0;
	private static final int STATUS_RUNNING = 1;
	private static final int STATUS_DONE_OK = 2;
	private static final int STATUS_DONE_NG = 3;
	
	private SSHSession connection = null;
	private ICommand command = null;
	
	public CommandThread(SSHSession connection, ICommand command) {
		this.connection = connection;
		this.command = command;
	}

	public void run() {
		
		runningStatus = STATUS_RUNNING;
		
		Channel channel = null;
		ByteArrayOutputStream stdoutStream = null;
		ByteArrayOutputStream stderrStream = null;
		
		try {
			if (connection == null)
				return;
			channel = connection.getChannel();
			if (channel == null)
				return;

			String strCommand = null;
			if (command instanceof ConcreteCommand) {
				ConcreteCommand cCommand = (ConcreteCommand)command;
				strCommand = toCommandString(cCommand);
				((ChannelExec)channel).setCommand(strCommand);
			} else if (command instanceof ReadCommand) {
				ReadCommand rCommand = (ReadCommand)command;
				strCommand = "cat" + " " + rCommand.getSource();
				if (rCommand.getSorterCommand() != null)
					strCommand = strCommand + "  | " + rCommand.getSorterCommand();
				((ChannelExec)channel).setCommand(strCommand);
			} else if (command instanceof WriteCommand) {
				WriteCommand wCommand = (WriteCommand)command;
				if (wCommand.isAppendMode())
					strCommand = "cat" + " >> " + wCommand.getTarget();
				else
					strCommand = "cat" + " > " + wCommand.getTarget();
				((ChannelExec)channel).setCommand(strCommand);
				channel.setInputStream(new ByteArrayInputStream(wCommand.getInputText().getBytes()));
			} else {
				throw new IllegalArgumentException("Not supported ICommand instance : " + command);
			}
			
			stdoutStream = new ByteArrayOutputStream();
			channel.setOutputStream(stdoutStream);
			stderrStream = new ByteArrayOutputStream();
			channel.setExtOutputStream(stderrStream);

			channel.connect();
			
//			while (!channel.isEOF()) {
//			while (channel.getExitStatus() == -1) {
			while (!channel.isEOF() || channel.getExitStatus() == -1) {
				try {
					channel.wait(100);
				} catch (Exception e) {
				}
			}
			
			runningStatus = STATUS_DONE_OK;
		} catch (JSchException e) {
			runningStatus = STATUS_DONE_NG;
			
			Activator.logException(e);
		} finally {
			((AbstractCommand)command).setSTDOut(toString(stdoutStream));
			((AbstractCommand)command).setSTDErr(toString(stderrStream));
			if (channel != null) {
				channel.disconnect();
				((AbstractCommand)command).setSystemStatusCode(channel.getExitStatus());
			}
		}
	}

	public static String toCommandString(ConcreteCommand cCommand) {
		StringBuffer strBuffer = new StringBuffer();
		strBuffer.append(cCommand.getCommand());
		if (cCommand.getStrOptions() != null) {
			for (int cnt = 0; cnt < cCommand.getStrOptions().length; cnt++) {
				strBuffer.append(" ");
				strBuffer.append(cCommand.getStrOptions()[cnt]);
			}
		}
		if (cCommand.getStrArgs() != null) {
			for (int cnt = 0; cnt < cCommand.getStrArgs().length; cnt++) {
				strBuffer.append(" ");
				strBuffer.append(cCommand.getStrArgs()[cnt]);
			}
		}
		return strBuffer.toString();
	}

	private String toString(ByteArrayOutputStream outputStream) {
		if (outputStream == null)
			return null;
		return new String(outputStream.toByteArray());
	}

	private int runningStatus = STATUS_UNKNOWN;
	
	public boolean isSuccessful() {
		return runningStatus == STATUS_DONE_OK;
	}

}

