<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/user.class.php');
	require_once(TODOTASK_CTRL_DIR.'/email.class.php');

	// ページロード
	$page = gfPageLoad();

	$page->title = TITLE_USERREMINDER;
	$page->user_mail = gfIssetPOST('mail',""); 
	$page->csrf = gfIssetPOST('csrf',""); 	 //CSRF対策

	// check page parameter
	$page->chkPage();

	$sMsg = "";	 
	$page->backurl = ""; //戻り先URL

	$objUser = new User();
	$objMail = new EMail();

	//ログイン状態解除
	$objUser->UnsetLogin();

	if ($page->user_mail == "") {
		$sMsg = LOGIN_MSG_011;
	} else {
		// CSRFのチェック
		$objUser->chk_csrf($page,$page->csrf,"1");

		// メールアドレスの形式の確認
		if (!EMail::ChkMailAdr($page->user_mail)) {
			$page->art_msg = USER_ART_012;
		}

		// メールアドレスの存在確認&更新
		$aryUser = $objUser->ChkUserMail($page->user_mail);
		
		// user_id , user_passの取得
		if (isset($aryUser[0]['user_id'])) {
			// メールボム防止用
			if ($aryUser[0]['datedif']<=1) {
				gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , LOGIN_MSG_013 ,$page->backurl ,MSG_NOR);
			}

			foreach ($aryUser as $key => $val) {
				// 外部認証のユーザーIDの確認
				if (!$objUser->ChkIDfmt($val['user_id'])){
//					$sMsg = USER_ART_013;				
//					gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , LOGIN_ART_014 ,$page->backurl ,MSG_NOR);
					continue;
				}

				// パスワード再発行
				$newpass = ctrl::get_rndcd();
	
				// トランザクション発行
				$retUpd = $objUser->begin_trans();
				// ユーザ情報の更新
				$retUpd = $objUser->UpdUserMst(
						$val['user_id'],
						$val['user_name'],
						$newpass,
						$page->user_mail,
						$val['user_note']);
				if (!$retUpd) {
					$sMsg = $objUser->get_errmsg();
				}
				// コミット|ロールバック
				$objUser->commit_trans($retUpd);
	
				// 再発行メールの送信
				$objMail->SendReminder($page->user_mail,$val['user_id'],$val['user_name'],$newpass);
			}

		} else {
			gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , LOGIN_MSG_012 ,$page->backurl ,MSG_NOR);
		}


	}

	$page->art_msg = $sMsg;

	// CSRFの発行
	$page->csrf = sha1("1".CSRF_SEED);

	$page->display('/user/reminder.php');

	// ページ終了処理
	gfPageUnLoad();

?>