<?php
class EMail {
	function __construct(){

	}

	function __destruct(){

	}

	// メールアドレスの形式を確認する
	static public function ChkMailAdr($mailadr) { 
		// 簡易的にメルアドのチェック
		if (!preg_match("/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])*\.([a-zA-Z0-9\._-]+)+$/",$mailadr)){ 
			return false;
		}
		return true;
	}
	
	// ユーザー登録されたら登録されたメールアドレスにメールを飛ばす
	public function SendUserResist($address_to, $user_id, $user_name, $user_pass) { 
		$subject = "";
		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/userresist.inc.php');
		
		return self::PostMail($address_to,MAIL_FROM,$subject,$message);
	}
	
	// システム障害が発生したら管理者あてにメールを飛ばす
	public function SendErrorMail($note) { 
		$subject = "";
		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/errorsend.inc.php');
		
		return self::PostMail(ADMIN_MAIL,MAIL_FROM,$subject,$message);
	}
	
	// グループ同報メール
	public function SendGroupMail($address_to,$message,$group_no,$group_name,$user_name) { 
		$subject = "";
//		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/grpmail.inc.php');
		
		return self::PostMail($address_to,MAIL_FROM,$subject,$message);
	}
	
	// グループ勧誘メール
	public function SendSolicitMail($address_to,$message,$group_no,$group_name,$user_name) { 
		$subject = "";
//		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/grpsolicit.inc.php');
		
		return self::PostMail($address_to,MAIL_FROM,$subject,$message);
	}

	// メンバーが参加した場合に送る
	public function SendMemJoin($address_to,$user_name,$group_no,$group_name) { 
		$subject = "";
		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/memjoin.inc.php');
		
		return self::PostMail($address_to,MAIL_FROM,$subject,$message);
	}

	// 担当者にメールを送る
	public function SendDouser($address_to,$user_name,$group_no,$group_name,$note,$detail) { 
		$subject = "";
		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/douser.inc.php');

		return self::PostMail($address_to,MAIL_FROM,$subject,$message);
	}

	// パスワード再発行メールを送る
	public function SendReminder($address_to,$user_id,$user_name,$newpass) { 
		$subject = "";
		$message = "";
		require_once(TODOTASK_VIEW_DIR.'/mail/reminder.inc.php');

		return self::PostMail($address_to,MAIL_FROM,$subject,$message);
	}

	
	// メールを送信する
	private function PostMail($address_to,$address_from,$subject,$message,$addheader="") { 
		if ($address_to == "") {
			return false;
		}
	
		$header = "From: ".$address_from."\n";
		$header .= "Reply-To:".$address_from."\r\n";
		$header .= $addheader;
		mb_language("Japanese");
	
		if (MAILTITLE_ENCODE != "") {
		//	$subject = "=?iso-2022-jp?B?".base64_encode($subject)."?="; 
			$subject = $subject;
			$subject = base64_encode($subject);		//いったんbase64エンコード化
			$subject = mb_convert_encoding($subject,"iso-2022-jp",MAIL_ENCTYPE);
			$subject = "=?ISO-2022-JP?B?" . $subject . "?=";
	
		} else {
//			$subject = mb_encode_mimeheader(mb_convert_encoding($subject, "JIS", MAIL_ENCTYPE), "JIS");
//			$subject = mb_convert_encoding($subject,"euc-jp",MAIL_ENCTYPE);
//			$subject = mb_convert_encoding($subject,"iso-2022-jp",MAIL_ENCTYPE);
			$subject = mb_convert_encoding($subject,MAIL_ENCTYPE_TO,MAIL_ENCTYPE);
		}
	
		$str_enc = mb_detect_encoding($message);

	
		if (DEBUG_FLG) {
			gfDebugPrint("メール送信：".$message);
		}

		#メール送信
		if(mb_send_mail($address_to, 
					    $subject, 
					    mb_convert_encoding($message, "iso-2022-jp", MAIL_ENCTYPE), 
					    $header)){
			return true;

		} else {
			return false;
		}
	
	}
	
}


?>