<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/task.class.php');
	// ページロード
	$page = gfPageLoad();
	$page->mode = gfIssetPOST('mode',""); 
	$page->task_no = gfIssetPOST('task_no',""); 
	$page->group_no = gfIssetPOST('group_no',""); 
	$page->taskbox_id = gfIssetPOST('taskboxid',""); 
	$page->csrf = gfIssetPOST('csrf',""); 
	$cmnt_no = gfIssetPOST('cmnt_no',""); 
	$cmnt = gfIssetPOST('cmnt',""); 
	gfChkNum($cmnt_no,"0");

	// check page parameter
	$page->chkPage();

	// パラメーターの確認
	if ($page->csrf != sha1($page->group_no.$page->task_no.CSRF_SEED)) {
		exit;
	}


	// 権限のチェック
	$objTask = new Task();
	$page->user_name = $objTask->get_loginname(); 
	$page->user_id = $objTask->get_loginid(); 

	// 取得したグループが存在するか確認
	if (!$objTask->ChkGroupMst($page->group_no)) {
		exit;
	}

	// 表示モードの取得
	$aryViewMode = $objTask->GetViewMode($page->group_no);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($aryViewMode['taskboxmax'])) {
		exit;
	}

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objTask->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv < GRPAUTH_MEM && $aryViewMode["view_flg"] != GRP_VIEW_OK) {
		exit;
	}

	// 削除権限の確認
	//＠＠＠

	// 更新モードの確認
	if ($page->mode != TASK_CLASS_MODE_CMNTINS && $page->mode != TASK_CLASS_MODE_CMNTDEL) {
		exit;
	}

	// トランザクション発行
	$retIns = $objTask->begin_trans();
	if ($page->mode == TASK_CLASS_MODE_CMNTINS) {
		$retIns = $objTask->InsCmntAjax($page->user_id , $page->task_no ,$page->group_no ,$cmnt ,$page->taskbox_id); 
	} else if($page->mode == TASK_CLASS_MODE_CMNTDEL) {
		$retIns = $objTask->DelCmntAjax($page->user_id , $page->task_no ,$page->group_no ,$cmnt ,$page->taskbox_id, $cmnt_no); 
	}
	// コミット|ロールバック
	$objTask->commit_trans($retIns);

	// コメントの追加
	if (!$retIns) {
		exit;
	}

	if ($page->mode == TASK_CLASS_MODE_CMNTINS) {
		$val = array();
		$val['cmnt_no'] = $objTask->last_cmnt_no; 
		$val['cmnt'] = $cmnt; 
		$val['add_user_name'] = $page->user_name; 
		$val['add_date'] = 'new!'; 

		// コメント内容を表示する
		require(TODOTASK_VIEW_DIR.'/task/cmnt.inc.php');

	} else if($page->mode == TASK_CLASS_MODE_CMNTDEL) {
		// 削除したコメント番号を返す
		print($cmnt_no);
	}

	// ページ終了処理
	gfPageUnLoad();
?>