<?php
	// ページ描画
	// ヘッダ
	require_once(TODOTASK_VIEW_DIR.'/common/header.inc.php');
?>

<div align="center">

<div class="noticediv" style="text-align:left;">
<h1>TODOタスクの便利な使いかた</h1>

<h2>特徴！</h2>
<ol>
<li>やることを管理するのに便利です！</li>
<li>豊富な機能がついています！</li>
<li>無料でご利用いただけます！</li>
<li>オープンソースプログラムです！</li>
</ol>


<h2>タスク管理という手法をご存知ですか？</h2>
<p>
「今日中にやることリスト」や「備忘録」など、細やかなやらなければいけないことを、書き出したりするリストを作成されたことはありませんか？<br>
このサービスはそのようなやらなければいけないことをWeb上のサービスとして提供するものです。<br><br>

このような方法はTODOリストやタスク管理、プロジェクト管理、GTD、BTSなど様々な呼ばれかたをし、その方法も様々です。<br>
そのなかでもトドタスクは
業務で使用することを念頭に設計デザインしていますので、効率的なお仕事をするため
タスクを共有し進捗を管理したり承認したりする機能に長けています。<br>
<br>

またこのサービスを提供するためのプログラムソースをBSDライセンスとして再利用、再配布可能な状態で配布していますので、
システムを社内設置すればよりセキュリティの高い環境下において運用も可能です。
</p>
<br>
<br>
<br>


<h2>タスクを管理することにより何が変わるか？</h2>
<h4>タスクをリストにするために必要なことはなんでしょうか？</h4>
<p>
トドタスクを利用するには<b>「やらなければいけないこと」</b>を実行可能なレベルにまで分解する必要があります。
この明記し、列挙する行為に意味があります。<br><br>

見失いがちな目標を明確に「実行可能」レベルのタスクに落とし込むことにより、自分やチームがやらなければならない仕事を遂行するのに役立つことでしょう。
<br>
何をやらなければいけないのかも曖昧な状態では任務や障害を越えて目標にたどり着くのは困難です。まず必要なのはリスト化です。
<br>
<br>
</p>
<h4>タスクをリストにすると何か変わりますか？</h4>
<p>
仕事を片付けようとしたときに普通の人は優先順位の高いものから処理していきます。<br>
しかしながらやらなければいけないことというのは次から次に新しいものが発生してきます。<br>
結果、優先順位の低かったものは後回し後回しにされますが、
だからといって優先順位の低かった「やらなければいけないこと」は、時間が経ったからといって「やらなくてもいいこと」に変化したりはしません。<br>
仕事ができる人は習慣としてこの優先順位の低いタスクもきちんと処理する傾向があるそうです。<br>
トドタスクに登録したタスクは自動的には消えません。あなたがなんらかの処理をする必要があります。

</p>
<br>
<br>
<br>
<br>

<div style="margin:auto;padding:auto;text-align:center;">
<img src="./images/whytodotask.png" alt="タスクや障害を詳細に分解しリストにすることはあなたを目標から遠ざけないただひとつの吸引力！" border="0">
</div>
<br>
<br>
<br>



<h2 style="margin-top:40px;">トドタスクにはこんな機能があります</h2>

<h4>グループ機能</h4>
<p>
グループ単位でタスクを管理することにより、目的別にタスクを管理することができます。<br>
ひとつのタスクグループを複数のメンバーで共有することが可能です。<br>
グループへの参加を管理できたりグループの管理権限の変更などがおこなえます。
グループメンバーであればタスク担当者へ指定ができますので、管理者によるタスクの割り振りなどがおこなえます。
メンバー外にはタスクを表示させないというような非公開機能や、リスト一覧に表示する項目を選択したり、
またメンバーへの告知事項などを登録することにより連絡事項を周知徹底させることができます。<br>
</p>



<h4>ボックス機能</h4>
<p>
「同じ系統のタスクなんだけど、ちょっと種目が違うなー」というときに新しくタスクボックスを追加することにより、さらなる振り分けが可能です。
同一グループ内であれば既存のタスクのボックスの振り替えもできます。
ボックスの名称の設定や重要度別に並び替えなどが行えますので、高い自由度でご利用いただくことができます。<br>
</p>


<h4>重要度変更機能</h4>
<p>
タスクの優先順位やグループ、ボックスの重要度の変更が簡単におこなえます。<br>
タスク登録後の変更も簡単にできますので、状況や環境の変化による優先順位の変更にも柔軟に対応できます。

</p>


<h4>タスクの視認性の高さ</h4>
<p>
グループごとに表示状態をコントロールできます。
一定期間状態変更がないタスクについては色を変えたり、一覧に表示する項目を変更できます。
用途に応じてはプリントアウトしてそのまま使えるように考えて作成しています。
</p>


<h4>編集機能の豊富さ</h4>
<p>
新規登録、編集、削除などの通常機能のほかに、一部項目については一覧からの編集も可能です。


</p>

<h4>メール機能</h4>
<p>
チームプロジェクトの場合、進捗とは別に簡単な指示や報告が必要になることがあるかと思います。
そんな時に、グループ内で相手を指定してid指定でメールを送信することができるので、抜かりなく事にあたることができます。
また、メールアドレスがわかっていればその人に対してグループへの勧誘メールを送ることができます。<br>
担当者が指定されているタスクについて情報が更新された場合、メールを送信して担当者へ知らせることができます。<br>
※メール機能が有効になっている場合のみ使えます。また外部認証を利用してログインしているユーザー相手には使用できません。
</p>


<h4>タスクすら忘れてしまわないために</h4>
<p>
Windowsであれば、タスクグループのショートカットアイコンを保存できます。
ユーザー情報のページからショートカットをダウンロードしてディスクトップなど目立つところに置いておくことができます。<br>
</p>
<br>
<br>
<br>




<h2>トドタスクはこんな風に使うことができます</h2>
<h4>ものごとを確実に終了させるために</h4>
<p>
TODOリスト、GTDなどと呼ばれる手法ですが、淡々と備忘録的にタスクをメモしていくことにより確実にものごとをこなしていくためのもっともシンプルな使い方です。
</p>

<h4>日常業務の管理に</h4>
<p>
ボックスに「すぐやる」「あとでやる」「ペンティング」「おわった」というように登録し、
お客様からあがってきたクレームを「すぐやる」ボックスに登録し、担当者の処置が終われば、
対処内容を詳細欄に設定し、タスクを終了にして「おわった」ボックスへ移動させる……管理者がそれを見てタスクの状態を完了にするなどという、
一般的な通常業務にご利用いただけます。
</p>

<h4>稟議書代わりに</h4>
<p>
グループの承認機能をONにすれば、タスクごとに承認などスタンプを押すことができます。
複数人がスタンプを押せますので、稟議書などの承認経路としても使うことができます。
またスタンプには参加/不参加などのようなスタンプもありますので、
社内イベントなどを企画するのに役立つかもしれません。
</p>

<h4>バグトラッキングシステムとして</h4>
<p>
スクリーンショットをアップロードするための画像アップローダーや、
承認機能、担当者へのメール連絡、タスクステータス管理、進捗報告、コメント機能、これらの項目をうまくつかえば
バグトラッキングシステムとしても有効に機能します。
</p>

<h4>予定表として</h4>
<p>
タスクボックスに「すぐやる」「今週中に」「その先の予定」などというような漠然とした予定の管理から、
「購入する」「行く」「勉強する」「調べる」といった行動体系別の管理のしかたもできるかと思います。<br>

タスクはできるだけ詳しく落とし込むことがコツです。勉強するというタスクを登録する場合でも、「理科の教科書P132～136まで」というように書きましょう。<br>
作業ボリューム、期日を入力する欄などがありますので、お仕事でプロジェクトマネージャーなどが担当者割り振りのスケジューラーなどに使うこともできます。

</p>



<br>
<br>
<h2>ちょっと面白い使い方</h2>


<h4>買いたいものリスト</h4>
<p>
「欲しい！」と思って買ってはみたけれども全然使わなかったとか、
スグに買ったら後からもっといいものが出たという後悔はだれにでもあると思います。<br>
<br>
「欲しくなった」
「一週間たってもまだ欲しい」
「一ヶ月経ってもまだ欲しい」
「お金にすごく余裕ができたら欲しい」などとボックス登録い、
一ヶ月経っても欲しければ買うなどというふうに
自分の中でルールを定めコントロール行えば、
熱くなりがちなあなたの衝動買い購入癖を押さえ込んでくれるかもしれません。

</p>

<h4>ウイッシュリスト</h4>
<p>
やりたいなーと思ったことを漠然と期限を決めずに書き綴っていくやりかたです。

タスクではないのだけど、長期にやりたいことを備忘録的にまとめるタスクの管理のしかたです。
文章として書き込むという作業をすることにより、夢をより具体的にイメージし実現に一歩近づかせます。
タスクボックスの登録例としては「逢ってみたい人」「手に入れたいもの」「認められたいもの」「身に着けたい技能」などといったものが考えられます。
</p>

<h4>逢ってみたい人リスト</h4>
<p>
書けば願いがかなうというわけではありませんが、
逢ってみたい有名人などを書き綴っていくとあなたはその人に逢えるように努力をするようになるかもしれません。<br><br>

またリストにして公開しておくことにより誰かがあなたにその人を引き合わせてくれるかもしれません。
完了しないタスクだらけになりますが、逢いたい人を探すという行為やそれをメモしておくことは非常に有益なことです。
逢いたい人の年代別にボックスにしまっておくようなグループをつくってみてはどうでしょうか？
<br>
</p>

<h4>バケットリスト</h4>
<p>
The Bucket List という映画が2008年に公開になりました。
このバケットリストというのは、「死ぬ前にやりたいことのリスト」(bucket:くたばる)という意味ですが、
自分の根源的な「やりたいこと」を明確にしておくのはあなたの人生に後悔を残さないための第一歩かもしれません。

</p>


<br>
<br>
<br>

<h2>TODOTASKが肌にあわないという人のために</h2>
<p>
<p>
TODOTASKの使い方はあなた次第!<br>
あなたにあったやり方を探すことができます。
でも、そんなTODOTASKも万能ではありません。馴染めない人もいるでしょう。<br>
そんな人が「やらなきゃいけないことに埋もれちまないように」
他のシステムややり方もご案内しておきます。<br><br>
</p>


<p>
タスク管理やプロジェクト管理をするためのツールというのはこれまでにも多くのものがつくられてきました。
「リストを記録していくだけ」という必要条件がシステムとしてとても簡単だからです。
ここでは私が実際に利用するなどした他のプログラムやサービスなどをご紹介します。<br><br>

TODOTASK流のプロジェクト管理が自分の目的にはそぐわないなどありましたら下記のサービスなりを試されてみてはどうでしょう？<br>
もちろんTODOTASKについて機能改善要求をうけつけないというわけではありません。ですが使い比べてみるというのも重要なことだと思います。
</p>

<br><br>


<h3>アナログな方法、もしくはライフハック(笑)</h3>
<h4>チラシの裏に書きなぐる</h5>
<p>
知人にTODOTASKを説明しようとしたら、「そんなの手帳に書くからつかわないよ」とばっさり切り捨てられました。
至極もっともです。<br>

自分も1日スパンのTODOであれば朝にタスクをA4の裏紙に箇条書きしています。
TODOが完了ししだい横線を引いて、その日1日が終わったら紙をくしゃくしゃっとまるめてゴミ箱に捨てるというやりかたでTODOを管理しています。この「まるめて捨てる」という行為が精神衛生上非常にスカっとします。<br>
実際個人で完結するタスクであればこの方法が一番らくちんです。<br>
ただ書き出したタスクが完了しなかった場合、横線だらけになった裏紙を翌日までもちまわらなきゃいけないので気分が重たくなる諸刃でもあります。
</p>

<h4>付箋を利用する</h5>
<p>
これもアナログな手法のひとつです。付箋で管理する人も居ますね。<br>
私も新入社員のころは一時期モニターの周りを付箋だらけにしていました。タスクが少なく単純なものであればこのやり方もらくちんでしょう。
<br>

このようなやり方については雑誌でよく特集されていますのでこちらなどご参照ください。<br>
<a href="http://business.nikkeibp.co.jp/article/skillup/20080130/145808/?P=1&ST=sp_office" target="_blank">
To Do管理・書類整理…フセン4変化 (ビジネス基礎体力)：NBonline(日経ビジネス オンライン)
</a>

</p>

<h4>自分宛てにメールを送る</h5>
<p>
翌日にやらなきゃいけない事をもちこしてしまった場合使っていました。
朝にメールを開いて、自分からきたメールでげんなりしますが備忘の面からは有効です。<br>
難点はメールをひらきっぱなしにはしていられないので、そのメールをテキストにコピー＆ペーストして別に管理することになります。
</p>

<h4>BTS系(バグトラッキングシステム:Bug Tracking System)</h5>
<p>
主にシステム開発などの現場で利用されています。<br>
バグなどが発生した場合に担当者に対応を迫るための便利だけど非常に開発からすれば怖いシステムです。<br><br>



<big><a href="http://www.photoxp.jp/kagemai/" target="_blank">影舞</a></big><br>
掲示板ライクなインターフェイスで余計な機能がついていないのが特徴です。
実にシンプルなので運用や管理、設置も楽チンです。<br><br>

<big><a href="http://www.alles.or.jp/~sogabe/mantis/manual/index.html" target="_blank">Mantis</a></big><br>
ユーザーに部署やプロジェクトなど権限をふれるので大規模なプロジェクトの管理にはとても便利です。
その分設定などで手を焼くので小規模案件や管理体制下では逆にわずらわしく感じるかもしれません。
類似用途としてredMineや、gnats、tracなどが使われています。<br><br>


<big><a href="http://www.web-20.net/2007/12/trac_1.html" target="_blank">意外と使われていない「個人用trac」活用のすすめ</a></big><br>
tracはBTSとして強力だと聞いていますが、このように個人用として使われるかたもいらっしゃるようです。
ただ個人的にはtracやMantisはsubversionなどのバージョン管理システムと連携できるのが何よりの長所だとおもいます。

</p>

<h4>WEBサービス系</h5>
<p>
<big><a href="http://www.rememberthemilk.com/?hl=ja" target="_blank">Remember The Milk</a></big><br>
備忘録系でなりもの入りで日本に上陸したサービス。利用されている人いますか？<br>
タスク管理というよりは備忘録のために使われることに特化したサービスのようです。
GTD(Getting Things Done)などと呼ばれる手法です。<br><br>

<big><a href="http://fixdap.com/" target="_blank">fixdap</a></big><br>
livedoorが提供するタスク共有ツールです。<br>
他にも様ざまタスクを共有するためのサービスが有名ですので探してみてください。
また、これがあるよ！というのがあったらお知らせください。
</p>

<h4>スケジュール管理系</h5>
<p>
ここまでくるとタスクの管理というよりはグループウエアとしての機能で探されたほうがいいかもしれません。<br>
主な手法としてガンチャートやカレンダー共有などがあげられます。<br><br>


<big><a href="http://www.google.com/intl/ja/googlecalendar/tour.html" target="_blank">Google カレンダー</a></big><br>
カレンダー機能ではGMailなどとの組み合わせで機能させることができますので、便利かもしれません。
ただ業務で使うにはWebサービスは不安が残ります。
サイボウズが提供するグループウエアあたりを利用されるのが導入費用は掛かりますが経営上のリスクを考えたらペイできる範囲かもしれません。
<a href="http://office.cybozu.co.jp/cb6/download/" target="_blank">グループウェア 「サイボウズ Office 6」</a><br>

また、まだ新興ですが<br>
<big><a href="http://aipostyle.com/" target="_blank">日本発オープンソースグループウェア 『アイポ4』</a></big><br>
このようなオープンソースものも注目を集めだしています。<br><br>



プロジェクトマネージャークラスになると、スケジュール管理のためにガンチャートを作成したりすることでしょう。
各社独自のExcelシートを作ったり、Microsoft Projectなんかをつかって作成し、印刷したものを配布するなどというやりかたが普通かと思います。

あえて特殊な例をあげるとするとMS　VISIOを用いた

フィッシュボーンチャートを使った例があります。これはロードマップ策定やマイルストーン設置には便利かと思います。<br>

<a href="http://www.microsoft.com/japan/users/2003/010/03.aspx" target="_blank">仕事のアイデアをカタチにする方法 | Visio 2003 は発想支援ツール？</a><br>
<a href="https://www.microsoft.com/japan/office/previous/2003/visio/think/kubotatsu/nyumon.mspx" target="_blank">Microsoft Office Visio 2003 - くぼたつ流 Visio 2003 で描く勝てる企画書 入門編</a><br>


</p>


<h4>まとめ系,その他、参考</h5>
<p>
・<a href="http://fnya.cocolog-nifty.com/blog/2008/01/post_f8c6.html" target="_blank">フリーで使えるプロジェクト管理ツールまとめ</a><br>
・<a href="http://itpro.nikkeibp.co.jp/article/REVIEW/20070918/282204/" target="_blank">プロジェクト管理ツール：ITpro</a><br>
・<a href="http://blog.livedoor.jp/ld_directors/archives/50936960.html" target="_blank">デスマーチを防ぐスケジューリング</a><br>
・<a href="http://lifehacking.jp/2007/03/todo-list-revisited1/" target="_blank">ToDo リスト再考 (1) ToDo にいれてはいけないもの</a><br>
<small>
日経ビジネス・アソシエ2月19日号が煽ったせいでnot-to-do リストつくりなるものが流行ったそうです。
個人的には自分のアビリティ特性を再考する意味でnot-to-do リストをつくることに意味はあるかとおもいますが、
not-to-do リストを創る事をTODOとしちゃうのはどうかなと。
TODOリストではなくウイッシュリストと切り離して考えてはどうでしょう？
（Amazonがウイッシュリストを欲しいものリストと変えて話題になっていましたが…）
</small>
</p>



<br>




<br>
<br>

</div>


<br><br><br>
<a href="<?php echo $this->backurl; ?>">もどる</a>
<br><br>
</div>


<?php
	// フッター
	include_once(TODOTASK_VIEW_DIR.'/common/footer.inc.php');

?>	