<?php

// extends Exception 
class Ctrl {
	private $ErrMsg = "";
	
	public function ctrl_movepage($url_path=""){

		$filename = "";
		$linenum = "";
		if (headers_sent($filename, $linenum)) {
			// ヘッダー送出済み
			gfMsgWindow("" ,MSG_MODE_REDIRECT ,ERR_TITLE , HEADER_ERR_001." file:".$filename." line:".$linenum ,$url_path ,MSG_NOR);
		}

		if (DEBUG_FLG) {
			gfDebugPrint("move : <a href=\"" .ROOT_URL .$url_path . "\">".ROOT_URL .$url_path."</a>");
		} else {
			header("Location: " . ROOT_URL . $url_path);
		}
		exit;
	}

	public function set_errmsg($Msg){
		$this->ErrMsg = $Msg;
		return true;
	}
	
	public function get_errmsg(){
		return $this->ErrMsg;
	}

	public function make_page($iPageAll,$nowpage,$max_page,$link){
		$sTmp = "";
		if ($iPageAll <= 0) {
			return $sTmp;
		}

		// 表示開始ページ位置
		$start_page = 0;
		if( $iPageAll > $max_page ) {
			$start_page = $nowpage - ceil($max_page/2) +1;
		}
		if ($start_page < 1) {
			$start_page = 1;
		}
	
		$sTmp .= PAGE_LABEL;
		// 前の件数表示
		if ($start_page > 1) {
			$sTmp .= "<a href=\""
					.$link
					."&pageno=".($start_page-1)."\">"
					.PAGE_LABEL_PRE."</a>&nbsp;";
		}
	
		// ページリンク
		for ($i = 0; $i < $max_page; $i++) {
			$linkpage = ($start_page + $i); 
			if ($linkpage == (int)$nowpage ) {
				$sTmp = $sTmp.($linkpage)."&nbsp;";
			} else {
				$sTmp .= "<a href=\""
						.$link
						."&pageno=".($linkpage)."\">"
						.($linkpage)."</a>&nbsp;";
			}
			// 表示ページ数がすべてのページ数を超えた時
			if ($linkpage >= $iPageAll) {
		    	break;
		    }
		}
	
		// ページ数が残っている場合
		if (($start_page+$max_page) <= $iPageAll) {
			$sTmp .= "<a href=\""
					.$link
					."&pageno=".($start_page+$max_page)."\">"
					.PAGE_LABEL_NEXT."</a>&nbsp;";
		}

		return $sTmp;
	}


	public function chk_csrf($page,$csrf,$seedcd){
		// CSRFのチェック確認
		if ($csrf != self::get_csrf($seedcd)) {
			// 想定外ルート
			gfHackTryLog(__FILE__.__LINE__."chk_csrf");
			gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , POST_ERR_001 ,"" ,MSG_NOR);
		}
	}

	public function get_csrf($seedcd){
		// パラメーターの作成
		$csrf = sha1($seedcd.CSRF_SEED);
		return $csrf;
	}

	// パスワード再発行
	public function get_rndcd(){
		$newpass = "";
		// パスワード自動発行
		// 禁則文字
		$ngchar = array(42,43,44,45,46,47,58,59,60,61,62,63,64,92,94,96,124);

		// 参考、使用キャラコード
//			$cnt = 40;
//			echo "<textarea rows=30 cols=20>";
//			while ($cnt < 125) {
//				if (in_array($cnt, $ngchar)) {
//					$cnt++;
//					continue;
//				}
//				echo "$cnt:".chr($cnt)."\n";
//				$cnt++;
//			}
//			echo "</textarea>";

		$passlen = MIN_IDLEN*2;
		mt_srand(microtime()*100000);
		$cnt = 0;
		while ($cnt <= $passlen) {
			$ret_rand = mt_rand(40, 125); 
			if (!in_array($ret_rand, $ngchar)) {
				$newpass .= chr($ret_rand);
				$cnt++;
			}
		}

		return $newpass;
	}
	
	
}

?>