<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/task.class.php');

	// ページロード
	$page = gfPageLoad();
	$page->title = TITLE_TASKLIST;
	$page->protype_flg = "1";
	$page->group_no = gfIssetGET('group_no',""); 
	$page->taskbox_id = gfIssetGET('taskboxid',""); 
	$page->task_no = gfIssetGET('taskno',"");	// タスクNO 
	$page->mode = gfIssetGET('mode',TASK_CLASS_MODE_NEW); 
	$page->gmode = gfIssetGET('gmode',TASK_MODE_PAGE);	// グループモードの確認 
	$page->pageno = gfIssetGET('pageno',1); 

	// check page parameter
	$page->chkPage();

	// ログイン確認
	$objTask = new Task();
	$page->user_name = $objTask->get_loginname(); 
	$page->user_id = $objTask->get_loginid(); 

	// 取得したグループが存在するか確認
	if (!$objTask->ChkGroupMst($page->group_no,$page->taskbox_id)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}
	$page->group_name = $objTask->get_group_name($page->group_no); 

	// 表示モードの取得
	$page->aryViewMode = $objTask->GetViewMode($page->group_no,$page->gmode);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($page->aryViewMode['taskboxmax'])) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_003_1 , TASK_ART_003_2 ,$page->backurl ,MSG_NOR);
	}
	// グループメール
	$page->grpmail_flg = $page->aryViewMode['grpmail_flg'];


	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objTask->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv < GRPAUTH_MEM && $page->aryViewMode["view_flg"] != GRP_VIEW_OK) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_002_1 
			,TASK_ART_002_2
				.TASK_ART_002_3
				."<a href=\"grpjoin.php?group_no=".$page->group_no."\">"
				.TASK_ART_002_4
			,$page->backurl ,MSG_NOR);
	}

	// タスクボックスの取得
	$page->aryTaskBox = $objTask->GetTaskbox($page->group_no,$page->taskbox_id,$page->gmode);
	// タスクリストの取得
	foreach ($page->aryTaskBox as $aryBox) { 
		$page->aryTaskList[$aryBox["taskbox_id"]] 
			= $objTask->GetTask(
				$aryBox["group_no"],
				$aryBox["taskbox_id"],
				$page->pageno,
				$page->aryViewMode,
				$page->gmode);
	}

	// 
	if ($page->gmode != TASK_MODE_PAGE) {
		$page->page_cnt = $objTask->GetTaskPageCnt($page->aryViewMode,$page->group_no,$page->taskbox_id); 
		$page->listcnt = $page->aryViewMode['listcnt'];
		// ページめくりのリンク追加
		$page->pagelink = $objTask->make_page(
							$page->page_cnt,
							$page->pageno,
							$page->listcnt,
								"tasklist.php?group_no=".$page->group_no
								."&taskboxid=".$page->taskbox_id
								."&gmode=".$page->gmode
							);
	} else {
		$page->pagelink = ""; 
	} 


	$page->title = $page->group_name.$page->title;

	// ページの一覧を表示する
	$page->display('/task/list.php');

	// ページ終了処理
	gfPageUnLoad();
?>
