<?php

// php 5.3以降のnamespace実装をにらんで
// page共通のプロパティ構造体にしたい

class Page {
	public $init = false;	// sa
	public $title = "";
	public $csrf = "";
	public $mode = "";		// pagemode
	public $gmode = "";		// グループ表示mode
	public $setmode = "";


	public $user_name = "";
	public $user_id = "";
	public $pass = "";

	public $pageno = 1;			// 表示ページ番号

	public $group_no = "";
	public $group_name = "";

	public $taskbox_id = "";
	public $task_no = "";

	public $staylogin = "";			// ログイン情報を保持する
	public $grpmail_flg = "";		// グループメール
	public $memLv = "";			// ユーザーのメンバー権限
	public $page_cnt = "";		// ページ総数
	public $listcnt = "";		// 項目数保持用
	public $errflg = "";		// エラーの場合1
	public $art_msg = "";		// 警告メッセージ
	public $backurl = "";		// 戻り先指定URL
	public $pagelink = "";		// ページめくりようリンク
	public $protype_flg = "";	// プロトタイプを利用する
	public $definput_flg = "";	// デフォルト入力補助のJsを利用する
	public $refresh_tag = "";	// 自動更新タグを挿入する
	public $sumsize = "";		// 合計ファイルサイズ

	public $aryGrpInfo = array();	// グループ情報
	public $aryViewMode = array();	// 表示モード
	public $objUser = array();		// ユーザー情報
	public $aryUserGrp = array();	// ユーザー所属グループ
	public $aryTask = array();		// タスク情報
	public $aryTaskBox = array();	// タスクボックス
	public $aryTaskList = array();	// タスクリスト
	public $aryLogList = array();	// ログリスト
	public $aryOptGrpMem = array();	// 担当者リスト
	public $aryGrpList = array();	// グループリスト
	public $aryImgList = array();	// 画像情報
	public $aryCmntList = array();	// コメント情報
	public $aryApproval = array();	// 承認情報
	public $up_data = array();		// ファイル情報

	public $hatenaloginurl = "";	// HatenaKeyログイン用のURL
	public $jyugemuloginurl = "";	// JugemKeyログイン用のURL
	public $livedoorloginurl = "";	// livedoorKeyログイン用のURL



	public $contxt = array();		// 表示用配列

	function __construct(){
		$this->init = true;
	}

	public function display($filepath) {
		require_once(TODOTASK_VIEW_DIR.$filepath);
	} 
	
	// ページの基本parameterのチェック
	public function chkPage() {

		// IDタイプのチェック
		gfChkIDType($this->mode,"0");
		gfChkIDType($this->group_no,"0");
		gfChkIDType($this->taskbox_id,"0");
		gfChkIDType($this->gmode,"0");

		// 数字型のチェック
		gfChkNum($this->mygrp,"0");
		gfChkNum($this->pageno,1);
		gfChkNum($this->staylogin,"0");
		
	}

	// 承認コードの名称変換
	public function GetApprovalName($approval_no) {
		$sStatus = "";
		switch ($approval_no) {
			case APPR_STATUS_NULL:
				$sStatus = APPR_LABEL_NULL;
				break;
			case APPR_STATUS_OK:
				$sStatus = APPR_LABEL_OK;
				break;
			case APPR_STATUS_PARTOK:
				$sStatus = APPR_LABEL_PARTOK;
				break;
			case APPR_STATUS_PEND:
				$sStatus = APPR_LABEL_PEND;
				break;
			case APPR_STATUS_NG:
				$sStatus = APPR_LABEL_NG;
				break;
			case APPR_STATUS_CONF:
				$sStatus = APPR_LABEL_CONF;
				break;
			case APPR_STATUS_EYES:
				$sStatus = APPR_LABEL_EYES;
				break;
			case APPR_STATUS_SUPPORT:
				$sStatus = APPR_LABEL_SUPPORT;
				break;
			case APPR_STATUS_DISSIPPORT:
				$sStatus = APPR_LABEL_DISSIPPORT;
				break;
			case APPR_STATUS_NONCOMMITTAL:
				$sStatus = APPR_LABEL_NONCOMMITTAL;
				break;
			case APPR_STATUS_REVERSE:
				$sStatus = APPR_LABEL_REVERSE;
				break;
			case APPR_STATUS_NOMATTER:
				$sStatus = APPR_LABEL_NOMATTER;
				break;
			case APPR_STATUS_MATTER:
				$sStatus = APPR_LABEL_MATTER;
				break;
		}
		return $sStatus;
	}

	// 表示コードの名称変換
	public function GetStatusName($status_cd) {
		$sStatus = "";
		switch ($status_cd) {
			case TASK_STATUS_PRE:
				$sStatus = TASK_LABEL_STATUS_PRE;
				break;
			case TASK_STATUS_NOW:
				$sStatus = TASK_LABEL_STATUS_NOW;
				break;
			case TASK_STATUS_FIN:
				$sStatus = TASK_LABEL_STATUS_FIN;
				break;
			case TASK_STATUS_PEN:
				$sStatus = TASK_LABEL_STATUS_PEN;
				break;
			case TASK_STATUS_DEL:
				$sStatus = TASK_LABEL_STATUS_DEL;
				break;
			case TASK_STATUS_DROP:
				$sStatus = TASK_LABEL_STATUS_DROP;
				break;
			case TASK_STATUS_SYSTEM:
				$sStatus = TASK_LABEL_STATUS_SYSTEM;
				break;
			case TASK_STATUS_MAKE:
				$sStatus = TASK_LABEL_STATUS_MAKE;
				break;
			case TASK_STATUS_SPANDEL:
				$sStatus = TASK_LABEL_STATUS_SPANDEL;
				break;
			case TASK_STATUS_UPD:
				$sStatus = TASK_LABEL_STATUS_UPD;
				break;
			case TASK_STATUS_GRPUPD:
				$sStatus = TASK_LABEL_STATUS_GRPUPD;
				break;
			case TASK_STATUS_VIWEUPD:
				$sStatus = TASK_LABEL_STATUS_GRPUPD;
				break;
			case TASK_STATUS_BOXUPD:
				$sStatus = TASK_LABEL_STATUS_VIWEUPD;
				break;
			case TASK_STATUS_BOXDROP:
				$sStatus = TASK_LABEL_STATUS_BOXDROP;
				break;
			case TASK_STATUS_GRPJOIN:
				$sStatus = TASK_LABEL_STATUS_GRPJOIN;
				break;
			case TASK_STATUS_CMNTINS:
				$sStatus = TASK_LABEL_STATUS_CMNTINS;
				break;
			case TASK_STATUS_CMNTDEL:
				$sStatus = TASK_LABEL_STATUS_CMNTDEL;
				break;
			case TASK_STATUS_GRPINFO_UPD:
				$sStatus = TASK_LABEL_STATUS_GRPINFO_UPD;
				break;
		}
		return $sStatus;
	}
	
}

?>