/**
 * Title: UniCodePage
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  Kenneth J. Pouncey
 *          rewritten by LDC, WVL, Luc
 * @version 0.4
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.encoding;

class UniCodeU20 {
	
	protected static final char[] cvtbl_u_20 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xddb4, 0xddb5, 0xddb6, ' ', 0xddb7, ' ', 0xddb8, //0x10
		' ', ' ', 0xddb9, 0xddba, ' ', ' ', 0xddbb, 0xddbc, 
		' ', ' ', 0xddbd, 0xddbe, 0xddbf, ' ', ' ', 0xddc0, //0x20
		0xddc1, 0xddc2, 0xddc3, 0xddc4, 0xddc5, 0xddc6, 0xddc7, ' ', 
		' ', 0xddc8, ' ', ' ', 0xddc9, 0xddca, 0xddcb, 0xddcc, //0x30
		0xddcd, 0xddce, 0xddcf, ' ', 0xddd0, 0xddd1, ' ', 0xddd2, 
		0xddd3, 0xddd4, 0xddd5, 0xddd6, 0xddd7, 0xddd8, 0xddd9, ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xde47, ' ', ' ', ' ', 0xde48, 0xde49, 0xde4a, 0xde4b, //0x70
		0xde4c, 0xde4d, 0xde4e, 0xde4f, 0xde50, 0xde51, 0xde52, 0xde53, 
		0xde54, 0xde55, 0xde56, 0xde57, 0xde58, 0xde59, 0xde5a, 0xde5b, //0x80
		0xde5c, 0xde5d, 0xde5e, 0xde5f, 0xde60, 0xde61, 0xde62, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xde77, 0xde78, 0xde79, 0xde7a, 0xde7b, 0xde7c, 0xde7d, 0xde7e, //0xa0
		0xde7f, 0xde80, 0xde81, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_21 = {
		0xdea7, 0xdea8, 0xdea9, ' ', 0xdeaa, 0xdeab, 0xdeac, 0xdead, //0x0
		0xdeae, 0xdeaf, 0xdeb0, 0xdeb1, 0xdeb2, 0xdeb3, 0xdeb4, 0xdeb5, 
		0xdeb6, 0xdeb7, 0xdeb8, 0xdeb9, 0xdeba, 0xdebb, ' ', 0xdebc, //0x10
		0xdebd, 0xdebe, 0xdebf, 0xdec0, 0xdec1, 0xdec2, 0xdec3, 0xdec4, 
		0xdec5, ' ', 0xdec6, 0xdec7, 0xdec8, 0xdec9, 0xdeca, 0xdecb, //0x20
		0xdecc, 0xdecd, 0xdece, ' ', 0xdecf, 0xded0, 0xded1, 0xded2, 
		0xded3, 0xded4, 0xded5, 0xded6, 0xded7, 0xded8, 0xded9, 0xdeda, //0x30
		0xdedb, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xdef3, 0xdef4, 0xdef5, 0xdef6, 0xdef7, //0x50
		0xdef8, 0xdef9, 0xdefa, 0xdefb, 0xdefc, 0xdefd, 0xdefe, 0xdf41, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', 0xdf42, 0xdf43, 0xdf44, 0xdf45, 0xdf46, 0xdf47, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', 0xdf48, 0xdf49, 0xdf4a, 0xdf4b, 0xdf4c, 0xdf4d, 
		0xdf4e, 0xdf4f, 0xdf50, ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xdf61, 0xdf62, 0xdf63, 0xdf64, //0x90
		0xdf65, 0xdf66, 0xdf67, 0xdf68, 0xdf69, 0xdf6a, 0xdf6b, 0xdf6c, 
		0xdf6d, 0xdf6e, 0xdf6f, 0xdf70, 0xdf71, 0xdf72, 0xdf73, 0xdf74, //0xa0
		0xdf75, 0xdf76, 0xdf77, 0xdf78, 0xdf79, 0xdf7a, 0xdf7b, 0xdf7c, 
		0xdf7d, 0xdf7e, 0xdf7f, 0xdf80, 0xdf81, 0xdf82, 0xdf83, 0xdf84, //0xb0
		0xdf85, 0xdf86, 0xdf87, 0xdf88, 0xdf89, 0xdf8a, 0xdf8b, 0xdf8c, 
		0xdf8d, 0xdf8e, 0xdf8f, 0xdf90, 0xdf91, 0xdf92, 0xdf93, 0xdf94, //0xc0
		0xdf95, 0xdf96, 0xdf97, 0xdf98, 0xdf99, 0xdf9a, 0xdf9b, 0xdf9c, 
		0xdf9d, 0xdf9e, ' ', 0xdf9f, ' ', 0xdfa0, 0xdfa1, 0xdfa2, //0xd0
		0xdfa3, 0xdfa4, 0xdfa5, 0xdfa6, 0xdfa7, 0xdfa8, 0xdfa9, 0xdfaa, 
		0xdfab, 0xdfac, 0xdfad, 0xdfae, 0xdfaf, 0xdfb0, 0xdfb1, 0xdfb2, //0xe0
		0xdfb3, 0xdfb4, 0xdfb5, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_22 = {
		' ', 0xdfcb, ' ', ' ', 0xdfcc, 0xdfcd, 0xdfce, ' ', //0x0
		' ', 0xdfcf, 0xdfd0, ' ', 0xdfd1, 0xdfd2, 0xdfd3, 0xdfd4, 
		0xdfd5, 0xdfd6, ' ', 0xdfd7, 0xdfd8, 0xdfd9, 0xdfda, 0xdfdb, //0x10
		0xdfdc, 0xdfdd, ' ', 0xdfde, 0xdfdf, ' ', ' ', 0xdfe0, 
		' ', 0xdfe1, 0xdfe2, 0xdfe3, 0xdfe4, 0xdfe5, 0xdfe6, ' ', //0x20
		' ', ' ', ' ', ' ', ' ', 0xdfe7, 0xdfe8, 0xdfe9, 
		0xdfea, 0xdfeb, 0xdfec, 0xdfed, ' ', ' ', 0xdfee, 0xdfef, //0x30
		0xdff0, 0xdff1, 0xdff2, 0xdff3, 0xdff4, ' ', 0xdff5, 0xdff6, 
		0xdff7, 0xdff8, 0xdff9, 0xdffa, 0xdffb, 0xdffc, 0xdffd, 0xdffe, //0x40
		0xe041, 0xe042, 0xe043, 0xe044, 0xe045, 0xe046, 0xe047, 0xe048, 
		0xe049, 0xe04a, ' ', 0xe04b, 0xe04c, 0xe04d, 0xe04e, 0xe04f, //0x50
		0xe050, 0xe051, 0xe052, 0xe053, 0xe054, 0xe055, 0xe056, 0xe057, 
		' ', ' ', 0xe058, 0xe059, 0xe05a, 0xe05b, ' ', ' ', //0x60
		0xe05c, 0xe05d, ' ', ' ', 0xe05e, 0xe05f, 0xe060, 0xe061, 
		0xe062, 0xe063, 0xe064, 0xe065, 0xe066, 0xe067, 0xe068, 0xe069, //0x70
		0xe06a, 0xe06b, 0xe06c, 0xe06d, 0xe06e, 0xe06f, 0xe070, 0xe071, 
		0xe072, 0xe073, ' ', ' ', 0xe074, 0xe075, ' ', ' ', //0x80
		0xe076, 0xe077, 0xe078, 0xe079, 0xe07a, 0xe07b, 0xe07c, 0xe07d, 
		0xe07e, 0xe07f, 0xe080, 0xe081, 0xe082, 0xe083, 0xe084, 0xe085, //0x90
		0xe086, 0xe087, 0xe088, 0xe089, 0xe08a, 0xe08b, 0xe08c, 0xe08d, 
		0xe08e, 0xe08f, 0xe090, 0xe091, 0xe092, ' ', 0xe093, 0xe094, //0xa0
		0xe095, 0xe096, 0xe097, 0xe098, 0xe099, 0xe09a, 0xe09b, 0xe09c, 
		0xe09d, 0xe09e, 0xe09f, 0xe0a0, 0xe0a1, 0xe0a2, 0xe0a3, 0xe0a4, //0xb0
		0xe0a5, 0xe0a6, 0xe0a7, 0xe0a8, 0xe0a9, 0xe0aa, 0xe0ab, 0xe0ac, 
		0xe0ad, 0xe0ae, 0xe0af, 0xe0b0, 0xe0b1, 0xe0b2, 0xe0b3, 0xe0b4, //0xc0
		0xe0b5, 0xe0b6, 0xe0b7, 0xe0b8, 0xe0b9, 0xe0ba, 0xe0bb, 0xe0bc, 
		0xe0bd, 0xe0be, 0xe0bf, 0xe0c0, 0xe0c1, 0xe0c2, 0xe0c3, 0xe0c4, //0xd0
		0xe0c5, 0xe0c6, 0xe0c7, 0xe0c8, 0xe0c9, 0xe0ca, 0xe0cb, 0xe0cc, 
		0xe0cd, 0xe0ce, 0xe0cf, 0xe0d0, 0xe0d1, 0xe0d2, 0xe0d3, 0xe0d4, //0xe0
		0xe0d5, 0xe0d6, 0xe0d7, 0xe0d8, 0xe0d9, 0xe0da, 0xe0db, 0xe0dc, 
		0xe0dd, 0xe0de, ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_23 = {
		' ', ' ', 0xe0ed, ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xe0f0, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xe0f2, 0xe0f3, ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_24 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x00
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		0xe270, 0xe271, 0xe272, 0xe273, 0xe274, 0xe275, 0xe276, 0xe277,	//0x60
		0xe278, 0xe279, 0xe27a, 0xe27b, 0xe27c, 0xe27d, 0xe27e, 0xe27f,
		0xe280, 0xe281, 0xe282, 0xe283, 0xe284, 0xe285, 0xe286, 0xe287,	//0x70
		0xe288, 0xe289, 0xe28a, 0xe28b, 0xe28c, 0xe28d, 0xe28e, 0xe28f,
		0xe290, 0xe291, 0xe292, 0xe293, 0xe294, 0xe295, 0xe296, 0xe297,	//0x80
		0xe298, 0xe299, 0xe29a, 0xe29b, 0xe29c, 0xe29d, 0xe29e, 0xe29f,
		0xe2a0, 0xe2a1, 0xe2a2, 0xe2a3, 0xe2a4, 0xe2a5, 0xe2a6, 0xe2a7,	//0x90
		0xe2a8, 0xe2a9, 0xe2aa, 0xe2ab, 0xe2ac, 0xe2ad, 0xe2ae, 0xe2af,
		0xe2b0, 0xe2b1, 0xe2b2, 0xe2b3, 0xe2b4, 0xe2b5, 0xe2b6, 0xe2b7,	//0xa0
		0xe2b8, 0xe2b9, 0xe2ba, 0xe2bb, 0xe2bc, 0xe2bd, 0xe2be, 0xe2bf,
		0xe2c0, 0xe2c1, 0xe2c2, 0xe2c3, 0xe2c4, 0xe2c5, 0xe2c6, 0xe2c7,	//0xb0
		0xe2c8, 0xe2c9, 0xe2ca, 0xe2cb, 0xe2cc, 0xe2cd, 0xe2ce, 0xe2cf,
		0xe2d0, 0xe2d1, 0xe2d2, 0xe2d3, 0xe2d4, 0xe2d5, 0xe2d6, 0xe2d7,	//0xc0
		0xe2d8, 0xe2d9, 0xe2da, 0xe2db, 0xe2dc, 0xe2dd, 0xe2de, 0xe2df,
		0xe2e0, 0xe2e1, 0xe2e2, 0xe2e3, 0xe2e4, 0xe2e5, 0xe2e6, 0xe2e7,	//0xd0
		0xe2e8, 0xe2e9, 0xe2ea, 0xe2eb, 0xe2ec, 0xe2ed, 0xe2ee, 0xe2ef,
		0xe2f0, 0xe2f1, 0xe2f2, 0xe2f3, 0xe2f4, 0xe2f5, 0xe2f6, 0xe2f7,	//0xe0
		0xe2f8, 0xe2f9, 0xe2fa, ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};

	protected static final char[] cvtbl_u_25 = {
		' ', ' ', ' ', ' ', 0xe352, 0xe353, 0xe354, 0xe355,	//0x00
		0xe356, 0xe357, 0xe358, 0xe359, ' ', 0xe35a, 0xe35b, ' ',
		' ', 0xe35c, 0xe35d, ' ', ' ', 0xe35e, 0xe35f, ' ',	//0x10
		' ', 0xe360, 0xe361, ' ', ' ', ' ', 0xe362, 0xe363,
		' ', 0xe364, 0xe365, ' ', ' ', ' ', 0xe366, 0xe367,	//0x20
		' ', 0xe368, 0xe369, ' ', ' ', 0xe36a, 0xe36b, ' ',
		' ', 0xe36c, 0xe36d, ' ', ' ', 0xe36e, 0xe36f, ' ',	//0x30
		' ', 0xe370, 0xe371, ' ', ' ', 0xe372, 0xe373, ' ',
		0xe374, 0xe375, ' ', 0xe376, 0xe377, 0xe378, 0xe379, 0xe37a,	//0x40
		0xe37b, 0xe37c, 0xe37d, ' ', 0xe37e, 0xe37f, 0xe380, 0xe381,
		0xe382, 0xe383, 0xe384, 0xe385, 0xe386, 0xe387, 0xe388, 0xe389,	//0x50
		0xe38a, 0xe38b, 0xe38c, 0xe38d, 0xe38e, 0xe38f, 0xe390, 0xe391,
		0xe392, 0xe393, 0xe394, 0xe395, 0xe396, 0xe397, 0xe398, 0xe399,	//0x60
		0xe39a, 0xe39b, 0xe39c, 0xe39d, 0xe39e, 0xe39f, 0xe3a0, 0xe3a1,
		0xe3a2, 0xe3a3, 0xe3a4, 0xe3a5, 0xe3a6, 0xe3a7, 0xe3a8, 0xe3a9, //0x70
		0xe3aa, 0xe3ab, 0xe3ac, 0xe3ad, 0xe3ae, 0xe3af, 0xe3b0, 0xe3b1,
		0xe3b2, 0xe3b3, 0xe3b4, 0xe3b5, 0xe3b6, 0xe3b7, 0xe3b8, 0xe3b9,	//0x80
		0xe3ba, 0xe3bb, 0xe3bc, 0xe3bd, 0xe3be, 0xe3bf, 0xe3c0, 0xe3c1,
		0xe3c2, 0xe3c3, 0xe3c4, 0xe3c5, 0xe3c6, 0xe3c7, ' ', ' ',	//0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', 0xe3d2, 0xe3d3, 0xe3d4, 0xe3d5, 0xe3d6, 0xe3d7,	//0xa0
		0xe3d8, 0xe3d9, 0xe3da, 0xe3db, 0xe3dc, 0xe3dd, 0xe3de, 0xe3df,
		0xe3e0, 0xe3e1, ' ', ' ', 0xe3e2, 0xe3e3, 0xe3e4, 0xe3e5,	//0xb0
		0xe3e6, 0xe3e7, 0xe3e8, 0xe3e9, ' ', ' ', 0xe3ea, 0xe3eb,
		0xe3ec, 0xe3ed, 0xe3ee, 0xe3ef, 0xe3f0, 0xe3f1, ' ', ' ',	//0xc0
		0xe3f2, 0xe3f3, 0xe3f4, ' ', 0xe3f5, 0xe3f6, ' ', ' ',
		0xe3f7, 0xe3f8, 0xe3f9, 0xe3fa, 0xe3fb, 0xe3fc, 0xe3fd, 0xe3fe,	//0xd0
		0xe441, 0xe442, 0xe443, 0xe444, 0xe445, 0xe446, 0xe447, 0xe448,
		0xe449, 0xe44a, 0xe44b, 0xe44c, 0xe44d, 0xe44e, 0xe44f, 0xe450,	//0xe0
		0xe451, 0xe452, 0xe453, 0xe454, 0xe455, 0xe456, 0xe457, ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};

	protected static final char[] cvtbl_u_26 = {
		0xe468, 0xe469, 0xe46a, 0xe46b, 0xe46c, ' ', ' ', 0xe46d,	//0x00
		0xe46e, 0xe46f, 0xe470, 0xe471, 0xe472, 0xe473, 0xe474, 0xe475,
		0xe476, 0xe477, 0xe478, 0xe479, ' ', ' ', ' ', ' ',	//0x10
		' ', ' ', 0xe47a, 0xe47b, 0xe47c, 0xe47d, 0xe47e, 0xe47f,
		0xe480, 0xe481, 0xe482, 0xe483, 0xe484, 0xe485, 0xe486, 0xe487,	//0x20
		0xe488, 0xe489, 0xe48a, 0xe48b, 0xe48c, 0xe48d, 0xe48e, 0xe48f,
		0xe490, 0xe491, 0xe492, 0xe493, 0xe494, 0xe495, 0xe496, 0xe497,	//0x30
		0xe498, 0xe499, 0xe49a, 0xe49b, 0xe49c, 0xe49d, 0xe49e, 0xe49f,
		' ', 0xe4a0, ' ', 0xe4a1, 0xe4a2, 0xe4a3, 0xe4a4, 0xe4a5,	//0x40
		0xe4a6, 0xe4a7, 0xe4a8, 0xe4a9, 0xe4aa, 0xe4ab, 0xe4ac, 0xe4ad,
		0xe4ae, 0xe4af, 0xe4b0, 0xe4b1, 0xe4b2, 0xe4b3, 0xe4b4, 0xe4b5,	//0x50
		0xe4b6, 0xe4b7, 0xe4b8, 0xe4b9, 0xe4ba, 0xe4bb, 0xe4bc, 0xe4bd,
		0xe4be, 0xe4bf, 0xe4c0, 0xe4c1, 0xe4c2, 0xe4c3, 0xe4c4, 0xe4c5,	//0x60
		0xe4c6, 0xe4c7, ' ', 0xe4c8, 0xe4c9, ' ', 0xe4ca, ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};

	protected static final char[] cvtbl_u_27 = {
		' ', 0xe5a3, 0xe5a4, 0xe5a5, 0xe5a6, ' ', 0xe5a7, 0xe5a8,	//0x00
		0xe5a9, 0xe5aa, ' ', ' ', 0xe5ab, 0xe5ac, 0xe5ad, 0xe5ae,
		0xe5af, 0xe5b0, 0xe5b1, 0xe5b2, 0xe5b3, 0xe5b4, 0xe5b5, 0xe5b6,	//0x10
		0xe5b7, 0xe5b8, 0xe5b9, 0xe5ba, 0xe5bb, 0xe5bc, 0xe5bd, 0xe5be,
		0xe5bf, 0xe5c0, 0xe5c2, 0xe5c3, 0xe5c4, 0xe5c5, 0xe5c6, ' ',	//0x20
		0xe5c7, 0xe5c8, 0xe5c9, 0xe5ca, 0xe5cb, 0xe5cc, 0xe5cd, ' ',
		0xe5ce, 0xe5cf, 0xe5d0, 0xe5d1, 0xe5d2, 0xe5d3, 0xe5d4, 0xe5d5,	//0x30
		0xe5d6, 0xe5d7, 0xe5d8, 0xe5d9, 0xe5da, 0xe5db, 0xe5dc, 0xe5dd,
		0xe5de, 0xe5df, 0xe5e0, 0xe5e1, 0xe5e2, 0xe5e3, 0xe5e4, 0xe5e5,	//0x40
		0xe5e6, 0xe5e7, 0xe5e8, 0xe5e9, ' ', 0xe5ea, ' ', 0xe5eb,
		0xe5ec, 0xe5ed, 0xe5ee, ' ', ' ', ' ', 0xe5ef, ' ',	//0x50
		0xe5f0, 0xe5f1, 0xe5f2, 0xe5f3, 0xe5f4, 0xe5f5, 0xe5f6, ' ',
		' ', 0xe5f7, 0xe5f8, 0xe5f9, 0xe5fa, 0xe5fb, 0xe5fc, 0xe5fd,	//0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		0xe64a, 0xe64b, 0xe64c, 0xe64d, 0xe64e, 0xe64f, 0xe650, 0xe651,	//0x80
		0xe652, 0xe653, 0xe654, 0xe655, 0xe656, 0xe657, 0xe658, 0xe659,
		0xe65a, 0xe65b, 0xe65c, 0xe65d, 0xe65e, ' ', ' ', ' ',	//0x90
		0xe65f, 0xe660, 0xe661, 0xe662, 0xe663, 0xe664, 0xe665, 0xe666,
		0xe667, 0xe668, 0xe669, 0xe66a, 0xe66b, 0xe66c, 0xe66d, 0xe66e,	//0xa0
		0xe66f, 0xe670, 0xe671, 0xe672, 0xe673, 0xe674, 0xe675, 0xe676,
		' ', 0xe677, 0xe678, 0xe679, 0xe67a, 0xe67b, 0xe67c, 0xe67d,	//0xb0
		0xe67e, 0xe67f, 0xe680, 0xe681, 0xe682, 0xe683, 0xe684, ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};

	protected static final char[] cvtbl_u_30 = {
		' ', ' ', ' ', ' ', 0xe6a5, ' ', ' ', ' ',	//0x00
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', 0xe6a6, 0xe6a7,	//0x10
		0xe6a8, 0xe6a9, 0xe6aa, 0xe6ab, ' ', 0xe6ac, 0xe6ad, 0xe6ae,
		0xe6af, ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x20
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		0xe6b0, 0xe6b1, 0xe6b2, 0xe6b3, 0xe6b4, 0xe6b5, 0xe6b6, 0xe6b7,	//0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x80
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', 0xe6cf, ' ', ' ', ' ',	//0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xe6d8,	//0xf0
		0xe6d9, 0xe6da, 0xe6db, ' ', ' ', ' ', ' ', ' '
	};

	protected static final char[] cvtbl_u_32 = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x00
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		0xe6de, 0xe6df, 0xe6e0, 0xe6e1, 0xe6e2, 0xe6e3, 0xe6e4, 0xe6e5,	//0x20
		0xe6e6, 0xe6e7, 0xe6e8, 0xe6e9, 0xe6ea, 0xe6eb, 0xe6ec, 0xe6ed,
		0xe6ee, ' ', 0xe6ef, 0xe6f0, 0xe6f1, 0xe6f2, 0xe6f3, 0xe6f4,	//0x30
		0xe6f5, 0xe6f6, 0xe6f7, 0xe6f8, 0xe6f9, 0xe6fa, 0xe6fb, 0xe6fc,
		0xe6fd, 0xe6fe, 0xe741, 0xe742, ' ', ' ', ' ', ' ',	//0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		0xe743, 0xe744, 0xe745, 0xe746, 0xe747, 0xe748, 0xe749, 0xe74a,	//0x80
		0xe74b, 0xe74c, 0xe74d, 0xe74e, 0xe74f, 0xe750, 0xe751, 0xe752,
		0xe753, 0xe754, 0xe755, 0xe756, 0xe757, 0xe758, 0xe759, 0xe75a,	//0x90
		0xe75b, 0xe75c, 0xe75d, 0xe75e, 0xe75f, 0xe760, 0xe761, 0xe762,
		0xe763, 0xe764, 0xe765, 0xe766, 0xe767, 0xe768, 0xe769, 0xe76a, //0xa0
		0xe76b, 0xe76c, 0xe76d, 0xe76e, 0xe76f, 0xe770, 0xe771, 0xe772,
		0xe773, ' ', ' ', ' ', ' ', ' ', ' ', ' ',	//0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
		0xe774, 0xe775, 0xe776, 0xe777, 0xe778, 0xe779, 0xe77a, 0xe77b,	//0xc0
		0xe77c, 0xe77d, 0xe77e, 0xe77f, ' ', ' ', ' ', ' ',
		0xe780, 0xe781, 0xe782, 0xe783, 0xe784, 0xe785, 0xe786, 0xe787,	//0xd0
		0xe788, 0xe789, 0xe78a, 0xe78b, 0xe78c, 0xe78d, 0xe78e, 0xe78f,
		0xe790, 0xe791, 0xe792, 0xe793, 0xe794, 0xe795, 0xe796, 0xe797,	//0xe0
		0xe798, 0xe799, 0xe79a, 0xe79b, 0xe79c, 0xe79d, 0xe79e, 0xe79f,
		0xe7a0, 0xe7a1, 0xe7a2, 0xe7a3, 0xe7a4, 0xe7a5, 0xe7a6, 0xe7a7,	//0xf0
		0xe7a8, 0xe7a9, 0xe7aa, 0xe7ab, 0xe7ac, 0xe7ad, 0xe7ae, ' '
	};

	protected static final char[] cvtbl_u_33 = {
		0xe861, 0xe862, 0xe863, 0xe864, 0xe865, 0xe866, 0xe867, 0xe868,	//0x00
		0xe869, 0xe86a, 0xe86b, 0xe86c, 0xe86d, 0xe86e, 0xe86f, 0xe870,
		0xe871, 0xe872, 0xe873, 0xe874, 0xe875, 0xe876, 0xe877, 0xe878,	//0x10
		0xe879, 0xe87a, 0xe87b, 0xe87c, 0xe87d, 0xe87e, 0xe87f, 0xe880,
		0xe881, 0xe882, 0xe883, 0xe884, 0xe885, 0xe886, 0xe887, 0xe888,	//0x20
		0xe889, 0xe88a, 0xe88b, 0xe88c, 0xe88d, 0xe88e, 0xe88f, 0xe890,
		0xe891, 0xe892, 0xe893, 0xe894, 0xe895, 0xe896, 0xe897, 0xe898,	//0x30
		0xe899, 0xe89a, 0xe89b, 0xe89c, 0xe89d, 0xe89e, 0xe89f, 0xe8a0,
		0xe8a1, 0xe8a2, 0xe8a3, 0xe8a4, 0xe8a5, 0xe8a6, 0xe8a7, 0xe8a8,	//0x40
		0xe8a9, 0xe8aa, 0xe8ab, 0xe8ac, 0xe8ad, 0xe8ae, 0xe8af, 0xe8b0,
		0xe8b1, 0xe8b2, 0xe8b3, 0xe8b4, 0xe8b5, 0xe8b6, 0xe8b7, 0xe8b8,	//0x50
		0xe8b9, 0xe8ba, 0xe8bb, 0xe8bc, 0xe8bd, 0xe8be, 0xe8bf, 0xe8c0,
		0xe8c1, 0xe8c2, 0xe8c3, 0xe8c4, 0xe8c5, 0xe8c6, 0xe8c7, 0xe8c8,	//0x60
		0xe8c9, 0xe8ca, 0xe8cb, 0xe8cc, 0xe8cd, 0xe8ce, 0xe8cf, 0xe8d0,
		0xe8d1, 0xe8d2, 0xe8d3, 0xe8d4, 0xe8d5, 0xe8d6, 0xe8d7, 0xe8d8,	//0x70
		' ', ' ', ' ', 0xe8d8, 0xe8d9, 0xe8da, 0xe8db, 0xe8dc,
		0xe8dd, 0xe8de, 0xe8df, 0xe8e0, 0xe8e1, 0xe8e2, 0xe8e3, 0xe8e4,	//0x80
		0xe8e5, 0xe8e6, 0xe8e7, 0xe8e8, 0xe8e9, 0xe8ea, 0xe8eb, 0xe8ec,
		0xe8ed, 0xe8ee, 0xe8ef, 0xe8f0, 0xe8f1, 0xe8f2, 0xe8f3, 0xe8f4,	//0x90
		0xe8f5, 0xe8f6, 0xe8f7, 0xe8f8, 0xe8f9, 0xe8fa, 0xe8fb, 0xe8fc,
		0xe8fd, 0xe8fe, 0xe941, 0xe942, 0xe943, 0xe944, 0xe945, 0xe946,	//0xa0
		0xe947, 0xe948, 0xe949, 0xe94a, 0xe94b, 0xe94c, 0xe94d, 0xe94e,
		0xe94f, 0xe950, 0xe951, 0xe952, 0xe953, 0xe954, 0xe955, 0xe956,	//0xb0
		0xe957, 0xe958, 0xe959, 0xe95a, 0xe95b, 0xe95c, 0xe95d, 0xe95e,
		0xe95f, 0xe960, 0xe961, 0xe962, 0xe963, 0xe964, 0xe965, 0xe966,	//0xc0
		0xe967, 0xe968, 0xe969, 0xe96a, 0xe96b, 0xe96c, 0xe96d, 0xe96e,
		0xe96f, 0xe970, 0xe971, 0xe972, 0xe973, 0xe974, 0xe975, 0xe976,	//0xd0
		0xe977, 0xe978, 0xe979, 0xe97a, 0xe97b, 0xe97c, ' ', ' ',
		0xe97d, 0xe97e, 0xe97f, 0xe980, 0xe981, 0xe982, 0xe983, 0xe984,	//0xe0
		0xe985, 0xe986, 0xe987, 0xe988, 0xe989, 0xe98a, 0xe98b, 0xe98c,
		0xe98d, 0xe98e, 0xe98f, 0xe990, 0xe991, 0xe992, 0xe993, 0xe994,	//0xf0
		0xe995, 0xe996, 0xe997, 0xe998, 0xe999, 0xe99a, 0xe99b, ' '
	};

	protected static final char[] cvtbl_u_4e = {
		' ', ' ', 0xb841, ' ', 0xb842, 0xb843, ' ', ' ', //0x0
		' ', ' ', ' ', ' ', 0xb844, ' ', ' ', ' ', 
		' ', ' ', 0xb845, ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xb846, 
		' ', ' ', ' ', 0xb847, 0xb848, ' ', ' ', ' ', //0x20
		' ', ' ', ' ', 0xb849, ' ', ' ', 0xb84a, 0xb84b, 
		0xb84c, ' ', ' ', ' ', ' ', 0xb84d, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xb84e, 0xb84f, ' ', ' ', 0xb850, ' ', ' ', 0xb851, //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xb852, ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', 0xb853, ' ', 0xb854, ' ', ' ', ' ', 
		' ', ' ', ' ', 0xb855, ' ', ' ', ' ', ' ', //0x60
		0xb856, 0xb857, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xb858, 0xb859, ' ', ' ', //0x70
		' ', 0xb85a, ' ', ' ', ' ', ' ', ' ', 0xb85b, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', ' ', 0xb85c, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xb85d, 0xb85e, //0x90
		' ', ' ', ' ', ' ', ' ', 0xb85f, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xb860, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', 0xb861, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xb862, ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xb863, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', 0xb864, 0xb865, ' ', ' ', ' ', ' ', 
		0xb866, ' ', 0xb867, ' ', ' ', ' ', ' ', ' ', //0xe0
		0xb868, ' ', ' ', ' ', ' ', ' ', ' ', 0xb869, 
		' ', 0xb86a, ' ', 0xb86b, ' ', 0xb86c, ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', 0xb86d, 0xb86e, 0xb86f
	};
	protected static final char[] cvtbl_u_4f = {
		' ', ' ', 0xb870, ' ', ' ', ' ', ' ', ' ', //0x0
		0xb871, ' ', ' ', 0xb872, 0xb873, ' ', ' ', ' ', 
		' ', ' ', 0xb874, ' ', ' ', 0xb875, 0xb876, 0xb877, //0x10
		' ', 0xb878, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', ' ', 0xb879, ' ', 
		' ', 0xb87a, ' ', 0xb87b, ' ', 0xb87c, ' ', 0xb87d, //0x30
		' ', ' ', ' ', 0xb87e, ' ', ' ', 0xb87f, ' ', 
		0xb880, ' ', 0xb881, ' ', ' ', ' ', ' ', ' ', //0x40
		0xb882, 0xb883, ' ', 0xb884, 0xb885, ' ', ' ', ' ', 
		' ', ' ', 0xb886, ' ', 0xb887, ' ', ' ', ' ', //0x50
		0xb888, ' ', ' ', ' ', ' ', ' ', ' ', 0xb889, 
		0xb88a, ' ', ' ', 0xb88b, ' ', ' ', ' ', ' ', //0x60
		' ', ' ', 0xb88c, ' ', 0xb88d, ' ', 0xb88e, ' ', 
		' ', 0xb88f, ' ', ' ', ' ', ' ', ' ', 0xb890, //0x70
		0xb891, 0xb892, 0xb893, ' ', ' ', 0xb894, 0xb895, ' ', 
		' ', 0xb896, 0xb897, ' ', 0xb898, 0xb899, ' ', ' ', //0x80
		' ', 0xb89a, ' ', ' ', 0xb89b, ' ', 0xb89c, ' ', 
		0xb89d, ' ', ' ', 0xb89e, ' ', ' ', ' ', 0xb89f, //0x90
		' ', 0xb8a0, ' ', ' ', ' ', ' ', 0xb8a1, 0xb8a2, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xb8a3, ' ', ' ', ' ', ' ', 0xb8a4, //0xb0
		' ', 0xb8a5, ' ', 0xb8a6, 0xb8a7, 0xb8a8, 0xb8a9, ' ', 
		0xb8aa, 0xb8ab, ' ', ' ', ' ', 0xb8ac, 0xb8ad, ' ', //0xc0
		0xb8ae, ' ', ' ', 0xb8af, 0xb8b0, ' ', ' ', 0xb8b1, 
		' ', ' ', 0xb8b2, ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', 0xb8b3, ' ', ' ', ' ', 
		0xb8b4, ' ', 0xb8b5, ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xb8b6, ' ', 0xb8b7, ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', 0xb8b8, 0xb8b9, ' ', ' '
	};
	protected static final char[] cvtbl_u_50 = {
		0xb8ba, 0xb8bb, ' ', ' ', 0xb8bc, ' ', ' ', 0xb8bd, //0x0
		' ', ' ', 0xb8be, ' ', 0xb8bf, ' ', 0xb8c0, ' ', 
		0xb8c1, ' ', ' ', 0xb8c2, ' ', ' ', ' ', 0xb8c3, //0x10
		0xb8c4, ' ', ' ', 0xb8c5, 0xb8c6, 0xb8c7, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xb8c8, //0x20
		' ', ' ', ' ', ' ', ' ', ' ', 0xb8c9, ' ', 
		0xb8ca, ' ', 0xb8cb, 0xb8cc, ' ', 0xb8cd, ' ', ' ', //0x30
		' ', ' ', ' ', 0xb8ce, ' ', ' ', ' ', ' ', 
		' ', 0xb8cf, ' ', ' ', ' ', 0xb8d0, ' ', ' ', //0x40
		' ', ' ', 0xb8d1, ' ', 0xb8d2, ' ', 0xb8d3, ' ', 
		' ', 0xb8d4, 0xb8d5, 0xb8d6, ' ', ' ', ' ', 0xb8d7, //0x50
		' ', 0xb8d8, ' ', ' ', ' ', ' ', ' ', 0xb8d9, 
		0xb8da, ' ', 0xb8db, 0xb8dc, ' ', ' ', 0xb8dd, 0xb8de, //0x60
		' ', ' ', 0xb8df, ' ', ' ', 0xb8e0, ' ', ' ', 
		' ', 0xb8e1, ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xb8e2, ' ', 0xb8e3, 0xb8e4, ' ', 0xb8e5, ' ', //0x80
		' ', ' ', 0xb8e6, ' ', ' ', ' ', 0xb8e7, 0xb8e8, 
		0xb8e9, ' ', 0xb8ea, 0xb8eb, ' ', ' ', 0xb8ec, ' ', //0x90
		' ', ' ', ' ', 0xb8ed, 0xb8ee, ' ', 0xb8ef, 0xb8f0, 
		0xb8f1, 0xb8f2, 0xb8f3, ' ', ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', 0xb8f4, ' ', ' ', ' ', ' ', 0xb8f5, 
		0xb8f6, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', 0xb8f7, 0xb8f8, ' ', ' ', 0xb8f9, ' ', ' ', 
		0xb8fa, ' ', ' ', 0xb8fb, 0xb8fc, ' ', ' ', 0xb8fd, //0xc0
		' ', ' ', ' ', ' ', 0xb8fe, ' ', 0xb941, ' ', 
		0xb942, ' ', ' ', 0xb943, 0xb944, ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', 0xb945, 0xb946, ' ', 0xb947, 
		' ', ' ', 0xb948, ' ', 0xb949, ' ', 0xb94a, ' ', //0xe0
		0xb94b, 0xb94c, ' ', ' ', ' ', ' ', ' ', 0xb94d, 
		' ', 0xb94e, 0xb94f, ' ', ' ', ' ', 0xb950, ' ', //0xf0
		' ', ' ', 0xb951, ' ', ' ', ' ', 0xb952, ' '
	};
	protected static final char[] cvtbl_u_51 = {
		' ', ' ', ' ', 0xb953, ' ', ' ', 0xb954, 0xb955, //0x0
		0xb956, ' ', ' ', 0xb957, 0xb958, 0xb959, 0xb95a, ' ', 
		0xb95b, ' ', ' ', ' ', ' ', ' ', ' ', 0xb95c, //0x10
		' ', 0xb95d, ' ', 0xb95e, 0xb95f, 0xb960, 0xb961, ' ', 
		' ', ' ', ' ', 0xb962, ' ', ' ', ' ', 0xb963, //0x20
		0xb964, ' ', ' ', ' ', 0xb965, 0xb966, ' ', 0xb967, 
		' ', 0xb968, ' ', 0xb969, 0xb96a, 0xb96b, ' ', ' ', //0x30
		0xb96c, 0xb96d, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xb96e, ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xb96f, 
		' ', ' ', ' ', 0xb970, ' ', 0xb971, ' ', 0xb972, //0x50
		0xb973, ' ', ' ', ' ', ' ', ' ', ' ', 0xb974, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xb975, ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', 0xb976, ' ', 
		' ', ' ', ' ', 0xb977, 0xb978, ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xb979, ' ', ' ', 0xb97a, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		0xb97b, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xb97c, ' ', 0xb97d, ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', 0xb97e, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		0xb97f, ' ', 0xb980, ' ', 0xb981, ' ', ' ', 0xb982, 
		' ', ' ', 0xb983, ' ', ' ', ' ', ' ', ' ', //0xc0
		0xb984, ' ', ' ', ' ', ' ', ' ', ' ', 0xb985, 
		' ', 0xb986, 0xb987, 0xb988, ' ', 0xb989, ' ', ' ', //0xd0
		0xb98a, ' ', ' ', ' ', ' ', ' ', 0xb98b, ' ', 
		' ', ' ', 0xb98c, ' ', ' ', 0xb98d, ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', 0xb98e, ' ', 
		' ', ' ', 0xb98f, 0xb990, 0xb991, ' ', ' ', 0xb992, //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_52 = {
		' ', 0xb993, 0xb994, ' ', ' ', 0xb995, ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xb996, 0xb997, ' ', ' ', 0xb998, ' ', //0x10
		0xb999, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xb99a, ' ', ' ', ' ', ' ', ' ', //0x20
		0xb99b, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xb99c, 0xb99d, ' ', ' ', 0xb99e, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', 0xb99f, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xb9a0, ' ', ' ', //0x40
		' ', 0xb9a1, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xb9a2, ' ', 0xb9a3, //0x50
		0xb9a4, ' ', 0xb9a5, ' ', 0xb9a6, ' ', ' ', 0xb9a7, 
		0xb9a8, 0xb9a9, ' ', ' ', ' ', ' ', 0xb9aa, ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', 0xb9ab, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xb9ac, //0x70
		0xb9ad, 0xb9ae, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xb9af, ' ', 0xb9b0, ' ', ' ', 0xb9b1, ' ', ' ', //0x80
		' ', ' ', 0xb9b2, ' ', 0xb9b3, ' ', ' ', ' ', 
		' ', ' ', ' ', 0xb9b4, ' ', 0xb9b5, 0xb9b6, 0xb9b7, //0x90
		0xb9b8, ' ', 0xb9b9, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xb9ba, 0xb9bb, ' ', 0xb9bc, //0xa0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xb9bd, ' ', ' ', ' ', ' ', ' ', 0xb9be, 0xb9bf, //0xb0
		0xb9c0, ' ', 0xb9c1, 0xb9c2, ' ', 0xb9c3, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xb9c4, ' ', 0xb9c5, ' ', //0xc0
		0xb9c6, ' ', ' ', ' ', 0xb9c7, ' ', ' ', 0xb9c8, 
		' ', 0xb9c9, ' ', ' ', 0xb9ca, ' ', 0xb9cb, ' ', //0xd0
		' ', ' ', ' ', ' ', 0xb9cc, ' ', ' ', ' ', 
		' ', 0xb9cd, ' ', ' ', ' ', 0xb9ce, ' ', ' ', //0xe0
		0xb9cf, 0xb9d0, 0xb9d1, ' ', 0xb9d2, ' ', ' ', ' ', 
		0xb9d3, 0xb9d4, ' ', ' ', 0xb9d5, ' ', 0xb9d6, 0xb9d7, //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_53 = {
		' ', ' ', ' ', 0xb9d8, ' ', ' ', ' ', ' ', //0x0
		' ', ' ', 0xb9d9, 0xb9da, 0xb9db, ' ', ' ', ' ', 
		' ', 0xb9dc, ' ', 0xb9dd, ' ', ' ', ' ', ' ', //0x10
		0xb9de, ' ', ' ', 0xb9df, 0xb9e0, ' ', 0xb9e1, 0xb9e2, 
		' ', ' ', ' ', ' ', ' ', 0xb9e3, ' ', 0xb9e4, //0x20
		0xb9e5, 0xb9e6, ' ', 0xb9e7, 0xb9e8, 0xb9e9, ' ', ' ', 
		0xb9ea, ' ', 0xb9eb, ' ', ' ', 0xb9ec, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', 0xb9ed, 0xb9ee, 0xb9ef, ' ', 
		' ', ' ', 0xb9f0, ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', 0xb9f1, 0xb9f2, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', 0xb9f3, ' ', 0xb9f4, ' ', ' ', ' ', ' ', 
		' ', 0xb9f5, ' ', 0xb9f6, ' ', 0xb9f7, ' ', ' ', //0x60
		' ', ' ', ' ', ' ', 0xb9f8, 0xb9f9, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xb9fa, ' ', ' ', ' ', ' ', 0xb9fb, ' ', 
		' ', ' ', ' ', 0xb9fc, ' ', ' ', ' ', 0xb9fd, //0x80
		0xb9fe, ' ', ' ', ' ', ' ', ' ', 0xba41, ' ', 
		' ', ' ', ' ', ' ', 0xba42, ' ', ' ', ' ', //0x90
		' ', 0xba43, ' ', ' ', ' ', 0xba44, ' ', ' ', 
		' ', 0xba45, ' ', ' ', 0xba46, ' ', ' ', ' ', //0xa0
		' ', ' ', 0xba47, 0xba48, ' ', ' ', ' ', 0xba49, 
		' ', ' ', ' ', ' ', 0xba4a, 0xba4b, ' ', 0xba4c, //0xb0
		0xba4d, ' ', 0xba4e, ' ', ' ', 0xba4f, ' ', ' ', 
		0xba50, ' ', ' ', ' ', ' ', 0xba51, ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xba52, 
		' ', ' ', 0xba53, 0xba54, ' ', 0xba55, ' ', ' ', //0xd0
		' ', ' ', 0xba56, ' ', ' ', ' ', 0xba57, ' ', 
		0xba58, ' ', ' ', ' ', ' ', ' ', 0xba59, 0xba5a, //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xba5b, ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_54 = {
		' ', ' ', 0xba5c, ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xba5d, ' ', ' ', ' ', ' ', //0x10
		' ', ' ', 0xba5e, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xba5f, ' ', ' ', ' ', ' ', ' ', 0xba60, //0x20
		0xba61, ' ', 0xba62, ' ', ' ', ' ', ' ', 0xba63, 
		' ', 0xba64, ' ', ' ', 0xba65, 0xba66, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xba67, 0xba68, ' ', ' ', 0xba69, //0x40
		' ', ' ', ' ', ' ', ' ', 0xba6a, ' ', 0xba6b, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xba6c, ' ', 
		' ', ' ', 0xba6d, ' ', 0xba6e, ' ', 0xba6f, 0xba70, //0x60
		' ', 0xba71, ' ', 0xba72, ' ', 0xba73, 0xba74, ' ', 
		' ', ' ', ' ', ' ', 0xba75, ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xba76, 
		' ', 0xba77, ' ', 0xba78, ' ', 0xba79, ' ', ' ', //0x80
		0xba7a, 0xba7b, ' ', ' ', ' ', 0xba7c, ' ', ' ', 
		' ', 0xba7d, ' ', ' ', ' ', 0xba7e, 0xba7f, ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xba80, 
		' ', 0xba81, ' ', ' ', ' ', ' ', 0xba82, 0xba83, //0xa0
		' ', ' ', 0xba84, ' ', ' ', 0xba85, 0xba86, ' ', 
		' ', 0xba87, ' ', ' ', ' ', ' ', ' ', 0xba88, //0xb0
		' ', 0xba89, 0xba8a, 0xba8b, ' ', ' ', ' ', 0xba8c, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xba8d, ' ', //0xc0
		' ', ' ', 0xba8e, ' ', ' ', 0xba8f, 0xba90, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xba91, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', 0xba92, ' ', 0xba93, ' ', ' ', 0xba94, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xba95, ' ', //0xf0
		' ', ' ', ' ', ' ', 0xba96, ' ', 0xba97, ' '
	};
	protected static final char[] cvtbl_u_55 = {
		0xba98, 0xba99, ' ', ' ', ' ', 0xba9a, ' ', ' ', //0x0
		0xba9b, 0xba9c, ' ', ' ', 0xba9d, 0xba9e, 0xba9f, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbaa0, ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', 0xbaa1, 0xbaa2, ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbaa3, ' ', ' ', 0xbaa4, 0xbaa5, ' ', //0x30
		' ', ' ', ' ', 0xbaa6, 0xbaa7, 0xbaa8, ' ', ' ', 
		' ', 0xbaa9, ' ', ' ', ' ', ' ', ' ', 0xbaaa, //0x40
		' ', 0xbaab, 0xbaac, ' ', ' ', 0xbaad, ' ', ' ', 
		0xbaae, 0xbaaf, ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		0xbab0, ' ', 0xbab1, 0xbab2, ' ', ' ', 0xbab3, ' ', 
		0xbab4, 0xbab5, ' ', ' ', 0xbab6, ' ', 0xbab7, ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbab8, 
		' ', 0xbab9, 0xbaba, ' ', ' ', ' ', ' ', ' ', //0x80
		0xbabb, ' ', ' ', ' ', ' ', ' ', 0xbabc, 0xbabd, 
		' ', 0xbabe, 0xbabf, 0xbac0, 0xbac1, ' ', ' ', 0xbac2, //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xbac3, 0xbac4, ' ', ' ', ' ', //0xa0
		' ', ' ', ' ', ' ', ' ', 0xbac5, ' ', ' ', 
		' ', ' ', 0xbac6, ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbac7, 
		' ', 0xbac8, ' ', 0xbac9, ' ', ' ', 0xbaca, ' ', //0xc0
		' ', 0xbacb, ' ', 0xbacc, 0xbacd, ' ', 0xbace, ' ', 
		' ', 0xbacf, 0xbad0, 0xbad1, ' ', ' ', ' ', 0xbad2, //0xd0
		0xbad3, ' ', ' ', 0xbad4, ' ', ' ', 0xbad5, ' ', 
		' ', ' ', 0xbad6, ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', 0xbad7, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', 0xbad8, ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbad9
	};
	protected static final char[] cvtbl_u_56 = {
		' ', ' ', ' ', ' ', ' ', 0xbada, ' ', ' ', //0x0
		0xbadb, ' ', 0xbadc, ' ', ' ', 0xbadd, 0xbade, 0xbadf, 
		0xbae0, 0xbae1, 0xbae2, ' ', ' ', ' ', ' ', ' ', //0x10
		' ', 0xbae3, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		' ', ' ', ' ', ' ', 0xbae4, ' ', ' ', ' ', 
		0xbae5, ' ', ' ', 0xbae6, ' ', 0xbae7, ' ', 0xbae8, //0x30
		' ', 0xbae9, ' ', 0xbaea, 0xbaeb, 0xbaec, ' ', 0xbaed, 
		0xbaee, 0xbaef, ' ', 0xbaf0, 0xbaf1, ' ', 0xbaf2, ' ', //0x40
		' ', 0xbaf3, ' ', 0xbaf4, ' ', 0xbaf5, ' ', 0xbaf6, 
		' ', ' ', ' ', ' ', 0xbaf7, ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xbaf8, ' ', 
		0xbaf9, 0xbafa, 0xbafb, 0xbafc, ' ', ' ', 0xbafd, ' ', //0x60
		' ', 0xbafe, ' ', ' ', ' ', 0xbb41, ' ', 0xbb42, 
		' ', 0xbb43, 0xbb44, ' ', ' ', 0xbb45, ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xbb46, 0xbb47, ' ', ' ', //0x80
		0xbb48, ' ', ' ', 0xbb49, 0xbb4a, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbb4b, ' ', ' ', //0x90
		' ', 0xbb4c, 0xbb4d, ' ', ' ', 0xbb4e, 0xbb4f, 0xbb50, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xbb51, 0xbb52, //0xa0
		0xbb53, 0xbb54, ' ', 0xbb55, 0xbb56, 0xbb57, ' ', ' ', 
		' ', 0xbb58, ' ', 0xbb59, ' ', ' ', ' ', 0xbb5a, //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', 0xbb5b, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbb5c, ' ', ' ', //0xc0
		' ', 0xbb5d, 0xbb5e, 0xbb5f, 0xbb60, 0xbb61, ' ', 0xbb62, 
		0xbb63, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', 0xbb64, ' ', ' ', 0xbb65, 0xbb66, ' ', 0xbb67, 
		' ', 0xbb68, ' ', ' ', 0xbb69, 0xbb6a, 0xbb6b, 0xbb6c, //0xe0
		0xbb6d, ' ', ' ', 0xbb6e, ' ', 0xbb6f, ' ', ' ', 
		' ', 0xbb70, ' ', ' ', ' ', ' ', 0xbb71, 0xbb72, //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_57 = {
		' ', 0xbb73, 0xbb74, ' ', ' ', ' ', ' ', 0xbb75, //0x0
		' ', ' ', 0xbb76, ' ', 0xbb77, ' ', ' ', ' ', 
		' ', 0xbb78, ' ', ' ', ' ', 0xbb79, ' ', ' ', //0x10
		' ', ' ', 0xbb7a, 0xbb7b, ' ', 0xbb7c, ' ', ' ', 
		0xbb7d, ' ', 0xbb7e, 0xbb7f, 0xbb80, 0xbb81, ' ', ' ', //0x20
		' ', 0xbb82, 0xbb83, ' ', 0xbb84, ' ', 0xbb85, 0xbb86, 
		' ', ' ', ' ', 0xbb87, 0xbb88, ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', 0xbb89, 0xbb8a, 0xbb8b, 
		' ', ' ', ' ', ' ', ' ', 0xbb8c, 0xbb8d, ' ', //0x40
		' ', ' ', ' ', ' ', 0xbb8e, 0xbb8f, ' ', ' ', 
		' ', ' ', 0xbb90, ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbb91, ' ', ' ', ' ', ' ', 0xbb92, //0x60
		0xbb93, ' ', ' ', 0xbb94, ' ', 0xbb95, 0xbb96, 0xbb97, 
		0xbb98, 0xbb99, ' ', 0xbb9a, 0xbb9b, 0xbb9c, ' ', 0xbb9d, //0x70
		' ', 0xbb9e, 0xbb9f, 0xbba0, 0xbba1, ' ', 0xbba2, ' ', 
		' ', 0xbba3, ' ', 0xbba4, ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', ' ', 0xbba5, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xbba6, 0xbba7, ' ', 0xbba8, //0x90
		' ', 0xbba9, 0xbbaa, ' ', 0xbbab, 0xbbac, 0xbbad, 0xbbae, 
		' ', 0xbbaf, ' ', ' ', ' ', ' ', ' ', 0xbbb0, //0xa0
		0xbbb1, 0xbbb2, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		0xbbb3, ' ', ' ', ' ', ' ', 0xbbb4, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', 0xbbb5, ' ', ' ', 0xbbb6, 
		' ', ' ', ' ', ' ', ' ', 0xbbb7, ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', 0xbbb8, 0xbbb9, ' ', 
		' ', 0xbbba, ' ', ' ', 0xbbbb, ' ', 0xbbbc, 0xbbbd, //0xe0
		' ', 0xbbbe, ' ', ' ', ' ', 0xbbbf, ' ', ' ', 
		0xbbc0, ' ', ' ', ' ', ' ', 0xbbc1, 0xbbc2, ' ', //0xf0
		0xbbc3, ' ', ' ', ' ', ' ', 0xbbc4, 0xbbc5, 0xbbc6
	};
	protected static final char[] cvtbl_u_58 = {
		' ', ' ', ' ', 0xbbc7, 0xbbc8, ' ', ' ', ' ', //0x0
		0xbbc9, 0xbbca, ' ', ' ', 0xbbcb, 0xbbcc, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', 0xbbcd, ' ', ' ', 0xbbce, 0xbbcf, 
		0xbbd0, ' ', ' ', ' ', ' ', ' ', 0xbbd1, 0xbbd2, //0x20
		' ', ' ', ' ', ' ', ' ', 0xbbd3, ' ', ' ', 
		' ', ' ', 0xbbd4, ' ', ' ', ' ', ' ', ' ', //0x30
		' ', 0xbbd5, ' ', ' ', ' ', ' ', ' ', 0xbbd6, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', 0xbbd7, ' ', ' ', 0xbbd8, 0xbbd9, ' ', 0xbbda, 
		0xbbdb, ' ', ' ', ' ', ' ', 0xbbdc, ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbbdd, 
		' ', 0xbbde, ' ', ' ', 0xbbdf, ' ', ' ', 0xbbe0, //0x60
		0xbbe1, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		0xbbe2, ' ', ' ', ' ', 0xbbe3, ' ', ' ', 0xbbe4, 
		0xbbe5, 0xbbe6, ' ', ' ', ' ', ' ', ' ', 0xbbe7, //0x80
		0xbbe8, 0xbbe9, 0xbbea, ' ', 0xbbeb, 0xbbec, ' ', 0xbbed, 
		0xbbee, ' ', ' ', ' ', 0xbbef, ' ', 0xbbf0, ' ', //0x90
		' ', ' ', ' ', ' ', ' ', 0xbbf1, ' ', ' ', 
		0xbbf2, 0xbbf3, 0xbbf4, ' ', ' ', ' ', 0xbbf5, ' ', //0xa0
		' ', 0xbbf6, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbbf7, ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', 0xbbf8, ' ', ' ', ' ', 
		' ', ' ', 0xbbf9, ' ', 0xbbfa, ' ', ' ', ' ', //0xc0
		0xbbfb, ' ', ' ', ' ', ' ', 0xbbfc, 0xbbfd, ' ', 
		0xbbfe, ' ', 0xbc41, ' ', 0xbc42, ' ', 0xbc43, ' ', //0xd0
		' ', ' ', 0xbc44, ' ', ' ', 0xbc45, ' ', ' ', 
		' ', 0xbc46, 0xbc47, ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', 0xbc48, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xbc49, ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_59 = {
		' ', ' ', ' ', ' ', ' ', 0xbc4a, 0xbc4b, ' ', //0x0
		' ', ' ', ' ', ' ', 0xbc4c, ' ', ' ', ' ', 
		' ', ' ', 0xbc4d, 0xbc4e, 0xbc4f, ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', 0xbc50, ' ', ' ', 
		' ', 0xbc51, ' ', 0xbc52, 0xbc53, ' ', ' ', ' ', //0x20
		0xbc54, ' ', ' ', ' ', ' ', ' ', ' ', 0xbc55, 
		0xbc56, ' ', ' ', 0xbc57, ' ', 0xbc58, 0xbc59, ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbc5a, 
		' ', ' ', ' ', 0xbc5b, ' ', ' ', 0xbc5c, ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbc5d, ' ', ' ', ' ', ' ', ' ', //0x50
		' ', 0xbc5e, ' ', ' ', ' ', ' ', 0xbc5f, 0xbc60, 
		' ', 0xbc61, ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		' ', ' ', ' ', 0xbc62, ' ', 0xbc63, ' ', 0xbc64, 
		' ', ' ', 0xbc65, ' ', ' ', 0xbc66, 0xbc67, ' ', //0x70
		' ', 0xbc68, ' ', 0xbc69, 0xbc6a, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xbc6b, 0xbc6c, ' ', 0xbc6d, ' ', 
		' ', ' ', 0xbc6e, ' ', ' ', 0xbc6f, ' ', 0xbc70, //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbc71, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbc72, //0xa0
		' ', ' ', ' ', ' ', ' ', 0xbc73, 0xbc74, 0xbc75, 
		0xbc76, ' ', ' ', 0xbc77, ' ', ' ', ' ', 0xbc78, //0xb0
		' ', ' ', ' ', ' ', 0xbc79, ' ', ' ', ' ', 
		' ', 0xbc7a, ' ', 0xbc7b, 0xbc7c, ' ', ' ', ' ', //0xc0
		0xbc7d, ' ', 0xbc7e, ' ', ' ', 0xbc7f, ' ', ' ', 
		' ', ' ', 0xbc80, ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', 0xbc81, 0xbc82, 0xbc83, 
		' ', ' ', ' ', 0xbc84, 0xbc85, ' ', ' ', 0xbc86, //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', 0xbc87, 0xbc88, 
		' ', 0xbc89, 0xbc8a, ' ', 0xbc8b, ' ', ' ', 0xbc8c, //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_5a = {
		0xbc8d, ' ', ' ', ' ', 0xbc8e, ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', 0xbc8f, 0xbc90, 0xbc91, ' ', 
		' ', ' ', 0xbc92, 0xbc93, ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', 0xbc94, ' ', 
		' ', ' ', ' ', 0xbc95, 0xbc96, ' ', ' ', 0xbc97, //0x20
		0xbc98, ' ', 0xbc99, ' ', ' ', 0xbc9a, ' ', ' ', 
		0xbc9b, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xbc9c, 0xbc9d, ' ', 0xbc9e, //0x40
		0xbc9f, ' ', ' ', ' ', 0xbca0, ' ', ' ', ' ', 
		0xbca1, ' ', ' ', ' ', ' ', 0xbca2, ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xbca3, ' ', 
		' ', ' ', ' ', 0xbca4, ' ', 0xbca5, ' ', 0xbca6, //0x60
		' ', ' ', ' ', ' ', ' ', 0xbca7, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbca8, //0x70
		' ', ' ', 0xbca9, 0xbcaa, ' ', ' ', 0xbcab, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xbcac, ' ', ' ', ' ', ' ', 
		0xbcad, ' ', ' ', 0xbcae, ' ', ' ', 0xbcaf, ' ', //0x90
		' ', 0xbcb0, ' ', ' ', 0xbcb1, ' ', 0xbcb2, 0xbcb3, 
		0xbcb4, ' ', 0xbcb5, ' ', ' ', ' ', ' ', 0xbcb6, //0xa0
		' ', ' ', ' ', ' ', 0xbcb7, ' ', ' ', ' ', 
		' ', 0xbcb8, 0xbcb9, 0xbcba, ' ', 0xbcbb, ' ', ' ', //0xb0
		0xbcbc, ' ', 0xbcbd, 0xbcbe, ' ', ' ', ' ', 0xbcbf, 
		' ', ' ', ' ', ' ', 0xbcc0, ' ', 0xbcc1, ' ', //0xc0
		0xbcc2, ' ', ' ', ' ', ' ', ' ', ' ', 0xbcc3, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		' ', ' ', 0xbcc4, ' ', 0xbcc5, ' ', ' ', ' ', 
		0xbcc6, ' ', ' ', ' ', ' ', 0xbcc7, ' ', ' ', //0xe0
		' ', ' ', 0xbcc8, ' ', ' ', ' ', 0xbcc9, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbcca, 0xbccb, ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', 0xbccc, ' ', ' '
	};
	protected static final char[] cvtbl_u_5b = {
		0xbccd, 0xbcce, ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		0xbccf, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbcd0, //0x10
		' ', 0xbcd1, ' ', 0xbcd2, ' ', 0xbcd3, ' ', ' ', 
		' ', 0xbcd4, ' ', ' ', ' ', 0xbcd5, ' ', ' ', //0x20
		' ', ' ', ' ', ' ', ' ', 0xbcd6, ' ', ' ', 
		' ', ' ', ' ', ' ', 0xbcd7, ' ', ' ', ' ', //0x30
		0xbcd8, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbcd9, ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', 0xbcda, 0xbcdb, ' ', ' ', ' ', 
		' ', ' ', 0xbcdc, ' ', ' ', ' ', ' ', ' ', //0x50
		' ', ' ', ' ', ' ', ' ', ' ', 0xbcdd, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		0xbcde, ' ', ' ', ' ', ' ', ' ', 0xbcdf, 0xbce0, 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', 0xbce1, 0xbce2, 0xbce3, 0xbce4, 
		' ', 0xbce5, ' ', ' ', 0xbce6, ' ', 0xbce7, ' ', //0x80
		' ', ' ', 0xbce8, ' ', ' ', ' ', 0xbce9, ' ', 
		0xbcea, 0xbceb, ' ', 0xbcec, 0xbced, ' ', 0xbcee, ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xa0
		0xbcef, 0xbcf0, ' ', ' ', 0xbcf1, 0xbcf2, ' ', 0xbcf3, 
		' ', 0xbcf4, 0xbcf5, ' ', ' ', ' ', ' ', 0xbcf6, //0xb0
		' ', ' ', 0xbcf7, ' ', 0xbcf8, ' ', ' ', ' ', 
		' ', 0xbcf9, ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', ' ', ' ', ' ', ' ', 0xbcfa, ' ', 0xbcfb, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xbcfc, 0xbcfd, //0xd0
		' ', 0xbcfe, 0xbd41, ' ', ' ', ' ', ' ', ' ', 
		0xbd42, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbd43, 
		' ', 0xbd44, ' ', ' ', 0xbd45, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', 0xbd46, ' ', ' '
	};
	protected static final char[] cvtbl_u_5c = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x0
		' ', ' ', ' ', ' ', 0xbd47, ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbd48, //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbd49, 
		' ', ' ', ' ', 0xbd4a, ' ', ' ', 0xbd4b, ' ', //0x20
		' ', 0xbd4c, ' ', 0xbd4d, 0xbd4e, ' ', 0xbd4f, ' ', 
		0xbd50, ' ', 0xbd51, ' ', ' ', 0xbd52, 0xbd53, ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x50
		' ', 0xbd54, 0xbd55, ' ', 0xbd56, ' ', ' ', ' ', 
		' ', ' ', 0xbd57, 0xbd58, ' ', ' ', ' ', 0xbd59, //0x60
		0xbd5a, 0xbd5b, ' ', ' ', ' ', 0xbd5c, ' ', ' ', 
		0xbd5d, ' ', ' ', ' ', 0xbd5e, 0xbd5f, ' ', ' ', //0x70
		' ', ' ', 0xbd60, 0xbd61, 0xbd62, 0xbd63, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbd64, //0x80
		0xbd65, ' ', 0xbd66, ' ', ' ', ' ', ' ', 0xbd67, 
		' ', ' ', 0xbd68, ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', 0xbd69, ' ', 0xbd6a, 
		0xbd6b, ' ', 0xbd6c, 0xbd6d, ' ', ' ', ' ', ' ', //0xa0
		' ', ' ', 0xbd6e, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbd6f, ' ', 0xbd70, 0xbd71, ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xc0
		' ', 0xbd72, ' ', 0xbd73, ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbd74, ' ', ' ', ' ', ' ', 0xbd75, //0xd0
		' ', ' ', ' ', ' ', ' ', 0xbd76, ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xe0
		' ', ' ', ' ', ' ', ' ', ' ', 0xbd77, ' ', 
		' ', 0xbd78, 0xbd79, ' ', 0xbd7a, ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_5d = {
		' ', 0xbd7b, ' ', ' ', ' ', ' ', 0xbd7c, ' ', //0x0
		' ', ' ', ' ', ' ', ' ', 0xbd7d, ' ', ' ', 
		' ', ' ', 0xbd7e, ' ', ' ', ' ', ' ', ' ', //0x10
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xbd7f, 0xbd80, ' ', 0xbd81, ' ', //0x20
		' ', ' ', ' ', 0xbd82, ' ', ' ', ' ', ' ', 
		' ', 0xbd83, ' ', ' ', 0xbd84, ' ', ' ', ' ', //0x30
		' ', 0xbd85, ' ', ' ', ' ', 0xbd86, ' ', 0xbd87, 
		' ', ' ', ' ', 0xbd88, ' ', ' ', 0xbd89, ' ', //0x40
		0xbd8a, ' ', 0xbd8b, ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbd8c, ' ', ' ', ' ', 0xbd8d, ' ', ' ', //0x50
		' ', 0xbd8e, ' ', ' ', ' ', ' ', ' ', 0xbd8f, 
		0xbd90, 0xbd91, 0xbd92, ' ', 0xbd93, ' ', ' ', ' ', //0x60
		' ', ' ', 0xbd94, ' ', ' ', ' ', ' ', ' ', 
		0xbd95, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', 0xbd96, 0xbd97, ' ', ' ', ' ', 0xbd98, 0xbd99, 
		' ', 0xbd9a, ' ', 0xbd9b, ' ', ' ', ' ', ' ', //0x80
		0xbd9c, ' ', 0xbd9d, ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbd9e, 0xbd9f, 0xbda0, 0xbda1, ' ', ' ', //0x90
		' ', 0xbda2, ' ', 0xbda3, ' ', ' ', ' ', 0xbda4, 
		0xbda5, ' ', ' ', ' ', ' ', ' ', ' ', 0xbda6, //0xa0
		' ', ' ', ' ', 0xbda7, ' ', ' ', ' ', ' ', 
		0xbda8, ' ', 0xbda9, ' ', 0xbdaa, ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', 0xbdab, ' ', ' ', ' ', 0xbdac, //0xc0
		' ', ' ', ' ', 0xbdad, ' ', ' ', 0xbdae, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xd0
		0xbdaf, 0xbdb0, ' ', ' ', ' ', ' ', ' ', ' ', 
		0xbdb1, ' ', ' ', ' ', 0xbdb2, ' ', ' ', ' ', //0xe0
		' ', 0xbdb3, ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		0xbdb4, 0xbdb5, ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_5e = {
		0xbdb6, ' ', ' ', ' ', ' ', ' ', ' ', 0xbdb7, //0x0
		' ', ' ', ' ', ' ', ' ', 0xbdb8, ' ', ' ', 
		' ', ' ', 0xbdb9, ' ', 0xbdba, 0xbdbb, ' ', ' ', //0x10
		0xbdbc, ' ', ' ', ' ', ' ', ' ', ' ', 0xbdbd, 
		0xbdbe, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x20
		0xbdbf, ' ', ' ', ' ', ' ', ' ', 0xbdc0, ' ', 
		' ', ' ', 0xbdc1, ' ', ' ', 0xbdc2, ' ', ' ', //0x30
		' ', ' ', ' ', ' ', ' ', ' ', 0xbdc3, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x40
		' ', 0xbdc4, ' ', 0xbdc5, ' ', ' ', ' ', ' ', 
		0xbdc6, 0xbdc7, ' ', ' ', ' ', ' ', 0xbdc8, ' ', //0x50
		0xbdc9, ' ', ' ', 0xbdca, 0xbdcb, ' ', 0xbdcc, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x60
		0xbdcd, ' ', 0xbdce, 0xbdcf, 0xbdd0, 0xbdd1, 0xbdd2, ' ', 
		0xbdd3, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x70
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		0xbdd4, ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', ' ', ' ', 0xbdd5, ' ', ' ', 0xbdd6, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x90
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', 0xbdd7, ' ', 0xbdd8, 0xbdd9, ' ', ' ', //0xa0
		0xbdda, ' ', 0xbddb, ' ', 0xbddc, ' ', ' ', ' ', 
		' ', 0xbddd, ' ', 0xbdde, ' ', ' ', ' ', ' ', //0xb0
		' ', ' ', ' ', ' ', ' ', 0xbddf, 0xbde0, 0xbde1, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xbde2, ' ', //0xc0
		' ', ' ', ' ', 0xbde3, 0xbde4, ' ', 0xbde5, ' ', 
		' ', 0xbde6, 0xbde7, ' ', 0xbde8, 0xbde9, ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', 0xbdea, ' ', 0xbdeb, ' ', 
		' ', ' ', ' ', ' ', ' ', 0xbdec, ' ', ' ', //0xe0
		' ', ' ', ' ', 0xbded, ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0xf0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
	};
	protected static final char[] cvtbl_u_5f = {
		' ', ' ', 0xbdee, ' ', ' ', ' ', 0xbdef, 0xbdf0, //0x0
		0xbdf1, ' ', ' ', ' ', ' ', ' ', 0xbdf2, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x10
		' ', 0xbdf3, ' ', ' ', 0xbdf4, 0xbdf5, ' ', ' ', 
		' ', ' ', 0xbdf6, 0xbdf7, 0xbdf8, ' ', ' ', ' ', //0x20
		0xbdf9, ' ', ' ', 0xbdfa, 0xbdfb, ' ', 0xbdfc, ' ', 
		0xbdfd, ' ', ' ', ' ', ' ', ' ', 0xbdfe, ' ', //0x30
		' ', ' ', ' ', 0xbe41, ' ', 0xbe42, ' ', 0xbe43, 
		0xbe44, ' ', ' ', ' ', 0xbe45, ' ', ' ', 0xbe46, //0x40
		' ', ' ', ' ', ' ', ' ', 0xbe47, ' ', ' ', 
		0xbe48, ' ', ' ', ' ', 0xbe49, ' ', ' ', ' ', //0x50
		0xbe4a, ' ', ' ', 0xbe4b, ' ', ' ', ' ', ' ', 
		0xbe4c, ' ', ' ', 0xbe4d, 0xbe4e, ' ', ' ', ' ', //0x60
		' ', ' ', ' ', ' ', ' ', ' ', ' ', 0xbe4f, 
		' ', ' ', 0xbe50, ' ', 0xbe51, 0xbe52, ' ', ' ', //0x70
		0xbe53, ' ', 0xbe54, ' ', ' ', 0xbe55, 0xbe56, ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', //0x80
		' ', 0xbe57, ' ', ' ', ' ', 0xbe58, ' ', 0xbe59, 
		' ', ' ', ' ', ' ', ' ', ' ', 0xbe5a, ' ', //0x90
		' ', ' ', ' ', ' ', 0xbe5b, 0xbe5c, ' ', ' ', 
		' ', ' ', 0xbe5d, ' ', 0xbe5e, ' ', ' ', 0xbe5f, //0xa0
		' ', ' ', ' ', 0xbe60, 0xbe61, ' ', ' ', 0xbe62, 
		0xbe63, 0xbe64, ' ', ' ', ' ', ' ', ' ', ' ', //0xb0
		0xbe65, ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', 0xbe66, ' ', ' ', 0xbe67, //0xc0
		0xbe68, 0xbe69, ' ', 0xbe6a, ' ', ' ', ' ', ' ', 
		0xbe6b, 0xbe6c, 0xbe6d, 0xbe6e, 0xbe6f, ' ', ' ', ' ', //0xd0
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', 0xbe70, 0xbe71, ' ', ' ', ' ', ' ', ' ', //0xe0
		0xbe72, 0xbe73, 0xbe74, ' ', 0xbe75, 0xbe76, 0xbe77, 0xbe78, 
		' ', ' ', 0xbe79, 0xbe7a, ' ', ' ', 0xbe7b, ' ', //0xf0
		' ', ' ', 0xbe7c, ' ', 0xbe7d, ' ', ' ', ' '
	};

}