/**
 * Title: UniCodePage
 * Copyright:   Copyright (c) 2001, 2002, 2003
 * Company:
 * @author  Kenneth J. Pouncey
 *          rewritten by LDC, WVL, Luc
 * @version 0.4
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j.encoding;

public class UniCodePage {
	protected char[][] cvtbl_e_1 = {
		null, null, null, null,	// 0xb0
		null, null, null, null,
		UniCodeE.cvtbl_e_b8, UniCodeE.cvtbl_e_b9, UniCodeE.cvtbl_e_ba, UniCodeE.cvtbl_e_bb,
		UniCodeE.cvtbl_e_bc, UniCodeE.cvtbl_e_bd, UniCodeE.cvtbl_e_be, UniCodeE.cvtbl_e_bf,
		UniCodeE.cvtbl_e_c0, UniCodeE.cvtbl_e_c1, UniCodeE.cvtbl_e_c2, UniCodeE.cvtbl_e_c3,	// 0xc0
		UniCodeE.cvtbl_e_c4, UniCodeE.cvtbl_e_c5, UniCodeE.cvtbl_e_c6, UniCodeE.cvtbl_e_c7,
		UniCodeE.cvtbl_e_c8, UniCodeE.cvtbl_e_c9, UniCodeE.cvtbl_e_ca, UniCodeE.cvtbl_e_cb,
		UniCodeE.cvtbl_e_cc, UniCodeE.cvtbl_e_cd, UniCodeE.cvtbl_e_ce, UniCodeE.cvtbl_e_cf,
		UniCodeE.cvtbl_e_d0, UniCodeE.cvtbl_e_d1, UniCodeE.cvtbl_e_d2, UniCodeE.cvtbl_e_d3,	// 0xd0
		UniCodeE.cvtbl_e_d4, UniCodeE.cvtbl_e_d5, null, null,
		null, null, null, null,
		null, UniCodeE.cvtbl_e_dd, UniCodeE.cvtbl_e_de, UniCodeE.cvtbl_e_df,
		UniCodeE.cvtbl_e_e0, null, UniCodeE.cvtbl_e_e2, UniCodeE.cvtbl_e_e3,	// 0xe0
		UniCodeE.cvtbl_e_e4, UniCodeE.cvtbl_e_e5, UniCodeE.cvtbl_e_e6, UniCodeE.cvtbl_e_e7,
		UniCodeE.cvtbl_e_e8, UniCodeE.cvtbl_e_e9, null, null,
		null, null, null, null 
	};
	protected char[][] cvtbl_u_1 = {
		null, null, null, null, null, null, null, null,	// 0x00
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0x10
		null, null, null, null, null, null, null, null,
		UniCodeU20.cvtbl_u_20, UniCodeU20.cvtbl_u_21, UniCodeU20.cvtbl_u_22, UniCodeU20.cvtbl_u_23,	// 0x20
		UniCodeU20.cvtbl_u_24, UniCodeU20.cvtbl_u_25, UniCodeU20.cvtbl_u_26, UniCodeU20.cvtbl_u_27,
		null, null, null, null, null, null, null, null,
		UniCodeU20.cvtbl_u_30, null, UniCodeU20.cvtbl_u_32, UniCodeU20.cvtbl_u_33,	// 0x30
		null, null, null, null,
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0x40
		null, null, null, null, null, null, UniCodeU20.cvtbl_u_4e, UniCodeU20.cvtbl_u_4f,
		UniCodeU20.cvtbl_u_50, UniCodeU20.cvtbl_u_51, UniCodeU20.cvtbl_u_52, UniCodeU20.cvtbl_u_53,	// 0x50
		UniCodeU20.cvtbl_u_54, UniCodeU20.cvtbl_u_55, UniCodeU20.cvtbl_u_56, UniCodeU20.cvtbl_u_57,
		UniCodeU20.cvtbl_u_58, UniCodeU20.cvtbl_u_59, UniCodeU20.cvtbl_u_5a, UniCodeU20.cvtbl_u_5b,
		UniCodeU20.cvtbl_u_5c, UniCodeU20.cvtbl_u_5d, UniCodeU20.cvtbl_u_5e, UniCodeU20.cvtbl_u_5f,
		UniCodeU60.cvtbl_u_60, UniCodeU60.cvtbl_u_61, UniCodeU60.cvtbl_u_62, UniCodeU60.cvtbl_u_63,	// 0x60
		UniCodeU60.cvtbl_u_64, UniCodeU60.cvtbl_u_65, UniCodeU60.cvtbl_u_66, UniCodeU60.cvtbl_u_67,
		UniCodeU60.cvtbl_u_68, UniCodeU60.cvtbl_u_69, UniCodeU60.cvtbl_u_6a, UniCodeU60.cvtbl_u_6b,
		UniCodeU60.cvtbl_u_6c, UniCodeU60.cvtbl_u_6d, UniCodeU60.cvtbl_u_6e, UniCodeU60.cvtbl_u_6f,
		UniCodeU60.cvtbl_u_70, UniCodeU60.cvtbl_u_71, UniCodeU60.cvtbl_u_72, UniCodeU60.cvtbl_u_73,	// 0x70
		UniCodeU60.cvtbl_u_74, UniCodeU60.cvtbl_u_75, UniCodeU60.cvtbl_u_76, UniCodeU60.cvtbl_u_77,
		UniCodeU60.cvtbl_u_78, UniCodeU60.cvtbl_u_79, UniCodeU60.cvtbl_u_7a, UniCodeU60.cvtbl_u_7b,
		UniCodeU60.cvtbl_u_7c, UniCodeU60.cvtbl_u_7d, UniCodeU60.cvtbl_u_7e, UniCodeU60.cvtbl_u_7f,
		UniCodeU80.cvtbl_u_80, UniCodeU80.cvtbl_u_81, UniCodeU80.cvtbl_u_82, UniCodeU80.cvtbl_u_83,	// 0x80
		UniCodeU80.cvtbl_u_84, UniCodeU80.cvtbl_u_85, UniCodeU80.cvtbl_u_86, UniCodeU80.cvtbl_u_87,
		UniCodeU80.cvtbl_u_88, UniCodeU80.cvtbl_u_89, UniCodeU80.cvtbl_u_8a, UniCodeU80.cvtbl_u_8b,
		UniCodeU80.cvtbl_u_8c, UniCodeU80.cvtbl_u_8d, UniCodeU80.cvtbl_u_8e, UniCodeU80.cvtbl_u_8f,
		UniCodeU80.cvtbl_u_90, UniCodeU80.cvtbl_u_91, UniCodeU80.cvtbl_u_92, UniCodeU80.cvtbl_u_93,	// 0x90
		UniCodeU80.cvtbl_u_94, UniCodeU80.cvtbl_u_95, UniCodeU80.cvtbl_u_96, UniCodeU80.cvtbl_u_97,
		UniCodeU80.cvtbl_u_98, UniCodeU80.cvtbl_u_99, UniCodeU80.cvtbl_u_9a, UniCodeU80.cvtbl_u_9b,
		UniCodeU80.cvtbl_u_9c, UniCodeU80.cvtbl_u_9d, UniCodeU80.cvtbl_u_9e, UniCodeU80.cvtbl_u_9f,
		null, null, null, null, null, null, null, null,	// 0xa0
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0xb0
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0xc0
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0xd0
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0xe0
		null, null, null, null, null, null, null, null,
		null, null, null, null, null, null, null, null,	// 0xf0
		null, null, null, null, null, null, null, UniCodeU80.cvtbl_u_ff
	};
	public UniCodePage() {
		super();
	}

	public char ebcdic2unik(int index1, int index2) {
		int first= index1 & 0xff;
		if (first < 0xb0 || first > 0xef) return (' ');
		char [] wt= cvtbl_e_1[first - 0xb0];
		if (wt == null) return (' ');
		int second= index2 & 0xff;
		if (second < 0x40) return (' ');
		return (wt[second - 0x40]);
	}

	public byte[] uni2ebcdic(char index) {
		int first= (index >> 8) & 0xff;
		char [] wt= cvtbl_u_1[first];
		if (wt == null) return (null);
		int second= index & 0xff;
		char ret= wt[second];
		if (ret == ' ') return (null);
		return (new byte [] {(byte)(ret >> 8), (byte)ret});
	}

}