/**
 * Title: tn5250J
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.4
 * 
 * Modified by pei DEC/2004
 * 
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Added NOV/2005 By pei
 */
package je.tn5250j;

public class SingleSelectionField extends ScreenField {
	protected int selectpos= 0;
	boolean [] available;
	protected int flag1, flag2, flag3;
	// add pei 080208
	protected int type;
	protected int [] menu_pos;
	protected int [] menu_len;
	protected int [][] minor_flag;

	// chg pei 080208
//	protected SingleSelectionField(Screen5250 s) {
	protected SingleSelectionField(Screen5250 s, int t) {
		super (s);
		type= t;
	}

	protected ScreenField setField(
		int attr,
		int row,
		int col,
		int len,
		int rs,
		int ffw1,
		int ffw2,
		int fcw1,
		int fcw2) {
		super.setField(attr, row, col, len, rs, ffw1, ffw2, fcw1, fcw2);
		available= new boolean[rs];
		// add pei 080208
		minor_flag= new int[3][];
		minor_flag[0]= new int[rs];
		minor_flag[1]= new int[rs];
		minor_flag[2]= new int[rs];
		return (super.setField(attr, row, col, len, rs, ffw1, ffw2, fcw1, fcw2));
	}
	
	public int getType() {
		// chg pei 080208
//		return (ScreenField.F_SINGLESELECTION);
		return (type);
	}
	
	public boolean isCField() {
		return (true);
	}

	public void setSelectPos(int p) {
		selectpos= p;
		// add pei 080208
		if (p > 0) mdt= true;
	}	

	public void setAvailable(int p, boolean f) {
		available[p - 1]= f;
	}	

	public int getSelectPos() {
		return (selectpos);
	}

	public boolean isAvalilable(int pos) {
		return (available[pos - 1]);
	}

	public boolean withinField(int pos) {
		// add pei 080208
		if (type == ScreenField.F_MENU) {
			return (s.getRow(pos) == startRow() && pos >= s.getCol(startPos));
		}
		
		int wc= startPos;
		int col_left= startPos - 3;
		int col_right= startPos + length;
		
		for (int i= 0; i < rows; ++i) {
			if (pos >= col_left && pos <= col_right) {
				return true;
			}
			col_left += s.getCols();
			col_right += s.getCols();
		}
		return false;

	}

	public void setFlag(int f1, int f2, int f3) {
		flag1= f1;
		flag2= f2;
		flag3= f3;
	}

// add start pei 080208
	public void setMenu_cnt(int n) {
		available= new boolean[n];
		menu_pos= new int[n];
		menu_len= new int[n];
		minor_flag[0]= new int[n];
		minor_flag[1]= new int[n];
		minor_flag[2]= new int[n];
	}
	
	public int getMenu_cnt() {
		return (menu_pos.length);
	}
	
	public void setMenu_pos(int n, int p, int l) {
		menu_pos[n - 1]= p;
		menu_len[n - 1]= l;
	}
	
	public int getMenu_pos(int n) {
		return (menu_pos[n - 1]);
	}
	
	public int getMenu_len(int n) {
		return (menu_len[n - 1]);
	}
// add end
	
	public int getFlag1() {
		return (flag1);
	}
	
	public int getFlag2() {
		return (flag2);
	}
	
	public int getFlag3() {
		return (flag3);
	}
	
// add start pei 080208
	public void advanceMenu(boolean dir) {
		if (dir) {
			++selectpos;
			if (selectpos > menu_pos.length) {
				selectpos= 1;
			}
		} else {
			--selectpos;
			if (selectpos <= 0) {
				selectpos= menu_pos.length;
			}
		}
	}
	
	public boolean changeMenu(int cellpos) {
		for (int i= 0; i < menu_pos.length; ++i) {
			if (cellpos >= menu_pos[i] && cellpos < (menu_pos[i] + menu_len[i])) {
				selectpos= i + 1;
				return (true);
			}
		}
		return (false);
	}
	
	public void setMinorFlags(int n, int f1, int f2, int f3) {
		minor_flag[0][n - 1]= f1;
		minor_flag[1][n - 1]= f2;
		minor_flag[2][n - 1]= f3;
	}

	public int getMinorFlag(int n, int nn) {
		return (minor_flag[n - 1][nn == 0 ? 0 : nn - 1]);
	}
	
	public boolean isSelectionField() {
		return (true);
	}
	
	public void reset() {
		selectpos= 0;
	}
// add end

}