/**
 * Title: PrinterThread
 * Copyright:   Copyright (c) 2001
 * Company:
 * @author  Kenneth J. Pouncey
 * @version 0.5
 *
 * Description:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */
/*
 *  Modified MAY/2005 By pei
 */
package je.tn5250j;

import java.awt.print.*;
import java.io.ByteArrayOutputStream;
import java.awt.*;
import java.awt.font.*;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JOptionPane;


public class PrinterThread extends Thread implements Printable, TN5250jConstants {

	ScreenChar[] screen;
	int numCols;
	int numRows;
	Color colorBg;
	Font font;
	Session session;
	boolean toDefault;
	// add pei 070115
	boolean showDialog;
	SessionConfig config;
	
// add start pei 060706
	Screen5250 screen5250;
	byte[][] gridbf_tb= null;
	byte[] gridbf_bs= null; // add pei 070322
// add end

	// chg pei 060706 Screen5250ǉ
	public PrinterThread(
		ScreenChar[] sc,
		Font font,
		int cols,
		int rows,
		Color colorBg,
		boolean toDefaultPrinter,
		boolean showPrintDialog,
		Session ses,
		ByteArrayOutputStream gridbf_bs,
		byte[][] gridbf_tb) {

		setPriority(1);
		session = ses;
		session.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		config = ses.getConfiguration();

		screen = new ScreenChar[sc.length];
		toDefault = toDefaultPrinter;
		// add pei 070115
		showDialog = showPrintDialog;

		int len = sc.length;

		for (int x = 0; x < len; x++) {
			screen[x] = new ScreenChar(sc[x].s);
			int dbcf = sc[x].getDBCF();
			char c = dbcf == ScreenChar.F_DBC2 ? ' ' : sc[x].getChar();
			screen[x].setCharAndAttr(
				c,
				sc[x].getCharAttr(),
				sc[x].isAttributePlace(),
				dbcf,
				sc[x].getEbcdic());
		}

		numCols = cols;
		numRows = rows;
		this.colorBg = colorBg;
		this.font = font;
		
// add start pei 070322 rRs[
		if (gridbf_bs != null) 
			this.gridbf_bs = gridbf_bs.toByteArray();

		this.gridbf_tb = new byte[6][];
		for(int i=0; i<6; i++){
			if(gridbf_tb[i] != null){
				this.gridbf_tb[i] = new byte[gridbf_tb[i].length];
				System.arraycopy(gridbf_tb[i], 0, this.gridbf_tb[i], 0, gridbf_tb[i].length);
			}
		}
// add end
	}

	public void run() {
		// Toolkit tk = Toolkit.getDefaultToolkit();
		//int [][] range = new int[][] {
		//new int[] { 1, 1 }
		//};
		// JobAttributes jobAttributes = new JobAttributes(1, JobAttributes.DefaultSelectionType.ALL, JobAttributes.DestinationType.PRINTER, JobAttributes.DialogType.NONE, "file", 1, 1, JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES, range, "HP LaserJet", JobAttributes.SidesType.ONE_SIDED);
		//PrintJob job = tk.getPrintJob(null, "Print", jobAttributes, null);
		//if (job != null) {
		//--- Create a printerJob object
		PrinterJob printJob = PrinterJob.getPrinterJob();
		
		printJob.setJobName("tn5250j JP");

		// will have to remember this for the next time.
		//   Always set a page format before call setPrintable to
		//   set the orientation.
		PageFormat pf = printJob.defaultPage();
		if (numCols == 132) {
			String so= config.getStringProperty("print.Orientation132");
			if (so != null && so.length() != 0) {
				pf.setOrientation(Integer.parseInt(so));
			} else {
				pf.setOrientation(PageFormat.LANDSCAPE);
			}
		} else {
			String so= config.getStringProperty("print.Orientation80");
			if (so != null && so.length() != 0) {
				pf.setOrientation(Integer.parseInt(so));
			} else {
				pf.setOrientation(PageFormat.PORTRAIT);
			}
		}

		if (numCols != 132) {
			if (config.getStringProperty("print.portWidth").length() != 0
				&& config.getStringProperty("print.portHeight").length() != 0
				&& config.getStringProperty("print.portImageWidth").length() != 0
				&& config.getStringProperty("print.portImageHeight").length() != 0
				&& config.getStringProperty("print.portImage.X").length() != 0
				&& config.getStringProperty("print.portImage.Y").length() != 0) {

				Paper paper = pf.getPaper();

				paper.setSize(
					Double.parseDouble(
						config.getStringProperty("print.portWidth")),
					Double.parseDouble(
						config.getStringProperty("print.portHeight")));

				paper.setImageableArea(
					Double.parseDouble(
						config.getStringProperty("print.portImage.X")),
					Double.parseDouble(
						config.getStringProperty("print.portImage.Y")),
					Double.parseDouble(
						config.getStringProperty("print.portImageWidth")),
					Double.parseDouble(
						config.getStringProperty("print.portImageHeight")));
				pf.setPaper(paper);

			}
		} else {

			if (config.getStringProperty("print.landWidth").length() != 0
				&& config.getStringProperty("print.landHeight").length() != 0
				&& config.getStringProperty("print.landImageWidth").length() != 0
				&& config.getStringProperty("print.landImageHeight").length() != 0
				&& config.getStringProperty("print.landImage.X").length() != 0
				&& config.getStringProperty("print.landImage.Y").length() != 0) {

				Paper paper = pf.getPaper();

				paper.setSize(
					Double.parseDouble(
						config.getStringProperty("print.landWidth")),
					Double.parseDouble(
						config.getStringProperty("print.landHeight")));

				paper.setImageableArea(
					Double.parseDouble(
						config.getStringProperty("print.landImage.X")),
					Double.parseDouble(
						config.getStringProperty("print.landImage.Y")),
					Double.parseDouble(
						config.getStringProperty("print.landImageWidth")),
					Double.parseDouble(
						config.getStringProperty("print.landImageHeight")));
			}
		}

		if (config.getStringProperty("print.font").length() > 0) {

			font =
				new Font(config.getStringProperty("print.font"), Font.PLAIN, 8);
		}

		//--- Set the printable class to this one since we
		//--- are implementing the Printable interface
		printJob.setPrintable(this, pf);

		// set the cursor back
		session.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

		//for applet (bug?) pei
		Thread.currentThread().setContextClassLoader(new ClassLoader() {
		});

		//--- Show a print dialog to the user. If the user
		//--- clicks the print button, then print, otherwise
		//--- cancel the print job
		
// chg start pei 060929
		String printerName = null;
		PrintService[] ps;
		PrintService printer = null;
		
		// chg pei 060223 Error Catch AppletΉ
		try{
			ps = PrintServiceLookup.lookupPrintServices(null, null);
		} catch(Error err) {
			ps = null;	
		}
		
		if (config.getStringProperty("print.printer").length() > 0) {
			printerName = config.getStringProperty("print.printer");
			if (ps != null) {
				if (ps.length > 0) {
					for (int i = 0; i < ps.length; i++) {
						if(printerName.equals(ps[i].getName())){
								printer = ps[i];
						}
					}
				}
			}
		}
if (System.getProperty("os.name").equals("Windows Vista")) {
	
		int confirm = JOptionPane.NO_OPTION;
		if (printer != null && !toDefault && !showDialog) {	
			confirm = JOptionPane.showConfirmDialog(null, 
				"v^[F" + printer + "ňs܂B\nv^[ύXꍇ́Aݒw肵ĂB",
				"mF", 
				JOptionPane.YES_NO_OPTION);
			if (confirm == JOptionPane.YES_OPTION) showDialog = true;
		}
		if (toDefault || showDialog) {
			try {
				if (printer != null && !toDefault && showDialog) {
					printJob.setPrintService(printer);	
				}
				// we do this because of loosing focus with jdk 1.4.0
				session.requestFocus();
				printJob.print();
			} catch (Exception PrintException) {
				PrintException.printStackTrace();
			}
		} else if (printer != null && confirm == JOptionPane.NO_OPTION) {
			session.requestFocus();
		} else {
			JOptionPane.showMessageDialog(null, 
				"ʈsv^[ݒ肳Ă܂B\nݒv^[w肵ĂB", 
				"v^[wG[", 
				JOptionPane.OK_CANCEL_OPTION);
			// we do this because of loosing focus with jdk 1.4.0
			session.requestFocus();
		}
} else {
		if (toDefault || showDialog || printJob.printDialog()) {
			try {
				if (printer != null && !toDefault && showDialog) {
					printJob.setPrintService(printer);	
				}
				// we do this because of loosing focus with jdk 1.4.0
				session.requestFocus();
				printJob.print();
			} catch (Exception PrintException) {
				PrintException.printStackTrace();
			}
		} else {
			// we do this because of loosing focus with jdk 1.4.0
			session.requestFocus();
		}
}
// chg end

		session = null;

		int len = screen.length;

		for (int x = 0; x < len; x++) {
			screen[x] = null;
		}

		screen = null;
	}

	/**
	  * Method: print <p>
	  *
	  * This routine is responsible for rendering a page using
	  * the provided parameters. The result will be a screen
	  * print of the current screen to the printer graphics object
	  *
	  * @param g a value of type Graphics
	  * @param pageFormat a value of type PageFormat
	  * @param page a value of type int
	  * @return a value of type int
	  */
	public int print(Graphics g, PageFormat pageFormat, int page) {

		Graphics2D g2;
		
		Screen5250 s5250 = session.getScreen();

		//--- Validate the page number, we only print the first page
		if (page == 0) {

			//--- Create a graphic2D object and set the default parameters
			g2 = (Graphics2D) g;
			g2.setColor(Color.black);

			//--- Translate the origin to be (0,0)
			g2.translate(
				pageFormat.getImageableX(),
				pageFormat.getImageableY());

			int w = (int) pageFormat.getImageableWidth() / numCols;
			// proposed width
			int h = (int) pageFormat.getImageableHeight() / numRows;
			// proposed height

			Font k = font;

			LineMetrics l;
			FontRenderContext f = null;

			float j = 1;

			for (; j < 50; j++) {

				// derive the font and obtain the relevent information to compute
				// the width and height
				k = font.deriveFont(j);
				f = new FontRenderContext(k.getTransform(), true, true);
				l = k.getLineMetrics("Wy", f);

				if ((w < (int) k.getStringBounds("W", f).getWidth())
					|| h
						< (int) (k.getStringBounds("y", f).getHeight()
							+ l.getDescent()
							+ l.getLeading()))
					break;
			}

			// since we were looking for an overrun of the width or height we need
			// to adjust the font one down to get the last one that fit.
			k = font.deriveFont(--j);
			f = new FontRenderContext(k.getTransform(), true, true);
			l = k.getLineMetrics("Wy", f);

			// set the font of the print job
			g2.setFont(k);

			// get the width and height of the character bounds
			int w1 = (int) k.getStringBounds("W", f).getWidth();
			int h1 =
				(int) (k.getStringBounds("y", f).getHeight()
					+ l.getDescent()
					+ l.getLeading());
			int x;
			int y;

			// loop through all the screen characters and print them out.
			for (int m = 0; m < numRows; m++)
				for (int i = 0; i < numCols; i++) {
					x = w1 * i;
					y = h1 * (m + 1);

					// only draw printable characters (in this case >= ' ')
					char c= screen[getPos(m, i)].getChar();
					if (c >= ' '
						&& !screen[getPos(m, i)].nonDisplay) {

						Font sv_f= g2.getFont();
						boolean savefont= false;
						if (Character.getType(c) == Character.PRIVATE_USE) {
//g.setFont(new Font("EUDC", sv_f.getStyle(), sv_f.getSize()));
//yajima start
							String gaijifont = "EUDC";
							Screen5250 s= session.getScreen();
							if(s.getStringProperty("gaijiFontName").length() != 0){
								gaijifont= s.getStringProperty("gaijiFontName");
							}
							g2.setFont(new Font(gaijifont, sv_f.getStyle(), sv_f.getSize()));
//yajima end
							savefont= true;
						}
						// chg pei 060817 xW-1
						g2.drawChars(
							screen[getPos(m, i)].sChar,
							0,
							1,
							x-1,
							(int) (y
								+ h1
								- (l.getDescent() + l.getLeading())
								- 2));

						if (savefont) {
							g2.setFont(sv_f);
						}
					}
					// if it is underlined then underline the character
					if (screen[getPos(m, i)].underLine
						&& !screen[getPos(m, i)].attributePlace)
// chg start pei 060710 xW-1
						g.drawLine(
							x - 1,
							(int) (y + (h1 - l.getLeading() - 3)),
							(int) (x + w1 - 1),
							(int) (y + (h1 - l.getLeading()) - 3));	
// chg end
							
// add start pei 060710 ؐ̒ǉ
					if (screen[getPos(m, i)].colSep && screen[getPos(m, i)].getDBCF() != 0x02) {
						int csx = x - 1;
						int xx = screen[getPos(m, i)].getDBCF() != 0x01 ? (csx + w1) : (csx + w1 * 2);
						switch (s5250.getColSepLine()) {
							case 0 : // line
								//g.drawLine(csx, y - 1, csx, y + h1 - 1);
								g.drawLine(
									xx,
									y - 1,
									xx,
									y + h1 - 1);
								break;
							case 1 : // short line
								//g.drawLine(
								//	csx,
								//	y + h1 - (int) s5250.lm.getLeading() - 4,
								//	csx,
								//	y + h1 - 1);
								g.drawLine(
									xx,
									y + h1 - (int) s5250.lm.getLeading() - 4,
									xx,
									y + h1 - 1);
								break;
							case 2 : // dot
								//g.drawLine(
								//	csx,
								//	y + h1 - (int) s5250.lm.getLeading() - 3,
								//	csx,
								//	y + h1 - (int) s5250.lm.getLeading() - 4);
								g.drawLine(
									xx,
									y + h1 - (int) s5250.lm.getLeading() - 3,
									xx,
									y + h1 - (int) s5250.lm.getLeading() - 4);
								break;
							case 3 : // hide
								break;
						}
					}
// add end					
				}

// add start pei 060705
// chg start pei 061121 rQΉ s5250.gridbf  gridbf
				// DDSrΉ
				//if (s5250.gridbf != null) {
				// chg pei 070322
				//if (s5250.gridbf_bs != null) {
				if (gridbf_bs != null) {
					
					// chg pei 070322
					//byte[] gridbf = s5250.gridbf_bs.toByteArray();
					byte[] gridbf = gridbf_bs;
					
					for (int pos = 0; pos < gridbf.length;) {
						int ln = gridbf[pos];
						y = (gridbf[pos + 3] & 0xff) - 1;
						x = (gridbf[pos + 4] & 0xff) - 1;
						y *= h1;
						x *= w1;
						int dim = 0;
						int type= gridbf[pos + 1];
						y = (int)(y + h1 - (l.getDescent() + l.getLeading()));
						
						// add pei 061122 rYΉ
						if (x > 0) --x;
						
						switch (type) {
							case 0 : //upper
								dim = (gridbf[pos + 5] & 0xff);
								int lines= ln > 9 ? (gridbf[pos + 9] & 0xff) : 1;
								// add pei 070205 rJԂ`揈Ή
								int ww= ln > 10 ? (gridbf[pos + 10] & 0xff) : 1;
								
								for (int i= 0; i < lines; ++i) {
									g.drawLine(x, y, x + w1 * dim, y);
									// chg pei 070205 rJԂ`揈Ή
									//y += h1;
									y += h1 * ww;
								}
								break;
							case 1 : //lower
								dim = (gridbf[pos + 5] & 0xff);
								// chg pei 061122 rYΉ
								//y += h1 - 1;
								y += h1;
								lines= ln > 9 ? (gridbf[pos + 9] & 0xff) : 1;
								// add pei 070205 rJԂ`揈Ή
								ww= ln > 10 ? (gridbf[pos + 10] & 0xff) : 1;
								
								for (int i= 0; i < lines; ++i) {
									g.drawLine(x, y, x + w1 * dim, y);
									// chg pei 070205 rJԂ`揈Ή
									//y += h1;
									y += h1 * ww;
								}
								break;
							case 2 : //left
								dim = (gridbf[pos + 6] & 0xff);
								// chg pei 070205 rJԂ`揈Ή
								//g.drawLine(x, y, x, y + h1 * dim);
								lines= ln > 9 ? (gridbf[pos + 9] & 0xff) : 1;
								ww= ln > 10 ? (gridbf[pos + 10] & 0xff) : 1;
								for (int i= 0; i < lines; ++i) {
									g.drawLine(x, y, x, y + h1 * dim);
									x += w1 * ww;
								}
								
								break;
							case 3 : //right
								dim =  (gridbf[pos + 6] & 0xff);
								// chg pei 061122 rYΉ
								//x += w1 - 1;
								x += w1;
								// chg pei 070205 rJԂ`揈Ή
								//g.drawLine(x, y, x, y + h1 * dim);
								lines= ln > 9 ? (gridbf[pos + 9] & 0xff) : 1;
								ww= ln > 10 ? (gridbf[pos + 10] & 0xff) : 1;
								for (int i= 0; i < lines; ++i) {
									g.drawLine(x, y, x, y + h1 * dim);
									x += w1 * ww;
								}
								
								break;
							case 4 : //box
							case 5 : //box
							case 6 : //box
							case 7 : //box
								int right=  x + w1 * (gridbf[pos + 5] & 0xff);
								int bot=  y + h1 * (gridbf[pos + 6] & 0xff);
								
								// del 061122 rYΉ
								//--x;	//???
								//--bot;
								
								g.drawLine(x, y, right, y);
								g.drawLine(x, y, x, bot);
								g.drawLine(right, y, right, bot);
								g.drawLine(x, bot, right, bot);
								if (type == 5 || type == 7) {
									int interval= ln > 9 ? (gridbf[pos + 9] & 0xff) : 1;
									interval *= h1;
									for (int i= y + interval; i < bot; i += interval) {
										g.drawLine(x, i, right, i);
									}
								}
								if (type == 6 || type == 7) {
									int interval= ln > 10 ? (gridbf[pos + 10] & 0xff) : 1;
									interval *= w1;
									for (int i= x + interval; i < right; i += interval) {
										g.drawLine(i, y, i, bot);
									}
								}
								break;
						}
						pos += ln;
					}
				}
// chg end
				
				// TOOLBOXrΉ
				byte [] d;
				char c = screen[2].getChar();
				if (c > 'F' || c < 'A'){
				} else {
					// chg pei 070322
					//d = s5250.gridbf_tb[c - 'A'];
					d = gridbf_tb[c - 'A'];
					if (d == null) {
					} else {
						g2.setClip(0, 0, (numCols * w1) -1, (numRows * h1) - 1);
						for (int q= 0,pos= 0; q < d.length; ++q) {
							byte wb= d[q];
							for (int r= 0; r < 3; ++r,++pos) {
								x= (pos % numCols) * w1;
								y= (pos / numCols) * h1;
								if (y > 0) --y;	//???
								int wi= wb >> ((2 - r) * 2);
								y = (int)(y + h1 - (l.getDescent() + l.getLeading()) + 2);
								if ((wi & 0x01) != 0) {
									g2.drawLine(x, y, x, y + h1);
								}
								if ((wi & 0x02) != 0) {
									g2.drawLine(x, y, x + w1, y);
								}
							}
						} 
					}
				}
// add end						
			return (PAGE_EXISTS);
		} else
			return (NO_SUCH_PAGE);
	}

	private int getPos(int row, int col) {

		return (row * numCols) + col;
	}
}