/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.VirtualSuperset;
import org.tmdmaker.core.model.VirtualSupersetType;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.actions.gef3.AbstractMultipleSelectionAction;
import org.tmdmaker.ui.dialogs.VirtualSupersetCreateDialog;
import org.tmdmaker.ui.editor.gef3.commands.VirtualSupersetCreateCommand;
import org.tmdmaker.ui.editor.gef3.commands.VirtualSupersetEditCommand;
import org.tmdmaker.ui.editor.gef3.commands.VirtualSupersetTypeChangeCommand;
import org.tmdmaker.ui.editor.gef3.editparts.DiagramEditPart;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractEntityModelEditPart;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;

public class VirtualSupersetCreateAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "_VS";

    public VirtualSupersetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EditVirtualSuperset);
        this.setId(ID);
    }

    public void run() {
        VirtualSupersetCreateDialog dialog;
        Point pos = this.getControlCursorLocation();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        Diagram diagram = this.getDiagram();
        VirtualSuperset original = null;
        VirtualSupersetType aggregator = null;
        if (!selectedModels.isEmpty() && (original = this.getVirtualSuperset()) != null) {
            selectedModels.remove(original);
        }
        if ((dialog = new VirtualSupersetCreateDialog(this.getControl().getShell(), diagram, original, selectedModels)).open() == 0) {
            CompoundCommand ccommand = null;
            VirtualSuperset edited = dialog.getEditedValue();
            aggregator = dialog.getEditedAggregator();
            List<AbstractEntityModel> selection = dialog.getSelection();
            if (original == null) {
                if (selection.isEmpty()) {
                    return;
                }
                ccommand = new CompoundCommand();
                ccommand.add((Command)new VirtualSupersetCreateCommand(edited, selection, pos.x, pos.y));
                ccommand.add((Command)new VirtualSupersetTypeChangeCommand(edited, aggregator.isApplyAttribute()));
            } else {
                ccommand = new VirtualSupersetEditCommand(original, edited, selection, aggregator.isApplyAttribute());
            }
            this.execute((Command)ccommand);
        }
    }

    private Control getControl() {
        return ((AbstractEditPart)this.getSelectedObjects().get(0)).getViewer().getControl();
    }

    private Point getControlCursorLocation() {
        Control control = this.getControl();
        Point pos = control.getDisplay().getCursorLocation();
        pos = control.toControl(pos);
        pos.x -= 200;
        pos.y -= 100;
        return pos;
    }

    private Diagram getDiagram() {
        for (Object o : this.getSelectedObjects()) {
            if (o instanceof DiagramEditPart) {
                return (Diagram)((DiagramEditPart)o).getModel();
            }
            if (!(o instanceof AbstractModelEditPart)) continue;
            return (Diagram)((AbstractModelEditPart)o).getParent().getModel();
        }
        return null;
    }

    private VirtualSuperset getVirtualSuperset() {
        List<AbstractEntityModel> list = this.getSelectedModelList();
        for (AbstractEntityModel o : list) {
            if (!(o instanceof VirtualSuperset)) continue;
            return (VirtualSuperset)o;
        }
        for (AbstractEntityModel o : list) {
            VirtualSupersetType type = o.findVirtualSupersetType();
            if (type == null) continue;
            return type.getSuperset();
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        if (!this.getSelectedObjects().isEmpty() && this.hasEntityModel()) {
            return true;
        }
        return this.isDiagramSelected();
    }

    private boolean hasEntityModel() {
        for (Object o : this.getSelectedObjects()) {
            if (!(o instanceof AbstractEntityModelEditPart)) continue;
            return true;
        }
        return false;
    }

    private boolean isDiagramSelected() {
        return this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof DiagramEditPart;
    }
}

