/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model.multivalue;

import java.util.ArrayList;
import java.util.List;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.AbstractRelationship;
import org.tmdmaker.core.model.Cardinality;
import org.tmdmaker.core.model.Header2DetailRelationship;
import org.tmdmaker.core.model.relationship.Relationship;

public class MultivalueAndBuilder {
    private AbstractEntityModel header;
    private Header2DetailRelationship relationship;
    private List<AbstractRelationship> removedRelationshipList = new ArrayList<AbstractRelationship>();
    private List<AbstractRelationship> reconnectedRelationshipList = new ArrayList<AbstractRelationship>();

    protected MultivalueAndBuilder(AbstractEntityModel header) {
        this.header = header;
        this.relationship = new Header2DetailRelationship(header);
    }

    public void build() {
        this.relationship.connect();
        if (!this.header.isEvent()) {
            return;
        }
        for (AbstractConnectionModel con : this.header.getModelTargetConnections()) {
            AbstractRelationship relation;
            if (!(con instanceof AbstractRelationship) || !(relation = (AbstractRelationship)con).isMultiValue()) continue;
            this.removedRelationshipList.add(relation);
            AbstractEntityModel source = relation.getSource();
            AbstractRelationship reconnectedRelationship = Relationship.of(source, this.relationship.getDetail());
            reconnectedRelationship.setTargetCardinality(Cardinality.MANY);
            this.reconnectedRelationshipList.add(reconnectedRelationship);
        }
        if (!this.removedRelationshipList.isEmpty()) {
            for (AbstractRelationship removed : this.removedRelationshipList) {
                removed.disconnect();
            }
            for (AbstractRelationship reconnected : this.reconnectedRelationshipList) {
                reconnected.connect();
            }
        }
    }

    public void rollback() {
        this.relationship.disconnect();
        if (!this.removedRelationshipList.isEmpty()) {
            for (AbstractRelationship removed : this.removedRelationshipList) {
                removed.connect();
            }
            for (AbstractRelationship reconnected : this.reconnectedRelationshipList) {
                reconnected.disconnect();
            }
        }
    }
}

