/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.tmdmaker.core.Configuration;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Attribute;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.parts.ModelName;

public class Identifier
extends Attribute {
    private AbstractEntityModel parent;

    public Identifier(String name) {
        super(name);
    }

    public Identifier() {
    }

    @Override
    public IAttribute getCopy() {
        Identifier copy = new Identifier();
        this.copyTo(copy);
        return copy;
    }

    public ModelName createEntityName() {
        return new ModelName(this.generateEntityName(this.getName()));
    }

    private String generateEntityName(String identifierName) {
        String entityName = this.removeIdentifierSuffixFromIdentifierName(identifierName);
        return this.removeReportNameSuffixFromEntityName(entityName);
    }

    private String removeIdentifierSuffixFromIdentifierName(String identifierName) {
        for (String suffix : Configuration.getDefault().getIdentifierSuffixes()) {
            if (!identifierName.endsWith(suffix)) continue;
            return identifierName.substring(0, identifierName.lastIndexOf(suffix));
        }
        return identifierName;
    }

    private String removeReportNameSuffixFromEntityName(String entityName) {
        for (String reportSuffix : Configuration.getDefault().getReportSuffixes()) {
            if (!entityName.endsWith(reportSuffix)) continue;
            return entityName.substring(0, entityName.lastIndexOf(reportSuffix));
        }
        return entityName;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    AbstractEntityModel getParent() {
        return this.parent;
    }

    public void setParent(AbstractEntityModel parent) {
        this.parent = parent;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.parent != null) {
            this.parent.fireIdentifierChanged();
        }
    }
}

