/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.sphinx.generate;

import java.io.File;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.model.generate.Generator;
import org.tmdmaker.sphinx.Messages;
import org.tmdmaker.sphinx.attributelist.AttributeListRstGenerator;
import org.tmdmaker.sphinx.keydefinitionlist.KeyDefinitionListRstGenerator;
import org.tmdmaker.sphinx.relationshiplist.RelationshipListRstGenerator;
import org.tmdmaker.sphinx.utilities.SphinxUtils;

public class DocGenerator
implements Generator {
    private Diagram diagram;

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        final File outputdir = new File(rootDir, "doc");
        outputdir.mkdirs();
        this.diagram = ((AbstractEntityModel)IterableExtensions.head(models)).getDiagram();
        this.outputConfig(outputdir);
        this.outputIndex(outputdir);
        InputStream _resourceAsStream = this.getClass().getResourceAsStream("make.bat");
        File _file = new File(outputdir, "make.bat");
        SphinxUtils.copyTo(_resourceAsStream, _file);
        InputStream _resourceAsStream_1 = this.getClass().getResourceAsStream("Makefile");
        File _file_1 = new File(outputdir, "Makefile");
        SphinxUtils.copyTo(_resourceAsStream_1, _file_1);
        Procedures.Procedure1<List<AbstractEntityModel>> _function = new Procedures.Procedure1<List<AbstractEntityModel>>(){

            public void apply(List<AbstractEntityModel> it) {
                AttributeListRstGenerator.generateAttributeList(it, outputdir);
                Functions.Function1<AbstractEntityModel, Boolean> _function = new Functions.Function1<AbstractEntityModel, Boolean>(){

                    public Boolean apply(AbstractEntityModel m) {
                        boolean _isNotImplement = m.isNotImplement();
                        return !_isNotImplement;
                    }
                };
                KeyDefinitionListRstGenerator.generateKeyDefinitionList(IterableExtensions.toList((Iterable)IterableExtensions.filter(it, (Functions.Function1)_function)), outputdir);
                RelationshipListRstGenerator.generateRelationshipList(it, outputdir);
            }
        };
        ObjectExtensions.operator_doubleArrow(models, (Procedures.Procedure1)_function);
    }

    public String getGeneratorName() {
        return Messages.getString("DocGenerator_GeneratorName");
    }

    public String getGroupName() {
        return "sphinx";
    }

    public boolean isImplementModelOnly() {
        return false;
    }

    private void outputIndex(File outputDir) {
        CharSequence _index = this.index(this.diagram.getName(), this.diagram.getDescription());
        File _file = new File(outputDir, "index.rst");
        SphinxUtils.writeTo(_index, _file);
    }

    private void outputConfig(File outputDir) {
        int year = Calendar.getInstance().get(1);
        String author = System.getProperty("user.name");
        CharSequence _confPy = this.confPy(this.diagram.getName(), year, author);
        File _file = new File(outputDir, "conf.py");
        SphinxUtils.writeTo(_confPy, _file);
    }

    private CharSequence index(String diagram_name, String description) {
        StringConcatenation _builder = new StringConcatenation();
        if (diagram_name != null) {
            _builder.append("\u300c");
            _builder.append(diagram_name);
            _builder.append("\u300d");
        }
        _builder.append("\u8a2d\u8a08\u6587\u66f8");
        _builder.newLineIfNotEmpty();
        if (diagram_name != null) {
            int _length = diagram_name.length();
            int _multiply = _length * 2;
            String _repeat = StringUtils.repeat((String)"=", (int)_multiply);
            _builder.append(_repeat);
        }
        _builder.append("============");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append(description);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append(".. toctree::");
        _builder.newLine();
        _builder.append("   ");
        _builder.append(":maxdepth: 1");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("attribute_list");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("key_list");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("relationship_list");
        _builder.newLine();
        return _builder;
    }

    private CharSequence confPy(String diagram_name, int year, String author) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env python3");
        _builder.newLine();
        _builder.append("# -*- coding: utf-8 -*-");
        _builder.newLine();
        _builder.append("extensions = []");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Add any paths that contain templates here, relative to this directory.");
        _builder.newLine();
        _builder.append("templates_path = ['_templates']");
        _builder.newLine();
        _builder.newLine();
        _builder.append("source_suffix = '.rst'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The master toctree document.");
        _builder.newLine();
        _builder.append("master_doc = 'index'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# General information about the project.");
        _builder.newLine();
        _builder.append("project = '");
        _builder.append(diagram_name);
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("copyright = '");
        _builder.append((Object)year);
        _builder.append(", ");
        _builder.append(author);
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("author = '");
        _builder.append(author);
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# The version info for the project you're documenting, acts as replacement for");
        _builder.newLine();
        _builder.append("# |version| and |release|, also used in various other places throughout the");
        _builder.newLine();
        _builder.append("# built documents.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# The short X.Y version.");
        _builder.newLine();
        _builder.append("version = '1.0'");
        _builder.newLine();
        _builder.append("# The full version, including alpha/beta/rc tags.");
        _builder.newLine();
        _builder.append("release = '1.0'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The language for content autogenerated by Sphinx. Refer to documentation");
        _builder.newLine();
        _builder.append("# for a list of supported languages.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# This is also used if you do content translation via gettext catalogs.");
        _builder.newLine();
        _builder.append("# Usually you set \"language\" from the command line for these cases.");
        _builder.newLine();
        _builder.append("language = 'ja'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# List of patterns, relative to source directory, that match files and");
        _builder.newLine();
        _builder.append("# directories to ignore when looking for source files.");
        _builder.newLine();
        _builder.append("# This patterns also effect to html_static_path and html_extra_path");
        _builder.newLine();
        _builder.append("exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The name of the Pygments (syntax highlighting) style to use.");
        _builder.newLine();
        _builder.append("pygments_style = 'sphinx'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# If true, `todo` and `todoList` produce output, else they produce nothing.");
        _builder.newLine();
        _builder.append("todo_include_todos = False");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# -- Options for HTML output ----------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# The theme to use for HTML and HTML Help pages.  See the documentation for");
        _builder.newLine();
        _builder.append("# a list of builtin themes.");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("html_theme = 'bizstyle'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Add any paths that contain custom static files (such as style sheets) here,");
        _builder.newLine();
        _builder.append("# relative to this directory. They are copied after the builtin static files,");
        _builder.newLine();
        _builder.append("# so a file named \"default.css\" will overwrite the builtin \"default.css\".");
        _builder.newLine();
        _builder.append("html_static_path = ['_static']");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Output file base name for HTML help builder.");
        _builder.newLine();
        _builder.append("htmlhelp_basename = 'sphinxdoc'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# -- Options for LaTeX output ---------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append("latex_elements = {");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Grouping the document tree into LaTeX files. List of tuples");
        _builder.newLine();
        _builder.append("# (source start file, target name, title,");
        _builder.newLine();
        _builder.append("#  author, documentclass [howto, manual, or own class]).");
        _builder.newLine();
        _builder.append("latex_documents = [");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("(master_doc, 'sphinx.tex', '");
        _builder.append(diagram_name, "    ");
        _builder.append(" Documentation',");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("'");
        _builder.append(author, "     ");
        _builder.append("', 'manual'),");
        _builder.newLineIfNotEmpty();
        _builder.append("]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# -- Options for manual page output ---------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# One entry per manual page. List of tuples");
        _builder.newLine();
        _builder.append("# (source start file, name, description, authors, manual section).");
        _builder.newLine();
        _builder.append("man_pages = [");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("(master_doc, 'sphinx', '");
        _builder.append(diagram_name, "    ");
        _builder.append(" Documentation',");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("[author], 1)");
        _builder.newLine();
        _builder.append("]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# -- Options for Texinfo output -------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Grouping the document tree into Texinfo files. List of tuples");
        _builder.newLine();
        _builder.append("# (source start file, target name, title, author,");
        _builder.newLine();
        _builder.append("#  dir menu entry, description, category)");
        _builder.newLine();
        _builder.append("texinfo_documents = [");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("(master_doc, 'sphinx', '");
        _builder.append(diagram_name, "    ");
        _builder.append(" Documentation',");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("author, 'sphinx', 'One line description of project.',");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("'Miscellaneous'),");
        _builder.newLine();
        _builder.append("]");
        _builder.newLine();
        return _builder;
    }
}

