/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.views.properties.IPropertySource;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.core.model.Laputa;
import org.tmdmaker.core.model.ModelElement;
import org.tmdmaker.core.model.other.Memo;
import org.tmdmaker.core.model.other.TurboFile;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import org.tmdmaker.ui.editor.gef3.commands.ConstraintChangeCommand;
import org.tmdmaker.ui.editor.gef3.commands.EntityModelAddCommand;
import org.tmdmaker.ui.editor.gef3.commands.MemoAddCommand;
import org.tmdmaker.ui.editor.gef3.commands.MemoChangeCommand;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractTMDEditPart;
import org.tmdmaker.ui.views.properties.IPropertyAvailable;
import org.tmdmaker.ui.views.properties.gef3.DiagramPropertySource;

public class DiagramEditPart
extends AbstractTMDEditPart<Diagram>
implements IPropertyAvailable {
    public DiagramEditPart(Diagram diagram) {
        this.setModel(diagram);
    }

    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_children")) {
            this.refreshChildren();
        }
    }

    protected List<ModelElement> getModelChildren() {
        return ((Diagram)this.getModel()).getChildren();
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.isEmpty()) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            ss = snapStrategies.toArray(ss);
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    @Override
    public IPropertySource getPropertySource(CommandStack commandStack) {
        return new DiagramPropertySource(commandStack, (Diagram)this.getModel());
    }

    private class DiagramEditPolicy
    extends XYLayoutEditPolicy {
        private DiagramEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            DiagramEditPart.this.logger.debug("{}#createChildEditPolicy()", ((Object)((Object)this)).getClass());
            return new ResizableEditPolicy();
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object rectangle) {
            DiagramEditPart.this.logger.debug("resizedirection:{}", (Object)request.getResizeDirection());
            DiagramEditPart.this.logger.debug("NORTH_SOUTH/EAST_WEST:5/24");
            return new ConstraintChangeCommand((ModelElement)child.getModel(), (Rectangle)rectangle);
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object objectType = request.getNewObjectType();
            DiagramEditPart.this.logger.debug("{} #getCreateCommand() {}", ((Object)((Object)this)).getClass(), objectType);
            Rectangle rectangle = this.getTrimmedRectangle(request);
            if (objectType.equals(TurboFile.class)) {
                TurboFile model = (TurboFile)request.getNewObject();
                ConstraintConverter.setConstraint((ModelElement)model, rectangle);
                return this.createTurboFileCommand(rectangle, model);
            }
            if (objectType.equals(Memo.class)) {
                ConnectableElement model = (ConnectableElement)request.getNewObject();
                ConstraintConverter.setConstraint((ModelElement)model, rectangle);
                return this.createMemoCommand(rectangle, model);
            }
            if (objectType.equals(Entity.class) || objectType.equals(Laputa.class)) {
                return new EntityModelAddCommand((Diagram)DiagramEditPart.this.getModel(), rectangle.x, rectangle.y);
            }
            return null;
        }

        private Rectangle getTrimmedRectangle(CreateRequest request) {
            Rectangle rectangle = (Rectangle)this.getConstraintFor(request);
            rectangle.height = -1;
            rectangle.width = -1;
            return rectangle;
        }

        private EntityModelAddCommand createTurboFileCommand(Rectangle rectangle, TurboFile turbo) {
            turbo.setName(Messages.TurboFile);
            return new EntityModelAddCommand((Diagram)DiagramEditPart.this.getModel(), (AbstractEntityModel)turbo, rectangle.x, rectangle.y);
        }

        private Command createMemoCommand(Rectangle rectangle, ConnectableElement model) {
            Memo memo = (Memo)model;
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new MemoAddCommand((Diagram)DiagramEditPart.this.getModel(), memo, rectangle.x, rectangle.y));
            command.add((Command)new MemoChangeCommand(memo, Messages.Memo));
            return command;
        }
    }
}

