/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.draw2d.figure.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Identifier;
import org.tmdmaker.core.model.ReusedIdentifier;
import org.tmdmaker.ui.editor.draw2d.figure.node.TFormFigure;
import org.tmdmaker.ui.preferences.appearance.ModelAppearance;

public abstract class AbstractModelFigure<T extends AbstractEntityModel>
extends TFormFigure {
    public AbstractModelFigure() {
        this(false);
    }

    public AbstractModelFigure(boolean notImplement) {
        super(notImplement);
    }

    public void update(T model) {
        this.setEntityName(this.getName(model));
        this.setEntityType(this.getTypeLabel(model));
        this.setNotImplement(this.isNotImplement(model));
        this.removeAllRelationship();
        this.addIdentifier(this.setupIdentifierList(model));
        this.addRelationship(this.setupRelationshipList(model));
        this.setupColor(this.getAppearance(model));
    }

    protected String getName(T model) {
        return model.getName();
    }

    protected String getTypeLabel(T model) {
        return model.getEntityType().getLabel();
    }

    protected boolean isNotImplement(T model) {
        return model.isNotImplement();
    }

    protected List<String> setupIdentifierList(T model) {
        return Collections.emptyList();
    }

    protected List<String> setupRelationshipList(T model) {
        ArrayList<String> relationship = new ArrayList<String>();
        for (Map.Entry rk : model.getReusedIdentifiers().entrySet()) {
            for (Identifier i : ((ReusedIdentifier)rk.getValue()).getUniqueIdentifiers()) {
                relationship.add(i.getName());
            }
        }
        return relationship;
    }

    protected ModelAppearance getAppearance(T model) {
        return null;
    }

    public boolean canAutoSize() {
        return true;
    }
}

