/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.SubsetEntity;
import org.tmdmaker.core.model.SubsetType;
import org.tmdmaker.core.model.parts.ModelName;
import org.tmdmaker.core.model.subset.SubsetBuilder;
import org.tmdmaker.ui.editor.draw2d.adjuster.SubsetAdjuster;
import org.tmdmaker.ui.editor.draw2d.adjuster.SubsetTypeAdjuster;

public class SubsetAddCommand
extends Command {
    private AbstractEntityModel parent;
    private List<ModelName> addSubsetNameList;
    private List<SubsetEntity> addedList;
    private SubsetBuilder builder;

    public SubsetAddCommand(AbstractEntityModel parent, List<ModelName> addSubsetNameList) {
        this.parent = parent;
        this.addSubsetNameList = addSubsetNameList;
    }

    public void execute() {
        this.builder = this.parent.subsets().builder();
        for (ModelName name : this.addSubsetNameList) {
            this.builder.add(name);
        }
        this.builder.build();
        SubsetType subsetType = this.parent.subsets().subsetType();
        if (subsetType.isInitialPosition()) {
            new SubsetTypeAdjuster(this.parent, subsetType).adjust();
        }
        this.addedList = this.builder.getAddedSubsetList();
        new SubsetAdjuster(this.parent, this.addedList).adjust();
    }

    public void undo() {
        this.builder.rollbackAdd();
    }

    public void redo() {
        this.builder.build();
    }
}

