/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.views.properties.gef3;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.core.model.EntityType;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.views.properties.gef3.AbstractEntityModelPropertySource;

public class EntityPropertySource
extends AbstractEntityModelPropertySource {
    private static final String IDENTIFIER_NAME = "identifierName";
    private static final String[] ENTITY_TYPE_LABELS = new String[]{Messages.Resource, Messages.Event};
    private static final int ENTITY_TYPE_RESOURCE_INDEX = 0;
    private static final int ENTITY_TYPE_EVENT_INDEX = 1;

    public EntityPropertySource(CommandStack commandStack, Entity model) {
        super(commandStack, (AbstractEntityModel)model);
    }

    @Override
    protected IPropertyDescriptor[] buildPropertyDescriptors() {
        Object entityTypeDescriptor = null;
        entityTypeDescriptor = this.model.isEntityTypeEditable() ? new ComboBoxPropertyDescriptor((Object)"entityType", Messages.EntityType, ENTITY_TYPE_LABELS) : new PropertyDescriptor((Object)"entityType", Messages.EntityType);
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", Messages.ModelName), new TextPropertyDescriptor((Object)"implementName", Messages.ImplementationName), new TextPropertyDescriptor((Object)IDENTIFIER_NAME, Messages.Identifier), entityTypeDescriptor, new ComboBoxPropertyDescriptor((Object)"notImplement", Messages.Implementation, IMPLEMENT_LABELS)};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(IDENTIFIER_NAME)) {
            return this.getModel().getIdentifier().getName();
        }
        return super.getPropertyValue(id.toString());
    }

    @Override
    protected Object getEntityType() {
        if (this.model.isEntityTypeEditable()) {
            return this.entityTypeToIndex();
        }
        return this.getEntityTypeName();
    }

    private String getEntityTypeName() {
        if (this.getModel().isEvent()) {
            return Messages.Event;
        }
        return Messages.Resource;
    }

    private int entityTypeToIndex() {
        if (this.getModel().isEvent()) {
            return 1;
        }
        return 0;
    }

    private boolean isResourceIndex(Object value) {
        return (Integer)value == 0;
    }

    @Override
    protected Object handleSetNewPropertyValue(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("entityType")) {
            return this.isResourceIndex(newValue) ? EntityType.RESOURCE : EntityType.EVENT;
        }
        return super.handleSetNewPropertyValue(propertyName, oldValue, newValue);
    }

    @Override
    protected Object handleOldPropertyValue(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals(IDENTIFIER_NAME)) {
            return this.getModel().getIdentifier().getName();
        }
        return super.handleOldPropertyValue(propertyName, oldValue, newValue);
    }

    private Entity getModel() {
        return (Entity)this.model;
    }
}

