/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.tmdmaker.extension.GeneratorFactory;
import org.tmdmaker.model.generate.Generator;
import org.tmdmaker.ui.handler.GeneratorHandler;

public class DynamicGeneratorPopupMenu
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        if (!this.isTMDFileSelected()) {
            return new IContributionItem[0];
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        IWorkbenchWindow win = workbench.getActiveWorkbenchWindow();
        List generagors = GeneratorFactory.getGenerators();
        ArrayList<MenuManager> items = new ArrayList<MenuManager>();
        MenuManager menu = new MenuManager("TMD-Maker");
        items.add(menu);
        Generator prev = null;
        for (Generator g : generagors) {
            if (prev != null && !prev.getGroupName().equals(g.getGroupName())) {
                menu.add((IContributionItem)new Separator(g.getGroupName()));
            }
            prev = g;
            Command command = commandService.getCommand(g.getClass().getName());
            if (!command.isDefined()) {
                command.define(g.getGeneratorName(), "", commandService.getCategory("tmdmaker.ui.menu.category"));
            }
            handlerService.activateHandler(command.getId(), (IHandler)new GeneratorHandler(g){});
            CommandContributionItemParameter p = new CommandContributionItemParameter((IServiceLocator)win, "", command.getId(), 8);
            CommandContributionItem item = new CommandContributionItem(p);
            item.setVisible(true);
            menu.add((IContributionItem)item);
        }
        return items.toArray(new IContributionItem[0]);
    }

    private boolean isTMDFileSelected() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection == null) {
            return false;
        }
        if (!(selection instanceof TreeSelection)) {
            return false;
        }
        TreeSelection treeSelection = (TreeSelection)selection;
        if (treeSelection.size() != 1) {
            return false;
        }
        Object selectedObject = treeSelection.getFirstElement();
        if (!(selectedObject instanceof IFile)) {
            return false;
        }
        IFile selectedFile = (IFile)selectedObject;
        return selectedFile.getFileExtension().equals("tmd");
    }
}

