/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tmdmaker.imagegenerator.Draw2dToImageConverter;
import org.tmdmaker.ui.Activator;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.editor.workspace.Workspace;

public class DiagramImageGenerateAction
extends Action {
    private GraphicalViewer viewer;
    private IWorkbenchPart part;
    private Draw2dToImageConverter converter;
    public static final String ID = "DiagramImageGenerateAction";

    public DiagramImageGenerateAction(GraphicalViewer viewer, IWorkbenchPart part) {
        this.viewer = viewer;
        this.part = part;
        this.setText(Messages.GenerateImage);
        this.setId(ID);
        this.converter = new Draw2dToImageConverter();
    }

    public void run() {
        block15: {
            FileDialog dialog = new FileDialog(this.viewer.getControl().getShell(), 8192);
            IFile editfile = new Workspace().getEditFile(this.part);
            dialog.setFileName(editfile.getLocation().removeFileExtension().lastSegment());
            dialog.setFilterPath(this.buildFilterPath(editfile));
            dialog.setOverwrite(true);
            String[] extensions = this.converter.getExtensions();
            dialog.setFilterExtensions(extensions);
            String file = dialog.open();
            if (file != null) {
                String selectedExtension = null;
                int filterIndex = dialog.getFilterIndex();
                if (filterIndex == -1) {
                    Activator.showMessageDialog(Messages.ExtensionNotSelected);
                    selectedExtension = file.substring(file.lastIndexOf(46));
                    if (!this.isSupported(extensions, selectedExtension)) {
                        Activator.showErrorDialog(Messages.ExtensionNotSupported);
                        return;
                    }
                } else {
                    selectedExtension = extensions[filterIndex];
                }
                final String extension = selectedExtension;
                final String fileFullPath = this.buildImageFileFullPath(file, extension);
                final FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getViewer().getRootEditPart();
                WorkspaceModifyOperation imageSaveOperation = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.Generating, 1);
                        DiagramImageGenerateAction.this.converter.execute(rootEditPart.getLayer((Object)"Printable Layers"), fileFullPath, extension);
                        monitor.worked(1);
                        monitor.done();
                    }
                };
                try {
                    try {
                        new ProgressMonitorDialog(this.getViewer().getControl().getShell()).run(false, false, (IRunnableWithProgress)imageSaveOperation);
                        Activator.showMessageDialog(String.valueOf(this.getText()) + Messages.Completion);
                    }
                    catch (Exception e) {
                        Activator.showErrorDialog(e);
                        try {
                            new Workspace().refreshGenerateResource(fileFullPath);
                        }
                        catch (Exception exception) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        new Workspace().refreshGenerateResource(fileFullPath);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    new Workspace().refreshGenerateResource(fileFullPath);
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean isSupported(String[] extensions, String selectedExtension) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (ext.equals(selectedExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String buildFilterPath(IFile editfile) {
        String separator;
        String path = editfile.getLocation().removeLastSegments(1).toOSString();
        if (!path.endsWith(separator = File.separator)) {
            path = String.valueOf(path) + separator;
        }
        return path;
    }

    private String buildImageFileFullPath(String file, String extension) {
        StringBuilder filePath = new StringBuilder(file);
        if (!file.endsWith(extension)) {
            filePath.append(".");
            filePath.append(extension);
        }
        return filePath.toString();
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }
}

