/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.sphinx.relationshiplist;

import com.google.common.base.Objects;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.RecursiveRelationship;
import org.tmdmaker.core.model.RecursiveTable;

public class RelationshipMapping {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private AbstractEntityModel source;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private AbstractEntityModel target;
    private boolean relationship = false;

    public RelationshipMapping(AbstractEntityModel source, AbstractEntityModel target) {
        this.source = source;
        this.target = target;
        this.relationship = this.hasRecursiveRelationship() || this.hasRelationshipAsSource() || this.hasRelationshipAsTarget();
        boolean _isRecursiveTablePair = this.isRecursiveTablePair();
        if (_isRecursiveTablePair) {
            this.relationship = false;
        }
    }

    private boolean isRecursiveTablePair() {
        if (this.target instanceof RecursiveTable) {
            return ((RecursiveTable)this.target).isSource(this.source);
        }
        if (this.source instanceof RecursiveTable) {
            return ((RecursiveTable)this.source).isSource(this.target);
        }
        return false;
    }

    public boolean hasRecursiveRelationship() {
        return Objects.equal((Object)this.source, (Object)this.target) && IterableExtensions.exists((Iterable)this.source.getModelSourceConnections(), (Functions.Function1)new Functions.Function1<AbstractConnectionModel, Boolean>(){

            public Boolean apply(AbstractConnectionModel c) {
                return c instanceof RecursiveRelationship;
            }
        });
    }

    private boolean hasRelationshipAsSource() {
        Functions.Function1<AbstractConnectionModel, Boolean> _function = new Functions.Function1<AbstractConnectionModel, Boolean>(){

            public Boolean apply(AbstractConnectionModel c) {
                return c.getTarget().equals(RelationshipMapping.this.target);
            }
        };
        return IterableExtensions.exists((Iterable)this.source.getModelSourceConnections(), (Functions.Function1)_function);
    }

    private boolean hasRelationshipAsTarget() {
        Functions.Function1<AbstractConnectionModel, Boolean> _function = new Functions.Function1<AbstractConnectionModel, Boolean>(){

            public Boolean apply(AbstractConnectionModel c) {
                return c.getSource().equals(RelationshipMapping.this.target);
            }
        };
        return IterableExtensions.exists((Iterable)this.source.getModelTargetConnections(), (Functions.Function1)_function);
    }

    public boolean isRelationship() {
        return this.relationship;
    }

    @Pure
    public AbstractEntityModel getSource() {
        return this.source;
    }

    @Pure
    public AbstractEntityModel getTarget() {
        return this.target;
    }
}

