/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.subset;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.parts.ModelName;

public class SubsetBuilder {
    private boolean partitionChanged = false;
    private IAttribute partition;
    private boolean subsetTypeChanged = false;
    private SubsetType.SubsetTypeValue subsetTypeValue = SubsetType.SubsetTypeValue.SAME;
    private boolean exceptNullChanged = false;
    private boolean exceptNull = false;
    private List<ModelName> addSubsetNameList = new ArrayList<ModelName>();
    private List<SubsetType2SubsetRelationship> addedSubsetRelationshipList = new ArrayList<SubsetType2SubsetRelationship>();
    private List<SubsetType2SubsetRelationship> deletedSubsetRelationshipList = new ArrayList<SubsetType2SubsetRelationship>();
    private Entity2SubsetTypeRelationship entity2SubsetTypeRelationship;

    protected SubsetBuilder(AbstractEntityModel model) {
        this.entity2SubsetTypeRelationship = model.subsets().subsetTypeRelationship();
    }

    public void build() {
        SubsetType subsetType = this.buildSubsetType();
        this.removeSubsetEntities();
        this.buildSubsetEntities(subsetType);
        this.changeSubsetTypeState(subsetType);
        if (!subsetType.hasSubsetEntity()) {
            this.entity2SubsetTypeRelationship.disconnect();
        }
    }

    private void changeSubsetTypeState(SubsetType subsetType) {
        if (this.partitionChanged) {
            subsetType.setPartitionAttribute(this.partition);
        }
        if (this.subsetTypeChanged) {
            subsetType.setSubsetType(this.subsetTypeValue);
        }
        if (this.exceptNullChanged) {
            subsetType.setExceptNull(this.exceptNull);
        }
    }

    private void buildSubsetEntities(SubsetType subsetType) {
        if (!this.addSubsetNameList.isEmpty()) {
            if (this.addedSubsetRelationshipList.isEmpty()) {
                for (ModelName name : this.addSubsetNameList) {
                    SubsetType2SubsetRelationship relationship = new SubsetType2SubsetRelationship(subsetType, name);
                    this.addedSubsetRelationshipList.add(relationship);
                }
            }
            for (SubsetType2SubsetRelationship r : this.addedSubsetRelationshipList) {
                r.connect();
            }
        }
    }

    private void removeSubsetEntities() {
        for (SubsetType2SubsetRelationship r : this.deletedSubsetRelationshipList) {
            r.disconnect();
        }
    }

    private SubsetType buildSubsetType() {
        if (!this.entity2SubsetTypeRelationship.isConnected()) {
            this.entity2SubsetTypeRelationship.connect();
        }
        return this.entity2SubsetTypeRelationship.getSubsetType();
    }

    public SubsetBuilder same() {
        this.subsetTypeChanged = true;
        this.subsetTypeValue = SubsetType.SubsetTypeValue.SAME;
        return this;
    }

    public SubsetBuilder different() {
        this.subsetTypeChanged = true;
        this.subsetTypeValue = SubsetType.SubsetTypeValue.DIFFERENT;
        return this;
    }

    public SubsetBuilder partition(IAttribute partition) {
        this.partitionChanged = true;
        this.partition = partition;
        return this;
    }

    public SubsetBuilder expectNull() {
        this.exceptNullChanged = true;
        this.exceptNull = true;
        return this;
    }

    public SubsetBuilder notExpectNull() {
        this.exceptNullChanged = true;
        this.exceptNull = false;
        return this;
    }

    public SubsetBuilder add(ModelName subsetName) {
        this.addSubsetNameList.add(subsetName);
        return this;
    }

    public SubsetBuilder remove(SubsetEntity removeSubset) {
        this.deletedSubsetRelationshipList.add(removeSubset.getSubsetTypeRelationship());
        return this;
    }

    public List<SubsetEntity> getAddedSubsetList() {
        ArrayList<SubsetEntity> addedSubsetList = new ArrayList<SubsetEntity>();
        for (SubsetType2SubsetRelationship r : this.addedSubsetRelationshipList) {
            addedSubsetList.add(r.getSubsetEntity());
        }
        return addedSubsetList;
    }

    public void rollbackAdd() {
        for (SubsetType2SubsetRelationship r : this.addedSubsetRelationshipList) {
            r.disconnect();
        }
        if (!this.entity2SubsetTypeRelationship.getSubsetType().hasSubsetEntity()) {
            this.entity2SubsetTypeRelationship.disconnect();
        }
    }

    public void rollbackRemove() {
        if (!this.entity2SubsetTypeRelationship.isConnected()) {
            this.entity2SubsetTypeRelationship.connect();
        }
        for (SubsetType2SubsetRelationship r : this.deletedSubsetRelationshipList) {
            r.connect();
        }
    }
}

